/*
 * Decompiled with CFR 0.152.
 */
package weblogic.workarea;

import java.io.IOException;
import java.util.Iterator;
import weblogic.kernel.AuditableThreadLocal;
import weblogic.kernel.AuditableThreadLocalFactory;
import weblogic.kernel.ThreadLocalInitialValue;
import weblogic.workarea.NoWorkContextException;
import weblogic.workarea.PropertyReadOnlyException;
import weblogic.workarea.WorkContext;
import weblogic.workarea.WorkContextInput;
import weblogic.workarea.WorkContextLocalMap;
import weblogic.workarea.WorkContextMap;
import weblogic.workarea.WorkContextOutput;
import weblogic.workarea.spi.WorkContextMapInterceptor;

final class WorkContextMapImpl
implements WorkContextMap,
WorkContextMapInterceptor {
    private static final AuditableThreadLocal localContextMap = AuditableThreadLocalFactory.createThreadLocal(new ThreadLocalInitialValue(){

        @Override
        protected Object childValue(Object parentValue) {
            if (parentValue == null) {
                return null;
            }
            return ((WorkContextMapInterceptor)parentValue).copyThreadContexts(2);
        }
    });

    WorkContextMapImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkContext put(String key, WorkContext workContext, int propagationMode) throws PropertyReadOnlyException {
        try {
            WorkContext workContext2 = this.getMap().put(key, workContext, propagationMode);
            return workContext2;
        }
        finally {
            if (this.getMapMaybe().isEmpty()) {
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkContext put(String key, WorkContext workContext) throws PropertyReadOnlyException {
        try {
            WorkContext workContext2 = this.getMap().put(key, workContext);
            return workContext2;
        }
        finally {
            if (this.getMapMaybe().isEmpty()) {
                this.reset();
            }
        }
    }

    @Override
    public WorkContext get(String key) {
        WorkContextMap map = this.getMapMaybe();
        if (map == null) {
            return null;
        }
        return map.get(key);
    }

    @Override
    public WorkContext remove(String key) throws NoWorkContextException, PropertyReadOnlyException {
        WorkContextMap map = this.getMapMaybe();
        if (map == null) {
            throw new NoWorkContextException();
        }
        WorkContext prev = map.remove(key);
        if (map.isEmpty()) {
            this.reset();
        }
        return prev;
    }

    @Override
    public int getPropagationMode(String key) {
        if (this.isEmpty()) {
            return 1;
        }
        return this.getMapMaybe().getPropagationMode(key);
    }

    @Override
    public boolean isPropagationModePresent(int propMode) {
        return this.getMapMaybe().isPropagationModePresent(propMode);
    }

    @Override
    public boolean isEmpty() {
        return this.getMapMaybe() == null;
    }

    private void reset() {
        localContextMap.set(null);
    }

    @Override
    public Iterator iterator() {
        WorkContextMap map = this.getMapMaybe();
        return map == null ? null : map.iterator();
    }

    @Override
    public Iterator keys() {
        WorkContextMap map = this.getMapMaybe();
        return map == null ? null : map.keys();
    }

    @Override
    public int version() {
        WorkContextMapInterceptor map = (WorkContextMapInterceptor)localContextMap.get();
        return map != null ? map.version() : 0;
    }

    private final WorkContextMap getMapMaybe() {
        return (WorkContextMap)localContextMap.get();
    }

    private final WorkContextMap getMap() {
        WorkContextMap map = (WorkContextMap)localContextMap.get();
        if (map == null) {
            map = new WorkContextLocalMap();
            localContextMap.set(map);
        }
        return map;
    }

    public WorkContextMapInterceptor getInterceptor() {
        return (WorkContextMapInterceptor)((Object)this.getMapMaybe());
    }

    public void setInterceptor(WorkContextMapInterceptor interceptor) {
        localContextMap.set(interceptor);
    }

    @Override
    public void sendRequest(WorkContextOutput out, int propagationMode) throws IOException {
        WorkContextMapInterceptor inter = this.getInterceptor();
        if (inter != null) {
            inter.sendRequest(out, propagationMode);
        }
    }

    @Override
    public void sendResponse(WorkContextOutput out, int propagationMode) throws IOException {
        WorkContextMapInterceptor inter = this.getInterceptor();
        if (inter != null) {
            inter.sendResponse(out, 4);
        }
    }

    @Override
    public void receiveRequest(WorkContextInput in) throws IOException {
        ((WorkContextMapInterceptor)((Object)this.getMap())).receiveRequest(in);
    }

    @Override
    public void receiveResponse(WorkContextInput in) throws IOException {
        WorkContextMap map = this.getMapMaybe();
        if (in == null && map == null) {
            return;
        }
        if (map == null) {
            map = new WorkContextLocalMap();
            localContextMap.set(map);
        }
        ((WorkContextMapInterceptor)((Object)map)).receiveResponse(in);
        if (map.isEmpty()) {
            this.reset();
        }
    }

    @Override
    public WorkContextMapInterceptor copyThreadContexts(int mode) {
        WorkContextMapInterceptor inter = this.getInterceptor();
        if (inter != null) {
            return inter.copyThreadContexts(mode);
        }
        return null;
    }

    @Override
    public void restoreThreadContexts(WorkContextMapInterceptor contexts) {
        if (contexts != null) {
            ((WorkContextMapInterceptor)((Object)this.getMap())).restoreThreadContexts(contexts);
        }
    }

    @Override
    public WorkContextMapInterceptor suspendThreadContexts() {
        WorkContextMapInterceptor map = this.getInterceptor();
        if (map != null) {
            this.reset();
        }
        return map;
    }

    @Override
    public void resumeThreadContexts(WorkContextMapInterceptor contexts) {
        localContextMap.set(contexts);
    }
}

