/*
 * Decompiled with CFR 0.152.
 */
package weblogic.workarea;

import java.io.IOException;
import java.security.AccessControlException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.workarea.NoWorkContextException;
import weblogic.workarea.PropertyReadOnlyException;
import weblogic.workarea.WorkContext;
import weblogic.workarea.WorkContextFilter;
import weblogic.workarea.WorkContextHelper;
import weblogic.workarea.WorkContextInput;
import weblogic.workarea.WorkContextMap;
import weblogic.workarea.WorkContextOutput;
import weblogic.workarea.spi.AfterCopyContextsListener;
import weblogic.workarea.spi.AfterReceiveRequestListener;
import weblogic.workarea.spi.AfterSendRequestListener;
import weblogic.workarea.spi.BeforeSendRequestListener;
import weblogic.workarea.spi.WorkContextAccessController;
import weblogic.workarea.spi.WorkContextEntry;
import weblogic.workarea.spi.WorkContextEntryImpl;
import weblogic.workarea.spi.WorkContextMapInterceptor;

final class WorkContextLocalMap
implements WorkContextMap,
WorkContextMapInterceptor {
    private final ConcurrentHashMap map = new ConcurrentHashMap();
    private int version = this.hashCode();
    private static final DebugLogger debugWorkContext = DebugLogger.getDebugLogger("DebugWorkContext");

    WorkContextLocalMap() {
    }

    @Override
    public WorkContext put(String key, WorkContext workContext, int propagationMode) throws PropertyReadOnlyException {
        if (debugWorkContext.isDebugEnabled()) {
            debugWorkContext.debug("put(" + key + ", " + workContext + ")");
        }
        if (key == null || key.equals("")) {
            throw new NullPointerException("Cannot use null key");
        }
        if (workContext == null) {
            throw new NullPointerException("Cannot use null WorkContext");
        }
        WorkContextEntry wce = (WorkContextEntry)this.map.get(key);
        if (wce != null) {
            if (!WorkContextAccessController.isAccessAllowed(key, 2)) {
                throw new PropertyReadOnlyException(key);
            }
        } else if (!WorkContextAccessController.isAccessAllowed(key, 0)) {
            throw new AccessControlException("No CREATE permission for key: \"" + key + "\"");
        }
        this.map.put(key, new WorkContextEntryImpl(key, workContext, propagationMode));
        ++this.version;
        return wce == null ? null : wce.getWorkContext();
    }

    @Override
    public WorkContext put(String key, WorkContext workContext) throws PropertyReadOnlyException {
        return this.put(key, workContext, 212);
    }

    @Override
    public WorkContext get(String key) {
        if (debugWorkContext.isDebugEnabled()) {
            debugWorkContext.debug("get(" + key + ")");
        }
        if (!WorkContextAccessController.isAccessAllowed(key, 1)) {
            throw new AccessControlException("No READ permission for key: \"" + key + "\"");
        }
        WorkContextEntry wce = this.getEntry(key);
        if (wce == WorkContextEntry.NULL_CONTEXT) {
            return null;
        }
        return wce.getWorkContext();
    }

    @Override
    public WorkContext remove(String key) throws NoWorkContextException, PropertyReadOnlyException {
        WorkContextEntry wce;
        if (debugWorkContext.isDebugEnabled()) {
            debugWorkContext.debug("remove(" + key + ")");
        }
        if ((wce = this.getEntry(key)) == WorkContextEntry.NULL_CONTEXT) {
            throw new NoWorkContextException(key);
        }
        if (!wce.isOriginator() && !WorkContextAccessController.isAccessAllowed(key, 3)) {
            throw new PropertyReadOnlyException("No DELETE permission for key: \"" + key + "\"");
        }
        this.map.remove(key);
        ++this.version;
        return wce.getWorkContext();
    }

    @Override
    public int getPropagationMode(String key) {
        if (!WorkContextAccessController.isAccessAllowed(key, 1)) {
            throw new AccessControlException("No READ permission for key: \"" + key + "\"");
        }
        return this.getEntry(key).getPropagationMode();
    }

    @Override
    public boolean isPropagationModePresent(int propMode) {
        boolean status = false;
        for (WorkContextEntry wce : this.map.values()) {
            if (wce == null || (wce.getPropagationMode() & propMode) == 0) continue;
            status = true;
            break;
        }
        return status;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Iterator iterator() {
        return new WorkContextIterator(this);
    }

    @Override
    public Iterator keys() {
        return new WorkContextKeys(this);
    }

    private final WorkContextEntry getEntry(String key) {
        WorkContextEntry wce;
        if (this.map.isEmpty() || (wce = (WorkContextEntry)this.map.get(key)) == null) {
            return WorkContextEntry.NULL_CONTEXT;
        }
        return wce;
    }

    @Override
    public void sendRequest(WorkContextOutput out, int propagationMode) throws IOException {
        if (!WorkContextHelper.beforeSendRequestListeners.isEmpty()) {
            for (BeforeSendRequestListener beforeSendRequestListener : WorkContextHelper.beforeSendRequestListeners) {
                try {
                    beforeSendRequestListener.sendRequest(propagationMode, this);
                }
                catch (Throwable th) {
                    if (!debugWorkContext.isDebugEnabled()) continue;
                    debugWorkContext.debug("beforeSendRequestListeners(" + th.toString() + ")");
                }
            }
        }
        for (WorkContextEntry workContextEntry : this.map.values()) {
            int filteredPropagationMode = WorkContextFilter.getFilteredPropagationMode(workContextEntry.getName(), propagationMode);
            if ((workContextEntry.getPropagationMode() & filteredPropagationMode) == 0) continue;
            if (debugWorkContext.isDebugEnabled()) {
                debugWorkContext.debug("sendRequest(" + workContextEntry.toString() + ")");
            }
            workContextEntry.write(out);
        }
        WorkContextEntry.NULL_CONTEXT.write(out);
        if (!WorkContextHelper.afterSendRequestListeners.isEmpty()) {
            for (AfterSendRequestListener afterSendRequestListener : WorkContextHelper.afterSendRequestListeners) {
                try {
                    afterSendRequestListener.requestSent(propagationMode, this);
                }
                catch (Throwable th) {
                    if (!debugWorkContext.isDebugEnabled()) continue;
                    debugWorkContext.debug("afterSendRequestListeners(" + th.toString() + ")");
                }
            }
        }
    }

    @Override
    public void sendResponse(WorkContextOutput out, int propagationMode) throws IOException {
        for (WorkContextEntry wce : this.map.values()) {
            if ((wce.getPropagationMode() & 0x100) != 0 || (wce.getPropagationMode() & propagationMode) == 0) continue;
            if (debugWorkContext.isDebugEnabled()) {
                debugWorkContext.debug("sendResponse(" + wce.toString() + ")");
            }
            wce.write(out);
        }
        WorkContextEntry.NULL_CONTEXT.write(out);
    }

    @Override
    public void receiveRequest(WorkContextInput in) throws IOException {
        while (true) {
            try {
                WorkContextEntry wce;
                while ((wce = WorkContextEntryImpl.readEntry(in)) != WorkContextEntry.NULL_CONTEXT) {
                    String key = wce.getName();
                    this.map.put(key, wce);
                    if (!debugWorkContext.isDebugEnabled()) continue;
                    debugWorkContext.debug("receiveRequest(" + wce.toString() + ")");
                }
            }
            catch (ClassNotFoundException cnfe) {
                if (!debugWorkContext.isDebugEnabled()) continue;
                debugWorkContext.debug("receiveRequest : ", cnfe);
                continue;
            }
            break;
        }
        if (!WorkContextHelper.afterReceiveRequestListeners.isEmpty()) {
            for (AfterReceiveRequestListener listener : WorkContextHelper.afterReceiveRequestListeners) {
                try {
                    listener.requestReceived(this);
                }
                catch (Throwable th) {
                    if (!debugWorkContext.isDebugEnabled()) continue;
                    debugWorkContext.debug("afterReceiveRequestListeners(" + th.toString() + ")");
                }
            }
        }
    }

    @Override
    public void receiveResponse(WorkContextInput in) throws IOException {
        HashSet<String> propKeySet = new HashSet<String>();
        Iterator i = this.map.values().iterator();
        while (i.hasNext()) {
            WorkContextEntry wce = (WorkContextEntry)i.next();
            int propMode = wce.getPropagationMode();
            if ((propMode & 0x100) != 0 || (propMode & 1) != 0) continue;
            propKeySet.add(wce.getName());
            i.remove();
            ++this.version;
        }
        if (in == null) {
            return;
        }
        block3: while (true) {
            try {
                while (true) {
                    WorkContextEntry wce = WorkContextEntryImpl.readEntry(in);
                    ++this.version;
                    if (wce == WorkContextEntry.NULL_CONTEXT) break block3;
                    if (propKeySet.contains(wce.getName())) {
                        this.map.put(wce.getName(), new WorkContextEntryImpl(wce.getName(), wce.getWorkContext(), wce.getPropagationMode()));
                        continue;
                    }
                    this.map.put(wce.getName(), wce);
                }
            }
            catch (ClassNotFoundException cnfe) {
                if (!debugWorkContext.isDebugEnabled()) continue;
                debugWorkContext.debug("receiveResponse : ", cnfe);
                continue;
            }
            break;
        }
    }

    @Override
    public WorkContextMapInterceptor copyThreadContexts(int mode) {
        if (this.map.isEmpty()) {
            return null;
        }
        WorkContextLocalMap copy = new WorkContextLocalMap();
        copy.map.putAll(this.map);
        copy.version = this.version;
        Iterator i = copy.map.values().iterator();
        while (i.hasNext()) {
            WorkContextEntry e = (WorkContextEntry)i.next();
            if ((e.getPropagationMode() & mode) == 0) {
                i.remove();
            }
            if (!debugWorkContext.isDebugEnabled()) continue;
            debugWorkContext.debug("copyThreadContexts(" + e.toString() + ")");
        }
        if (copy.map.isEmpty()) {
            return null;
        }
        if (!WorkContextHelper.afterCopyContextsListeners.isEmpty()) {
            for (AfterCopyContextsListener listener : WorkContextHelper.afterCopyContextsListeners) {
                try {
                    listener.contextsCopied(mode, this, copy);
                }
                catch (Throwable th) {
                    if (!debugWorkContext.isDebugEnabled()) continue;
                    debugWorkContext.debug("afterCopyContextsListeners(" + th.toString() + ")");
                }
            }
        }
        return copy;
    }

    @Override
    public void restoreThreadContexts(WorkContextMapInterceptor contexts) {
        if (debugWorkContext.isDebugEnabled()) {
            debugWorkContext.debug("restoreThreadContexts(" + (contexts == null ? null : ((WorkContextLocalMap)contexts).map) + ")");
        }
        if (contexts == this) {
            throw new AssertionError((Object)"Cyclic attempt to restore thread contexts");
        }
        if (contexts == null) {
            return;
        }
        this.map.clear();
        this.map.putAll(((WorkContextLocalMap)contexts).map);
        ++this.version;
    }

    @Override
    public WorkContextMapInterceptor suspendThreadContexts() {
        throw new UnsupportedOperationException("suspendThreadContexts()");
    }

    @Override
    public void resumeThreadContexts(WorkContextMapInterceptor contexts) {
        throw new UnsupportedOperationException("resumeThreadContexts()");
    }

    @Override
    public int version() {
        return this.version;
    }

    private static void p(String msg) {
        System.out.println("<WorkContextLocalMap>: " + msg);
    }

    private final class WorkContextKeys
    implements Iterator {
        final Iterator iter;

        private WorkContextKeys(WorkContextLocalMap map) {
            this.iter = map.map.values().iterator();
        }

        @Override
        public void remove() {
            WorkContextLocalMap.this.version++;
            this.iter.remove();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Object next() {
            WorkContextEntry wce = (WorkContextEntry)this.iter.next();
            while (wce != null && !WorkContextAccessController.isAccessAllowed(wce.getName(), 1) && this.hasNext()) {
                wce = (WorkContextEntry)this.iter.next();
            }
            return wce == null ? null : wce.getName();
        }
    }

    private final class WorkContextIterator
    implements Iterator {
        final Iterator iter;

        private WorkContextIterator(WorkContextLocalMap map) {
            this.iter = map.map.values().iterator();
        }

        @Override
        public void remove() {
            WorkContextLocalMap.this.version++;
            this.iter.remove();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Object next() {
            WorkContextEntry wce = (WorkContextEntry)this.iter.next();
            while (wce != null && !WorkContextAccessController.isAccessAllowed(wce.getName(), 1) && this.hasNext()) {
                wce = (WorkContextEntry)this.iter.next();
            }
            return wce == null ? null : wce.getWorkContext();
        }
    }
}

