/*
 * Decompiled with CFR 0.152.
 */
package weblogic.work;

import java.util.ArrayList;
import java.util.List;
import weblogic.utils.UnsyncCircularQueue;
import weblogic.utils.collections.Stack;
import weblogic.work.ExecuteThreadLite;
import weblogic.work.WorkManagerImpl;

public final class WorkManagerLite
extends WorkManagerImpl {
    private static final ThreadGroup THREAD_GROUP = WorkManagerLite.initThreadGroup();
    private static final int THREAD_POOL_SIZE = WorkManagerLite.initThreadPoolSize();
    private final Stack idleThreads = new Stack();
    private final List threadPool = new ArrayList();
    private final UnsyncCircularQueue queue = new UnsyncCircularQueue();
    private static final String THREAD_POOL_SIZE_PROP = "weblogic.thinclient.kernel.ThreadPoolSize";
    private static final int DEFAULT_POOL_SIZE = 5;

    @Override
    public String getName() {
        return this.wmName;
    }

    @Override
    public String getApplicationName() {
        return null;
    }

    @Override
    public String getModuleName() {
        return null;
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public int getConfiguredThreadCount() {
        return this.threadPool.size();
    }

    private static int initThreadPoolSize() {
        try {
            return Integer.getInteger(THREAD_POOL_SIZE_PROP, 5);
        }
        catch (SecurityException se) {
            return 5;
        }
        catch (NumberFormatException nfe) {
            return 5;
        }
    }

    private static ThreadGroup initThreadGroup() {
        try {
            return new ThreadGroup("Pooled Threads");
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    private ExecuteThreadLite create(int id) {
        return new ExecuteThreadLite(id, this, THREAD_GROUP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start(ExecuteThreadLite t) {
        t.start();
        ExecuteThreadLite executeThreadLite = t;
        synchronized (executeThreadLite) {
            while (!t.isStarted()) {
                try {
                    t.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    WorkManagerLite() {
        this.wmName = "direct";
    }

    WorkManagerLite(String name) {
        this(name, THREAD_POOL_SIZE);
    }

    WorkManagerLite(String name, int threadCount) {
        this.wmName = name;
        this.setThreadCount(threadCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setThreadCount(int threadCount) {
        WorkManagerLite workManagerLite = this;
        synchronized (workManagerLite) {
            int firstNew;
            if (threadCount <= this.threadPool.size()) {
                return;
            }
            for (int count = firstNew = this.threadPool.size(); count < threadCount; ++count) {
                ExecuteThreadLite t = this.create(count);
                this.threadPool.add(t);
                this.start(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void schedule(Runnable runnable) {
        if ("direct" == this.wmName) {
            runnable.run();
            return;
        }
        ExecuteThreadLite t = null;
        WorkManagerLite workManagerLite = this;
        synchronized (workManagerLite) {
            if (this.idleThreads.size() > 0) {
                t = (ExecuteThreadLite)this.idleThreads.pop();
            }
            if (t == null) {
                this.queue.put(runnable);
                return;
            }
        }
        t.notifyRequest(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerIdle(ExecuteThreadLite t) {
        Runnable runnable = null;
        WorkManagerLite workManagerLite = this;
        synchronized (workManagerLite) {
            runnable = (Runnable)this.queue.get();
            if (runnable == null) {
                this.idleThreads.push(t);
                return;
            }
        }
        t.setRequest(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean executeIfIdle(Runnable runnable) {
        ExecuteThreadLite t;
        WorkManagerLite workManagerLite = this;
        synchronized (workManagerLite) {
            if (this.idleThreads.size() == 0) {
                return false;
            }
            t = (ExecuteThreadLite)this.idleThreads.pop();
        }
        t.notifyRequest(runnable);
        return true;
    }

    @Override
    public boolean scheduleIfBusy(Runnable runnable) {
        if (this.getQueueDepth() > 0) {
            this.schedule(runnable);
            return true;
        }
        return false;
    }

    @Override
    public int getQueueDepth() {
        return this.queue.size();
    }

    @Override
    public boolean isThreadOwner(Thread th) {
        if (!(th instanceof ExecuteThreadLite)) {
            return false;
        }
        ExecuteThreadLite et = (ExecuteThreadLite)th;
        return this == et.getWorkManager();
    }

    @Override
    public void setInternal() {
    }

    @Override
    public boolean isInternal() {
        return false;
    }
}

