/*
 * Decompiled with CFR 0.152.
 */
package weblogic.work;

import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import weblogic.kernel.KernelStatus;
import weblogic.utils.PlatformConstants;
import weblogic.utils.collections.MaybeMapper;
import weblogic.work.MaxThreadsConstraint;
import weblogic.work.MinThreadsConstraint;
import weblogic.work.RequestClass;
import weblogic.work.SelfTuningWorkManagerImpl;
import weblogic.work.Work;

public abstract class WorkAdapter
implements Work {
    static final MaybeMapper<WorkAdapter> CLAIM_VERSION = new MaybeMapper<WorkAdapter>(){

        @Override
        public WorkAdapter unbox(WorkAdapter w, long v) {
            if (w.claimVersion(v)) {
                return w;
            }
            return null;
        }
    };
    static final MaybeMapper<WorkAdapter> CHECK_EXPIRED_WORK = new MaybeMapper<WorkAdapter>(){

        @Override
        public WorkAdapter unbox(WorkAdapter w, long v) {
            if (v != -1L && w.getVersion() > v) {
                return w;
            }
            return null;
        }
    };
    static final MaybeMapper<WorkAdapter> CHECK_STALE = new MaybeMapper<WorkAdapter>(){

        @Override
        public WorkAdapter unbox(WorkAdapter w, long v) {
            if (w.isCurrentVersion(v)) {
                return w;
            }
            return null;
        }
    };
    SelfTuningWorkManagerImpl wm;
    RequestClass requestClass;
    long creationTimeStamp = System.currentTimeMillis();
    private volatile boolean started;
    private long startedTimeStamp;
    private boolean scheduled;
    private volatile long version = 0L;
    private static final AtomicLongFieldUpdater<WorkAdapter> version_updater;
    static final long SKIP_VERSION_CHECKING = -1L;

    public long getVersion() {
        return this.version;
    }

    boolean isCurrentVersion(long v) {
        return v == -1L || this.getVersion() == v;
    }

    private boolean claimVersion(long v) {
        return v == -1L || this.getVersion() == v && (version_updater == null || version_updater.compareAndSet(this, v, v + 1L));
    }

    void returnForReuse() {
        this.started = false;
        this.creationTimeStamp = -1L;
        this.scheduled = false;
    }

    @Override
    public Runnable overloadAction(String reason) {
        return null;
    }

    @Override
    public Runnable cancel(String reason) {
        return null;
    }

    public void release() {
    }

    public boolean isAdminChannelRequest() {
        return false;
    }

    public boolean isTransactional() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean setScheduled() {
        if (this.scheduled) {
            return false;
        }
        WorkAdapter workAdapter = this;
        synchronized (workAdapter) {
            if (this.scheduled) {
                return false;
            }
            this.scheduled = true;
            if (this.creationTimeStamp <= 0L) {
                this.creationTimeStamp = System.currentTimeMillis();
            }
            return true;
        }
    }

    void setWorkManager(SelfTuningWorkManagerImpl wm) {
        if (wm == null) {
            return;
        }
        this.requestClass = wm.getRequestClass();
        this.wm = wm;
    }

    final SelfTuningWorkManagerImpl getWorkManager() {
        return this.wm;
    }

    final MinThreadsConstraint getMinThreadsConstraint() {
        if (this.wm == null) {
            return null;
        }
        return this.wm.getMinThreadsConstraint();
    }

    final MaxThreadsConstraint getMaxThreadsConstraint() {
        if (this.wm == null) {
            return null;
        }
        return this.wm.getMaxThreadsConstraint();
    }

    protected final boolean isStarted() {
        return this.started;
    }

    final void started() {
        this.started = true;
        this.startedTimeStamp = System.currentTimeMillis();
    }

    final Runnable getWork() {
        Runnable cancelTask;
        if (this.wm != null && this.wm.isShutdown() && (cancelTask = this.cancel(this.wm.getCancelMessage())) != null) {
            return cancelTask;
        }
        return this;
    }

    public String getDescription() {
        return null;
    }

    final String dump() {
        StringBuffer sb = new StringBuffer();
        sb.append("Workmanager: " + (this.wm != null ? this.wm.getName() : "") + ", ");
        sb.append("Version: " + this.getVersion() + ", ");
        sb.append("Scheduled=" + this.scheduled + ", Started=" + this.started + ", ");
        if (!this.started) {
            sb.append("Wait time: " + (System.currentTimeMillis() - this.creationTimeStamp) + " ms");
        } else {
            sb.append("Started time: " + (System.currentTimeMillis() - this.startedTimeStamp) + " ms");
        }
        sb.append(PlatformConstants.EOL);
        return sb.toString();
    }

    public String toString() {
        return this.dump();
    }

    static {
        AtomicLongFieldUpdater<WorkAdapter> updater = null;
        if (!KernelStatus.isApplet()) {
            updater = AtomicLongFieldUpdater.newUpdater(WorkAdapter.class, "version");
        }
        version_updater = updater;
    }
}

