/*
 * Decompiled with CFR 0.152.
 */
package weblogic.work;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import weblogic.work.ExecuteThread;
import weblogic.work.RequestClass;
import weblogic.work.SelfTuningWorkManagerImpl;
import weblogic.work.ServiceClassStatsSupport;
import weblogic.work.ServiceClassSupport;
import weblogic.work.WorkAdapter;

final class ThreadPriorityManager {
    private static final String disableThreadPriorityProp = "weblogic.DisableThreadPriority";
    private static final boolean DISABLE_THREAD_PRIORITY = ThreadPriorityManager.initProperty("weblogic.DisableThreadPriority", false);
    private static final long PERIOD = 6000L;
    private static final double SHORT_OUTLIER_MULTIPLE = 1.5;
    private static final double LONG_OUTLIER_MULTIPLE = 2.0;
    private static final int MIN_PRIORITY = 1;
    private static final int LOW_PRIORITY = 2;
    private static final int NORMAL_PRIORITY = 5;
    private static final int HIGH_PRIORITY = 9;
    private long lastExecutionTime;
    private long sum;
    private long square;
    private long count;

    private static boolean initProperty(String name, boolean defaultValue) {
        try {
            return Boolean.getBoolean(name);
        }
        catch (SecurityException se) {
            return defaultValue;
        }
    }

    private ThreadPriorityManager() {
    }

    public static ThreadPriorityManager getInstance() {
        return Factory.THE_ONE;
    }

    void computeThreadPriorities(List requestClasses) {
        try {
            if (ThreadPriorityManager.isDisabled() || this.notDueForExecution()) {
                return;
            }
            if (requestClasses == null || requestClasses.size() == 0) {
                return;
            }
            this.count = 0L;
            this.sum = 0L;
            this.square = 0L;
            for (ServiceClassSupport requestClass : requestClasses) {
                long increment = requestClass.getIncrementForThreadPriorityCalculation();
                ++this.count;
                if (ThreadPriorityManager.debugEnabled()) {
                    ThreadPriorityManager.log(requestClass.getName() + " has incr " + increment);
                }
                this.sum += increment;
                this.square += increment * increment;
            }
            if (this.count < 2L) {
                return;
            }
            double mean = ServiceClassStatsSupport.div(this.sum, this.count);
            double stdev = ServiceClassStatsSupport.stdev(this.sum, this.square, this.count);
            long previousCount = this.count;
            this.count = 0L;
            this.sum = 0L;
            this.square = 0L;
            List subset = this.assignThreadPriorityToRequestClasses(requestClasses, mean, stdev);
            if (subset == null || (long)subset.size() == previousCount || subset.size() < 2) {
                return;
            }
            mean = ServiceClassStatsSupport.div(this.sum, this.count);
            stdev = ServiceClassStatsSupport.stdev(this.sum, this.square, this.count);
            this.assignThreadPriorityToRequestClasses(subset, mean, stdev);
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    private static boolean isDisabled() {
        return DISABLE_THREAD_PRIORITY;
    }

    private boolean notDueForExecution() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastExecutionTime < 6000L) {
            return true;
        }
        this.lastExecutionTime = currentTime;
        return false;
    }

    private List assignThreadPriorityToRequestClasses(List requestClasses, double mean, double stdev) {
        if (stdev == 0.0) {
            return null;
        }
        if (ThreadPriorityManager.debugEnabled()) {
            ThreadPriorityManager.log("[mean] " + mean);
        }
        if (ThreadPriorityManager.debugEnabled()) {
            ThreadPriorityManager.log("[stdev] " + stdev);
        }
        ArrayList<ServiceClassSupport> subset = new ArrayList<ServiceClassSupport>();
        for (ServiceClassSupport requestClass : requestClasses) {
            long increment = requestClass.getIncrementForThreadPriorityCalculation();
            if (ThreadPriorityManager.lowerThreadPriority(increment, mean, stdev)) {
                if (requestClass.isInternal()) continue;
                if (ThreadPriorityManager.debugEnabled()) {
                    ThreadPriorityManager.log(requestClass.getName() + " with incr " + increment + " is set to low thread priority");
                }
                requestClass.setThreadPriority(2);
                continue;
            }
            if (ThreadPriorityManager.increaseThreadPriority(increment, mean, stdev)) {
                if (ThreadPriorityManager.debugEnabled()) {
                    ThreadPriorityManager.log(requestClass.getName() + " with incr " + increment + " is set to high thread priority");
                }
                requestClass.setThreadPriority(9);
            } else if (requestClass.getThreadPriority() > 1) {
                requestClass.setThreadPriority(5);
            }
            subset.add(requestClass);
            ++this.count;
            this.sum += increment;
            this.square += increment * increment;
            if (!ThreadPriorityManager.debugEnabled()) continue;
            ThreadPriorityManager.log(requestClass.getName() + " thread priority is " + requestClass.getThreadPriority());
        }
        return subset;
    }

    private static boolean increaseThreadPriority(long increment, double mean, double stdev) {
        boolean largeStdev = 2.0 * stdev > mean;
        double factor = 2.0;
        if (largeStdev) {
            factor = 1.0;
        }
        return (double)increment < mean - factor * stdev;
    }

    private static boolean lowerThreadPriority(long increment, double mean, double stdev) {
        boolean largeStdev = 2.0 * stdev > mean;
        double factor = 2.0;
        if (largeStdev) {
            factor = 1.5;
        }
        return (double)increment > mean + factor * stdev;
    }

    private static void setThreadPriority(Thread th, int priority) {
        try {
            if (th.getPriority() != priority) {
                th.setPriority(priority);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    static void handleHogger(Thread th, boolean internalWork) {
        if (ThreadPriorityManager.isDisabled()) {
            return;
        }
        if (internalWork) {
            ThreadPriorityManager.setThreadPriority(th, 5);
        } else {
            ThreadPriorityManager.setThreadPriority(th, 1);
        }
    }

    static boolean lowerPriority(ExecuteThread thread, int amountToLower) {
        if (thread == null || amountToLower < 1) {
            return false;
        }
        int currentPriority = thread.getPriority();
        if (currentPriority == 1 || thread.isExecutingInternalWork()) {
            return false;
        }
        int newPriority = currentPriority - amountToLower;
        if (newPriority < 1) {
            newPriority = 1;
        }
        try {
            thread.setPriority(newPriority);
            if (ThreadPriorityManager.debugEnabled()) {
                ThreadPriorityManager.log("lowerPriority set priority of thread '" + thread.toString() + "' to " + newPriority);
            }
        }
        catch (SecurityException e) {
            if (ThreadPriorityManager.debugEnabled()) {
                ThreadPriorityManager.log("lowerPriority unable to set priority of thread '" + thread.toString() + "' due to " + e);
            }
            return false;
        }
        return true;
    }

    static boolean restorePriority(ExecuteThread thread) {
        RequestClass requestClass;
        if (thread == null || thread.isExecutingInternalWork()) {
            return false;
        }
        if (!thread.isUnderExecution()) {
            return true;
        }
        int targetPriority = 5;
        WorkAdapter executingWork = thread.getCurrentWork();
        if (executingWork != null && (requestClass = executingWork.requestClass) != null) {
            targetPriority = requestClass.getThreadPriority();
        }
        try {
            if (ThreadPriorityManager.debugEnabled()) {
                ThreadPriorityManager.log("restorePriority set priority of thread '" + thread.toString() + "' to " + targetPriority);
            }
            thread.setPriority(targetPriority);
        }
        catch (SecurityException e) {
            if (ThreadPriorityManager.debugEnabled()) {
                ThreadPriorityManager.log("restorePriority unable to set priority of thread '" + thread.toString() + "' due to " + e);
            }
            return false;
        }
        return true;
    }

    static boolean interrupt(ExecuteThread thread) {
        if (thread == null || thread.isExecutingInternalWork()) {
            return false;
        }
        try {
            thread.interrupt();
            if (ThreadPriorityManager.debugEnabled()) {
                ThreadPriorityManager.log("interrupted thread '" + thread.toString());
            }
        }
        catch (SecurityException e) {
            if (ThreadPriorityManager.debugEnabled()) {
                ThreadPriorityManager.log("interrupt on thread '" + thread.toString() + "' failed due to " + e);
            }
            return false;
        }
        return true;
    }

    private static boolean debugEnabled() {
        return SelfTuningWorkManagerImpl.debugEnabled();
    }

    private static void log(String str) {
        SelfTuningWorkManagerImpl.debug("<ThreadPriorityManager>" + str);
    }

    private static final class Factory {
        static final ThreadPriorityManager THE_ONE = new ThreadPriorityManager();

        private Factory() {
        }
    }
}

