/*
 * Decompiled with CFR 0.152.
 */
package weblogic.work;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import weblogic.utils.Debug;
import weblogic.work.IncrementAdvisor2;
import weblogic.work.MaxThreadsConstraint;
import weblogic.work.WorkAdapter;
import weblogic.work.WorkManagerLogger;

public class PartitionMaxThreadsConstraint
extends MaxThreadsConstraint {
    private List<MaxThreadsConstraint> maxThreadsConstraintList = new CopyOnWriteArrayList<MaxThreadsConstraint>();
    private AtomicInteger lastGetNextIndex = new AtomicInteger(0);
    private static boolean DEBUG = Debug.getCategory("weblogic.MaxThreadsConstraint").isEnabled();
    private int slowDownLevel = 10;

    protected PartitionMaxThreadsConstraint(String name) {
        super(name);
    }

    protected PartitionMaxThreadsConstraint(String name, int count) {
        super(name, count);
    }

    public PartitionMaxThreadsConstraint(String name, int count, int queueSize) {
        super(name, count, queueSize, null);
    }

    void add(MaxThreadsConstraint maxThreadsConstraint) {
        this.maxThreadsConstraintList.add(maxThreadsConstraint);
    }

    void remove(MaxThreadsConstraint maxThreadsConstraint) {
        this.maxThreadsConstraintList.remove(maxThreadsConstraint);
    }

    @Override
    WorkAdapter getNext() {
        WorkAdapter entry = this.getNextInternal();
        if (entry == null && this.mark.isEnabled() && !this.maxThreadsConstraintList.isEmpty()) {
            int size = this.maxThreadsConstraintList.size();
            if (size == 1) {
                return this.maxThreadsConstraintList.get(0).getNextInternal();
            }
            int endPos = this.lastGetNextIndex.getAndIncrement() % size;
            if (endPos < 0) {
                endPos = 0;
                this.lastGetNextIndex.set(0);
            }
            int index = endPos;
            do {
                ++index;
                MaxThreadsConstraint maxThreadsConstraint = this.maxThreadsConstraintList.get(index %= size);
                if (!maxThreadsConstraint.reserveIfConstraintNotReached() || (entry = maxThreadsConstraint.getNextInternal()) != null) continue;
                maxThreadsConstraint.release();
            } while (entry == null && index != endPos);
        }
        return entry;
    }

    @Override
    protected WorkAdapter getNextInternal() {
        WorkAdapter entry = this.queue.poll(WorkAdapter.CLAIM_VERSION);
        if (entry == null) {
            this.logConstraintReached.compareAndSet(true, false);
        } else if (DEBUG) {
            PartitionMaxThreadsConstraint.log("--: [" + entry + "] to '" + this.name + "'. Queue length=" + this.queue.size() + ", inProgress=" + this.getExecutingCount());
        }
        return entry;
    }

    WorkAdapter getNext(MaxThreadsConstraint other) {
        WorkAdapter entry;
        assert (other != null);
        if (other.getQueueSize() >= this.getQueueSize() && (entry = other.getNextInternal()) != null) {
            return entry;
        }
        entry = this.getNextInternal();
        if (entry == null) {
            entry = other.getNextInternal();
        } else {
            other.release(false);
        }
        return entry;
    }

    @Override
    boolean reserveIfConstraintNotReached() {
        if (!this.mark.isEnabled()) {
            this.mark.decreaseLevel(1);
            if (DEBUG) {
                PartitionMaxThreadsConstraint.log("reserveIfConstraintNotReached: " + this.name + " returning true because constraint is not enabled");
            }
            return true;
        }
        if (DEBUG) {
            int beforeExec = this.mark.diff();
            boolean b = this.mark.tryDecreaseByOne();
            int afterExec = this.mark.diff();
            PartitionMaxThreadsConstraint.log("reserveIfConstraintNotReached: " + this.name + " before=" + beforeExec + " ,after=" + afterExec + " ,result=" + b);
            return b;
        }
        return this.mark.tryDecreaseByOne();
    }

    @Override
    boolean releaseIfConstraintOverSubscribed() {
        if (!this.mark.isEnabled()) {
            if (DEBUG) {
                PartitionMaxThreadsConstraint.log("releaseIfConstraintOverSubscribed: " + this.name + " returning false because constraint is not enabled");
            }
            return false;
        }
        if (DEBUG) {
            int beforeExec = this.mark.diff();
            boolean b = this.mark.tryIncreaseByOneIfBelowZero();
            int afterExec = this.mark.diff();
            PartitionMaxThreadsConstraint.log("releaseIfConstraintOverSubscribed: " + this.name + " before=" + beforeExec + " ,after=" + afterExec + " ,result=" + b);
            return b;
        }
        return this.mark.tryIncreaseByOneIfBelowZero();
    }

    @Override
    void acquire() {
        if (DEBUG) {
            int beforeExec = this.mark.diff();
            this.mark.decreaseLevel(1);
            int afterExec = this.mark.diff();
            PartitionMaxThreadsConstraint.log("acquire: " + this.name + " before=" + beforeExec + " ,after=" + afterExec);
            return;
        }
        this.mark.decreaseLevel(1);
    }

    @Override
    void release() {
        if (DEBUG) {
            int beforeExec = this.mark.diff();
            this.mark.increaseLevel(1);
            int afterExec = this.mark.diff();
            PartitionMaxThreadsConstraint.log("release: " + this.name + " before=" + beforeExec + " ,after=" + afterExec);
            return;
        }
        this.mark.increaseLevel(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setSlowDownLevel(int newLevel) {
        if (newLevel < 1 || newLevel > 10) {
            return false;
        }
        PartitionMaxThreadsConstraint partitionMaxThreadsConstraint = this;
        synchronized (partitionMaxThreadsConstraint) {
            this.slowDownLevel = newLevel;
            int targetCount = this.getTargetCount(this.getConfiguredCount(), newLevel);
            this.mark.resetLevel(targetCount);
        }
        return true;
    }

    private int getTargetCount(int newCount, int newSlowDownLevel) {
        int targetCount;
        if (newSlowDownLevel == 10) {
            return newCount;
        }
        int startingCount = newCount;
        if (newCount == 0) {
            startingCount = IncrementAdvisor2.getMaxThreadPoolSize();
        }
        if ((targetCount = (int)((double)((float)startingCount / 10.0f * (float)newSlowDownLevel) + 0.5)) < 1) {
            targetCount = 1;
        }
        return targetCount;
    }

    @Override
    protected int resetWaterMarkLevel(int newCount) {
        int targetCount = this.getTargetCount(newCount, this.slowDownLevel);
        this.mark.resetLevel(targetCount);
        return targetCount;
    }

    @Override
    public boolean isPartitionMaxThreadsConstraint() {
        return true;
    }

    private static void log(String str) {
        if (DEBUG) {
            WorkManagerLogger.logDebug("<PartitionMaxTC>" + str);
        }
    }

    @Override
    protected void doLogConstraintReached() {
        WorkManagerLogger.logPartitionMaxThreadsConstraintReached(this.name);
    }

    @Override
    protected void doLogConstraintReachedGathered(int currentValue, long duration) {
        WorkManagerLogger.logPartitionMaxThreadsConstraintReachedGathered(this.name, currentValue, duration);
    }

    @Override
    protected void doLogConstraintQueueFull(String wmName, int maxCapacity) {
        WorkManagerLogger.logPartitionMaxThreadsConstraintQueueFull(this.name, wmName, maxCapacity);
    }

    @Override
    protected void doLogConstraintQueueFullGathered(String wmName, int maxCapacity, int currentValue, long duration) {
        WorkManagerLogger.logPartitionMaxThreadsConstraintQueueFullGathered(this.name, wmName, maxCapacity, currentValue, duration);
    }

    @Override
    protected String getConstraintQueueFullExceptionMessage(String wmName, int maxCapacity) {
        return WorkManagerLogger.logPartitionMaxThreadsConstraintQueueFullLoggable(this.name, wmName, maxCapacity).getMessage();
    }

    List<MaxThreadsConstraint> getMaxThreadsConstraintList() {
        return this.maxThreadsConstraintList;
    }
}

