/*
 * Decompiled with CFR 0.152.
 */
package weblogic.work;

import java.util.ArrayList;
import java.util.List;
import weblogic.utils.Debug;
import weblogic.work.ServiceClassesStats;
import weblogic.work.WorkManagerLogger;

public class PartitionFairShare {
    private static boolean DEBUG = Debug.getCategory("weblogic.PartitionFairShare").isEnabled() || Debug.getCategory("weblogic.requestclass").isEnabled();
    static final double DEFAULT_ADJUSTER = 1.0;
    static long THREAD_USE_THRESHOLD = Long.getLong("weblogic.work.PartitionFairShare.threadUseThreshold", 1000L);
    static int MAX_RC_COMPLETION_COUNT_THRESHOLD = Integer.getInteger("weblogic.work.PartitionFairShare.maxRcCompletionCountThreshold", 10);
    static final int DEFAULT_PARTITION_FAIR_SHARE = 50;
    private int slowDownLevel = 10;
    private int fairShare;
    private int configuredFairShare;
    private String name;
    double partitionAdjuster = 1.0;
    double weighedIncrementSum;
    long threadUseSum;
    long maxThreadUse;
    int maxThreadUseCompletedCount;
    volatile double partitionAdjusterSnapShot;
    volatile long threadUseSumSnapShot;
    static long sumPartitionFairShares;
    static double avgPartitionFairShares;
    static final List<PartitionFairShare> partitionFairShares;

    static void clear() {
        partitionFairShares.clear();
        sumPartitionFairShares = 0L;
        avgPartitionFairShares = 0.0;
    }

    public static PartitionFairShare createPartitionFairShare(String name) {
        return PartitionFairShare.createPartitionFairShare(name, 50);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PartitionFairShare createPartitionFairShare(String name, int fairShare) {
        PartitionFairShare partitionFairShare = new PartitionFairShare(name, fairShare);
        List<PartitionFairShare> list = partitionFairShares;
        synchronized (list) {
            partitionFairShares.add(partitionFairShare);
            avgPartitionFairShares = (double)(sumPartitionFairShares += (long)fairShare) / (double)partitionFairShares.size();
        }
        return partitionFairShare;
    }

    private PartitionFairShare(String name, int fairShare) {
        this.name = name;
        this.fairShare = fairShare;
        this.configuredFairShare = fairShare;
    }

    public int getFairShare() {
        return this.fairShare;
    }

    int getConfiguredFairShare() {
        return this.configuredFairShare;
    }

    long getThreadUseSum() {
        return this.threadUseSum;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void resetAll(ServiceClassesStats stats) {
        double allPartitionsWeighedIncrementsSum = 0.0;
        long allPartitionsThreadUseSum = 0L;
        int allPartitionsMaxUseCompleted = 0;
        long allPartitionsMaxThreadUse = 0L;
        List<PartitionFairShare> list = partitionFairShares;
        synchronized (list) {
            for (PartitionFairShare partitionFairShare : partitionFairShares) {
                if (partitionFairShare.threadUseSum <= THREAD_USE_THRESHOLD) continue;
                allPartitionsWeighedIncrementsSum += partitionFairShare.weighedIncrementSum;
                allPartitionsThreadUseSum += partitionFairShare.threadUseSum;
                long partitionMaxUseCompleted = partitionFairShare.maxThreadUseCompletedCount;
                if (partitionMaxUseCompleted <= (long)MAX_RC_COMPLETION_COUNT_THRESHOLD) continue;
                allPartitionsMaxThreadUse += partitionFairShare.maxThreadUse;
                allPartitionsMaxUseCompleted = (int)((long)allPartitionsMaxUseCompleted + partitionMaxUseCompleted);
            }
            double avgIncrement = allPartitionsThreadUseSum == 0L ? 0.0 : allPartitionsWeighedIncrementsSum / (double)allPartitionsThreadUseSum;
            double avgRequestTime = allPartitionsMaxUseCompleted == 0 ? 0.0 : (double)allPartitionsMaxThreadUse / (double)allPartitionsMaxUseCompleted;
            for (PartitionFairShare partitionFairShare : partitionFairShares) {
                partitionFairShare.reset(stats, avgIncrement, avgRequestTime);
            }
        }
    }

    private void reset(ServiceClassesStats stats, double allPartitionsAvgIncrement, double allPartitionsMaxRCAvgRequestTime) {
        double avgIncrement;
        double d = avgIncrement = this.threadUseSum == 0L ? 0.0 : this.weighedIncrementSum / (double)this.threadUseSum;
        if (this.threadUseSum > THREAD_USE_THRESHOLD) {
            double incrementAdjuster = allPartitionsAvgIncrement / avgIncrement * (double)(this.threadUseSum / this.maxThreadUse);
            this.partitionAdjuster = 1.0;
            double partitionMaxRCAvgRequestTime = (double)this.maxThreadUse / (double)this.maxThreadUseCompletedCount;
            double perRequestThreadUseAdjustment = 1.0;
            if (this.maxThreadUseCompletedCount > MAX_RC_COMPLETION_COUNT_THRESHOLD) {
                perRequestThreadUseAdjustment = partitionMaxRCAvgRequestTime / allPartitionsMaxRCAvgRequestTime;
            }
            if (this.threadUseSum > 0L) {
                this.partitionAdjuster = incrementAdjuster * avgPartitionFairShares / (double)this.fairShare * perRequestThreadUseAdjustment;
            }
            if (DEBUG) {
                double threadUsePercent = 0.0;
                if ((double)stats.getThreadUseSum() > 0.0) {
                    threadUsePercent = (double)this.threadUseSum / (double)stats.getThreadUseSum();
                }
                double partitionAllocation = (double)this.fairShare / (double)sumPartitionFairShares;
                PartitionFairShare.log("partition '" + this.name + "' - threadUsePercent = " + threadUsePercent * 100.0 + "%, target ratio = " + partitionAllocation * 100.0 + "%, partitionMaxRCAvgRequestTime = " + partitionMaxRCAvgRequestTime + ", allPartitionMaxRCAvgRequestTime = " + allPartitionsMaxRCAvgRequestTime + ", perRequestThreadUseAdjuster = " + perRequestThreadUseAdjustment + ", avgIncrement = " + avgIncrement + ", allPartitionsAvgIncrement = " + allPartitionsAvgIncrement + ", incrementAdjuster is " + incrementAdjuster + ", partitionAdjuster = " + this.partitionAdjuster);
            }
        }
        this.partitionAdjusterSnapShot = this.partitionAdjuster;
        this.threadUseSumSnapShot = this.threadUseSum;
        this.weighedIncrementSum = 0.0;
        this.threadUseSum = 0L;
        this.maxThreadUse = 0L;
        this.maxThreadUseCompletedCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deregister(PartitionFairShare partitionFairShare) {
        List<PartitionFairShare> list = partitionFairShares;
        synchronized (list) {
            partitionFairShares.remove(partitionFairShare);
            avgPartitionFairShares = (double)(sumPartitionFairShares -= (long)partitionFairShare.getFairShare()) / (double)partitionFairShares.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFairShare(int newConfiguredFairShare) {
        if (this.configuredFairShare == newConfiguredFairShare) {
            return;
        }
        int delta = 0;
        PartitionFairShare partitionFairShare = this;
        synchronized (partitionFairShare) {
            int oldFairShare = this.fairShare;
            int newFairShare = newConfiguredFairShare;
            if (this.configuredFairShare != this.fairShare) {
                newFairShare = this.slowDownLevel == 10 ? newConfiguredFairShare * oldFairShare / this.configuredFairShare : (int)((double)((float)newConfiguredFairShare / 10.0f * (float)this.slowDownLevel) + 0.5);
            }
            delta = newFairShare - this.fairShare;
            if (DEBUG) {
                PartitionFairShare.log("setFairShare(" + newConfiguredFairShare + "). Original configuredFairShare=" + this.configuredFairShare + ", original fairShare=" + oldFairShare + ", new fairShare=" + newFairShare);
            }
            this.configuredFairShare = newConfiguredFairShare;
            this.fairShare = newFairShare;
        }
        this.updatePartitionFairSharesValues(delta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updatePartitionFairSharesValues(int delta) {
        if (delta == 0) {
            return;
        }
        List<PartitionFairShare> list = partitionFairShares;
        synchronized (list) {
            avgPartitionFairShares = (double)(sumPartitionFairShares += (long)delta) / (double)partitionFairShares.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setSlowDownLevel(int newLevel) {
        int delta;
        if (newLevel < 1 || newLevel > 10) {
            return false;
        }
        int updatedFairShare = (int)((double)((float)this.configuredFairShare / 10.0f * (float)newLevel) + 0.5);
        if (updatedFairShare < 1) {
            updatedFairShare = 1;
        }
        double origPartitionAdjuster = this.partitionAdjuster;
        PartitionFairShare partitionFairShare = this;
        synchronized (partitionFairShare) {
            delta = updatedFairShare - this.fairShare;
            int originalFairShare = this.fairShare;
            this.fairShare = updatedFairShare;
            this.slowDownLevel = newLevel;
            this.partitionAdjuster = this.partitionAdjuster * (double)originalFairShare / (double)this.fairShare;
        }
        this.updatePartitionFairSharesValues(delta);
        if (DEBUG) {
            PartitionFairShare.log("setSlowDownLevel(" + newLevel + ") updated fairShare to " + updatedFairShare + " for partition '" + this.name + "', partitionAdjuster:" + origPartitionAdjuster + "-->" + this.partitionAdjuster);
        }
        return true;
    }

    double getPartitionAdjuster(long threadUse, int completed, double increment) {
        if (threadUse > 0L) {
            if (DEBUG) {
                PartitionFairShare.log("Adding usage sample: (" + threadUse + "ms, " + completed + ", " + increment + ") for partition '" + this.name + "'");
            }
            this.weighedIncrementSum += increment * (double)threadUse;
            this.threadUseSum += threadUse;
            if (threadUse > this.maxThreadUse) {
                this.maxThreadUse = threadUse;
                this.maxThreadUseCompletedCount = completed;
            }
        }
        return this.partitionAdjuster;
    }

    double getPartitionAdjuster() {
        return this.partitionAdjuster;
    }

    double getPartitionAdjusterSnapShot() {
        return this.partitionAdjusterSnapShot;
    }

    long getThreadUseSumSnapShot() {
        return this.threadUseSumSnapShot;
    }

    private static void log(String str) {
        if (DEBUG) {
            WorkManagerLogger.logDebug("<PartitionFairShare>" + str);
        }
    }

    static {
        partitionFairShares = new ArrayList<PartitionFairShare>();
    }
}

