/*
 * Decompiled with CFR 0.152.
 */
package weblogic.work;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import weblogic.invocation.ComponentInvocationContext;
import weblogic.invocation.spi.ComponentRequest;
import weblogic.utils.collections.ConcurrentPool;
import weblogic.work.ExecuteThread;
import weblogic.work.RequestManager;
import weblogic.work.SelfTuningWorkManagerImpl;
import weblogic.work.WorkAdapter;

public class PartitionAffinityThreadPool {
    private final ConcurrentPool<ExecuteThread> commonPool;
    private final ConcurrentHashMap<String, PartitionedPoolEntry> partitionedCache = new ConcurrentHashMap();
    static final int PER_PARTITION_POOL_SIZE = 10;
    static final boolean DISABLE_RCM_MODE = Boolean.getBoolean("weblogic.work.disableRCMmode");
    final boolean isStandbyPool;
    final boolean isolatePartitionThreadLocal;
    volatile boolean RCM_MODE;
    AtomicInteger getMatchingThreadSucceed = new AtomicInteger();
    AtomicInteger getMatchingThreadFailed = new AtomicInteger();
    AtomicInteger switchIdleThreadNotNeeded = new AtomicInteger();
    AtomicInteger switchIdleThreadGotFromStandby = new AtomicInteger();
    AtomicInteger switchIdleThreadFailed = new AtomicInteger();
    AtomicInteger switchStandbyThreadNotNeeded = new AtomicInteger();
    AtomicInteger switchStandbyThreadSucceeded = new AtomicInteger();
    AtomicInteger switchStandbyThreadFailed = new AtomicInteger();

    public PartitionAffinityThreadPool(int commonPoolSize, boolean isStandbyPool, boolean isoloatePartitionThreadLocal) {
        this.commonPool = new ConcurrentPool(commonPoolSize);
        this.isStandbyPool = isStandbyPool;
        this.isolatePartitionThreadLocal = isoloatePartitionThreadLocal;
    }

    boolean addPartition(String partitionName, boolean rcmEnabled) {
        if (DISABLE_RCM_MODE) {
            return true;
        }
        if (rcmEnabled || this.isolatePartitionThreadLocal) {
            if (!this.RCM_MODE) {
                this.RCM_MODE = true;
                if (PartitionAffinityThreadPool.debugEnabled()) {
                    PartitionAffinityThreadPool.log("RCM mode is being turned on. isolatePartitionThreadLocal is: " + this.isolatePartitionThreadLocal);
                }
                this.internalAddPartition("DOMAIN");
            }
            return this.internalAddPartition(partitionName);
        }
        return false;
    }

    boolean internalAddPartition(String partitionName) {
        PartitionedPoolEntry newPartitionPool = new PartitionedPoolEntry();
        return this.partitionedCache.putIfAbsent(partitionName, newPartitionPool) == null;
    }

    List<ExecuteThread> removePartition(String partitionName) {
        PartitionedPoolEntry removedPartitionPool;
        ArrayList<ExecuteThread> extraThreads = new ArrayList<ExecuteThread>();
        if (this.RCM_MODE && partitionName != null && (removedPartitionPool = this.partitionedCache.remove(partitionName)) != null) {
            ExecuteThread threadToMove = removedPartitionPool.poll();
            while (threadToMove != null) {
                if (!this.commonPool.offer(threadToMove)) {
                    extraThreads.add(threadToMove);
                }
                threadToMove = removedPartitionPool.poll();
            }
        }
        return extraThreads;
    }

    boolean offer(ExecuteThread t) {
        PartitionedPoolEntry pool;
        String partitionName;
        if (this.RCM_MODE && (partitionName = t.getPreviousPartitionName()) != null && (pool = this.partitionedCache.get(partitionName)) != null && pool.offer(t)) {
            return true;
        }
        return this.commonPool.offer(t);
    }

    ExecuteThread getMatching(String partitionName) {
        ExecuteThread matchingThread;
        PartitionedPoolEntry pool;
        if (partitionName != null && (pool = this.partitionedCache.get(partitionName)) != null && (matchingThread = pool.poll()) != null) {
            if (PartitionAffinityThreadPool.debugEnabled()) {
                this.getMatchingThreadSucceed.getAndIncrement();
            }
            return matchingThread;
        }
        if (PartitionAffinityThreadPool.debugEnabled()) {
            this.getMatchingThreadFailed.getAndIncrement();
        }
        return null;
    }

    ExecuteThread poll(WorkAdapter workEntry) {
        if (this.RCM_MODE) {
            String partitionForWorkEntry = this.getPartitionName(workEntry);
            ExecuteThread result = this.getMatching(partitionForWorkEntry);
            if (result == null) {
                result = this.commonPool.poll();
                if (result == null) {
                    Iterator<PartitionedPoolEntry> iterator = this.partitionedCache.values().iterator();
                    while (iterator.hasNext() && result == null) {
                        PartitionedPoolEntry pool = iterator.next();
                        if (pool == null) continue;
                        result = pool.poll();
                    }
                }
                if (result != null && !this.isStandbyPool && workEntry != null) {
                    this.clearThreadLocalIfDifferentPartition(result, partitionForWorkEntry);
                }
            }
            return result;
        }
        ExecuteThread result = this.commonPool.poll();
        if (result != null && !this.isStandbyPool && workEntry != null) {
            this.clearThreadLocalIfDifferentPartition(result, this.getPartitionName(workEntry));
        }
        return result;
    }

    private void clearThreadLocalIfDifferentPartition(ExecuteThread thread, String partitionForNextWork) {
        if (this.isolatePartitionThreadLocal && !ExecuteThread.isCleanupTLAfterEachRequest() && !this.partitionNameMatches(thread.getPreviousPartitionName(), partitionForNextWork)) {
            thread.forceEraseThreadLocals();
        }
    }

    ExecuteThread switchThreadWithPartitionAffinity(ExecuteThread activeThread, WorkAdapter workAdapter, boolean isIdleThread) {
        String nextPartitionName;
        if (!this.RCM_MODE || !this.isStandbyPool) {
            this.clearThreadLocalIfDifferentPartition(activeThread, this.getPartitionName(workAdapter));
            return activeThread;
        }
        String previousPartitionName = activeThread.getPreviousPartitionName();
        if (this.partitionNameMatches(previousPartitionName, nextPartitionName = this.getPartitionName(workAdapter))) {
            if (PartitionAffinityThreadPool.debugEnabled()) {
                if (isIdleThread) {
                    this.switchIdleThreadNotNeeded.getAndIncrement();
                } else {
                    this.switchStandbyThreadNotNeeded.getAndIncrement();
                }
            }
            return activeThread;
        }
        ExecuteThread matchingStandbyThread = this.getMatching(nextPartitionName);
        if (matchingStandbyThread != null) {
            activeThread.setStandby(true);
            if (RequestManager.getInstance().doForceCleanupThreadlocal(activeThread)) {
                this.offer(activeThread);
            }
            if (PartitionAffinityThreadPool.debugEnabled()) {
                if (isIdleThread) {
                    this.switchIdleThreadGotFromStandby.getAndIncrement();
                } else {
                    this.switchStandbyThreadSucceeded.getAndIncrement();
                }
            }
            matchingStandbyThread.setStandby(false);
            activeThread = matchingStandbyThread;
        } else {
            this.clearThreadLocalIfDifferentPartition(activeThread, nextPartitionName);
            if (PartitionAffinityThreadPool.debugEnabled()) {
                if (isIdleThread) {
                    this.switchIdleThreadFailed.getAndIncrement();
                } else {
                    this.switchStandbyThreadFailed.getAndIncrement();
                }
            }
        }
        return activeThread;
    }

    private boolean partitionNameMatches(String name1, String name2) {
        if (name1 == null) {
            return name2 == null;
        }
        return name1.equals(name2);
    }

    void setLimit(int value) {
        this.commonPool.setLimit(value);
    }

    int size() {
        int total = this.commonPool.size();
        if (this.RCM_MODE) {
            for (Map.Entry<String, PartitionedPoolEntry> next : this.partitionedCache.entrySet()) {
                total += next.getValue().size();
            }
        }
        return total;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        Iterator<Map.Entry<String, PartitionedPoolEntry>> iterator = this.partitionedCache.entrySet().iterator();
        int total = this.commonPool.size();
        builder.append("common : ").append(total);
        while (iterator.hasNext()) {
            Map.Entry<String, PartitionedPoolEntry> next = iterator.next();
            total += next.getValue().size();
            builder.append(", " + next.getKey()).append(" : ").append(next.getValue().size());
        }
        builder.append(", total : ").append(total);
        return builder.toString();
    }

    private String getPartitionName(WorkAdapter workAdapter) {
        SelfTuningWorkManagerImpl workManager;
        ComponentInvocationContext workAdapterContext;
        if (workAdapter == null) {
            return null;
        }
        ComponentInvocationContext cic = null;
        if (workAdapter instanceof ComponentRequest && (workAdapterContext = ((ComponentRequest)((Object)workAdapter)).getComponentInvocationContext()) != null) {
            cic = workAdapterContext;
        }
        if (cic == null && (workManager = workAdapter.getWorkManager()) != null) {
            cic = workManager.getComponentInvocationContext();
        }
        return cic == null ? null : cic.getPartitionName();
    }

    private static boolean debugEnabled() {
        return SelfTuningWorkManagerImpl.debugEnabled();
    }

    private static void log(String str) {
        SelfTuningWorkManagerImpl.debug("<PartitionAffinityThreadPool> " + str);
    }

    static class PartitionedPoolEntry {
        ConcurrentPool<ExecuteThread> pool = new ConcurrentPool(10);
        volatile long lastPollTime = 0L;

        ConcurrentPool<ExecuteThread> getPool() {
            return this.pool;
        }

        void setPool(ConcurrentPool<ExecuteThread> pool) {
            this.pool = pool;
        }

        ExecuteThread poll() {
            return this.pool.poll();
        }

        boolean offer(ExecuteThread executeThread) {
            return this.pool.offer(executeThread);
        }

        int size() {
            return this.pool.size();
        }
    }
}

