/*
 * Decompiled with CFR 0.152.
 */
package weblogic.work;

import weblogic.kernel.ExecuteRequest;
import weblogic.kernel.ExecuteThread;
import weblogic.kernel.Kernel;
import weblogic.management.configuration.ExecuteQueueMBean;
import weblogic.utils.UnsyncCircularQueue;
import weblogic.work.ExecuteRequestAdapter;
import weblogic.work.Work;
import weblogic.work.WorkManagerImpl;
import weblogic.work.WorkManagerLogger;

public final class KernelDelegator
extends WorkManagerImpl {
    private int dispatchId;

    KernelDelegator() {
        this.wmName = "direct";
    }

    KernelDelegator(String name, ExecuteQueueMBean eqmb) {
        Kernel.addExecuteQueue(name, eqmb, true);
        this.dispatchId = Kernel.getDispatchPolicyIndex(name);
        this.wmName = name;
    }

    KernelDelegator(String name, int count) {
        if (count > 0) {
            Kernel.addExecuteQueue(name, count);
            this.dispatchId = Kernel.getDispatchPolicyIndex(name);
        } else {
            this.dispatchId = Kernel.getDispatchPolicyIndex("weblogic.kernel.Default");
        }
        this.wmName = name;
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public int getConfiguredThreadCount() {
        return Kernel.getExecuteThreadManager(this.wmName).getExecuteThreadCount();
    }

    @Override
    public void setThreadCount(int threadCount) {
        Kernel.getExecuteThreadManager(this.wmName).setThreadCount(threadCount);
    }

    @Override
    public void schedule(Runnable work) {
        if ("direct" == this.wmName) {
            work.run();
            return;
        }
        try {
            Kernel.execute((ExecuteRequest)new ExecuteRequestAdapter(work), this.dispatchId);
        }
        catch (UnsyncCircularQueue.FullQueueException fqe) {
            Runnable rejection = null;
            if (work instanceof Work) {
                rejection = ((Work)work).overloadAction(fqe.getMessage());
            }
            if (rejection == null) {
                WorkManagerLogger.logScheduleFailed(this.wmName, fqe);
                throw fqe;
            }
            rejection.run();
        }
    }

    @Override
    public boolean executeIfIdle(Runnable work) {
        Kernel.executeIfIdle((ExecuteRequest)new ExecuteRequestAdapter(work), this.dispatchId);
        return true;
    }

    @Override
    public boolean scheduleIfBusy(Runnable runnable) {
        if (Kernel.getExecuteQueueDepth(this.dispatchId) > 0) {
            this.schedule(runnable);
            return true;
        }
        Thread t = Thread.currentThread();
        if (t instanceof ExecuteThread) {
            ((ExecuteThread)t).setTimeStamp(System.currentTimeMillis());
        }
        return false;
    }

    @Override
    public int getQueueDepth() {
        return Kernel.getExecuteQueueDepth(this.dispatchId);
    }

    @Override
    public boolean isThreadOwner(Thread th) {
        if (!(th instanceof ExecuteThread)) {
            return false;
        }
        ExecuteThread et = (ExecuteThread)th;
        if (et.getExecuteThreadManager() == null) {
            return false;
        }
        return this.wmName.equalsIgnoreCase(et.getExecuteThreadManager().getName());
    }
}

