/*
 * Decompiled with CFR 0.152.
 */
package weblogic.work;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;
import weblogic.utils.collections.MaybeMapper;
import weblogic.utils.collections.Turnstile;
import weblogic.work.PriorityRequestQueue;
import weblogic.work.RequestClass;
import weblogic.work.RequestManager;
import weblogic.work.SelfTuningWorkManagerImpl;

public class ConcurrentCalendarQueue<T>
implements PriorityRequestQueue<T> {
    private static final DebugCategory debug = Debug.getCategory("weblogic.CalendarQueue");
    private static final int SECONDS = Integer.getInteger("CALENDAR_QUEUE_SECONDS", 2);
    private static final int CAL_SIZE = 1024 * ConcurrentCalendarQueue.pow2(SECONDS);
    private int[] calendar = new int[CAL_SIZE];
    private int[] last = new int[this.calendar.length];
    private long[] card_table = new long[CAL_SIZE / 64];
    private AtomicInteger size = new AtomicInteger();
    private long now;
    private int freeList = 0;
    private int allocated = 0;
    private int[] next;
    private long[] time;
    private T[] data;
    private long[] mt;
    private long busyPeriodStart;
    private final int initialCapacity;
    private final boolean allowShrinking;
    private volatile boolean empty = true;
    private long queueEmptiedCounter;
    private MaybeMapper<T> expiredElementMapper;
    private long outlier_t = 0L;
    private Turnstile outlier_seq = new Turnstile();
    private int outliers_head = 0;
    private RequestManager.Callable<T, T> OR_ELSE = new RequestManager.Callable<T, T>(){

        @Override
        public T call(T closure) {
            return closure;
        }
    };
    private static final int SPIN_AMOUNT = Integer.getInteger("CALQ_SPIN", 3000);
    private static final int FAST_LANE_SIZE = Integer.getInteger("FAST_LANE_SIZE", 256);
    int fw = 0;
    AtomicInteger fr = new AtomicInteger();
    AtomicLong popper_tkt = new AtomicLong();
    Turnstile popper_seq = new Turnstile();
    T[] fastLane = new Object[FAST_LANE_SIZE];
    int stolen;

    private static int pow2(int n) {
        if (n < 2) {
            return 1;
        }
        --n;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        n |= n >>> 16;
        return n + 1;
    }

    ConcurrentCalendarQueue(boolean allowShrinking, MaybeMapper<T> expiredElementMapper) {
        this(400, allowShrinking, expiredElementMapper);
    }

    ConcurrentCalendarQueue(int capacity, boolean allowShrinking, MaybeMapper<T> expiredElementMapper) {
        this.initialCapacity = capacity;
        this.allowShrinking = allowShrinking;
        this.expiredElementMapper = expiredElementMapper;
        this.init(capacity);
    }

    private void init(int capacity) {
        this.next = new int[capacity];
        this.time = new long[capacity];
        this.data = new Object[capacity];
        this.mt = new long[capacity];
    }

    private int shrink() {
        if (this.allowShrinking && this.arraySize() > this.initialCapacity) {
            assert (this.verifyEmptyCalendarQueue()) : "shrink() does not expect non-empty calendar[]";
            this.init(this.initialCapacity);
            this.freeList = 0;
            this.allocated = 0;
        }
        return this.freeList;
    }

    private boolean verifyEmptyCalendarQueue() {
        int arrayLen = this.calendar.length;
        for (int i = 0; i < arrayLen; ++i) {
            if (this.calendar[i] == 0) continue;
            return false;
        }
        return true;
    }

    int arraySize() {
        return this.next.length;
    }

    private void resetVirtualTime() {
        this.now = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <X, V> V add(T o, long maybeToken, RequestClass rc, RequestManager.Callable<X, V> andThen, X closure) {
        int np;
        long ticket;
        int p;
        V v;
        long t;
        int n;
        while (true) {
            long pt;
            ConcurrentCalendarQueue concurrentCalendarQueue = this;
            synchronized (concurrentCalendarQueue) {
                n = this.allocNode();
                if (n > 0) {
                    if (this.size.getAndIncrement() == 0) {
                        this.busyPeriodStart = System.currentTimeMillis();
                        this.empty = false;
                    }
                    long dt = rc.getVirtualTimeIncrement(this.now, this.queueEmptiedCounter);
                    t = this.now + dt;
                    this.data[n] = o;
                    this.mt[n] = maybeToken;
                    this.time[n] = t;
                    v = andThen.call(closure);
                    if (dt < (long)CAL_SIZE) {
                        this.add(this.cal_offset(t), n);
                        return v;
                    }
                    p = this.outliers_head;
                    if (p == 0 || this.time[p] > t) {
                        this.next[n] = p;
                        this.outliers_head = n;
                        return v;
                    }
                    ticket = this.outlier_t++;
                    break;
                }
            }
            do {
                pt = this.popper_tkt.get();
                this.popper_seq.awaitNonInterruptibly(pt);
            } while (!this.popper_tkt.compareAndSet(pt, pt + 1L));
            ConcurrentCalendarQueue concurrentCalendarQueue2 = this;
            synchronized (concurrentCalendarQueue2) {
                if (this.tooSmall()) {
                    this.outlier_seq.awaitNonInterruptibly(this.outlier_t++);
                    this.grow();
                    this.outlier_seq.advanceAlone();
                }
            }
            this.popper_seq.advanceAlone();
        }
        this.outlier_seq.awaitNonInterruptibly(ticket);
        while ((np = this.next[p]) != 0 && this.time[np] <= t) {
            p = np;
        }
        this.next[n] = np;
        this.next[p] = n;
        this.outlier_seq.advanceAlone();
        return v;
    }

    private void add(int index, int node) {
        int c = this.calendar[index];
        if (c == 0) {
            this.calendar[index] = node;
            this.set_card_table(index);
        } else {
            this.next[this.last[index]] = node;
        }
        this.last[index] = node;
    }

    private boolean tooSmall() {
        return this.allocated == this.next.length - 1;
    }

    private int allocNode() {
        int f;
        int s = this.freeList;
        if (s != 0 && (f = this.next[s]) != 0) {
            this.next[s] = this.next[f];
            this.next[f] = 0;
            return f;
        }
        s = this.tooSmall() ? 0 : ++this.allocated;
        return s;
    }

    @Deprecated
    public T pop(T suggestion, RequestClass rci) {
        if (suggestion != null) {
            return suggestion;
        }
        return this.pop(null, this.OR_ELSE, null);
    }

    @Override
    @Deprecated
    public T pop() {
        return this.pop(null, this.OR_ELSE, null);
    }

    private int find_next(int i, int lim) {
        int j = i >>> 6;
        long c = this.card_table[j];
        if ((c & 1L << i) != 0L) {
            return i;
        }
        assert (lim <= CAL_SIZE);
        assert (i <= CAL_SIZE);
        assert (this.card_table.length << 6 == CAL_SIZE);
        long mask = -1L << i;
        if ((c &= mask) == 0L) {
            do {
                if (++j <= lim - 1 >> 6) continue;
                return lim;
            } while ((c = this.card_table[j]) == 0L);
        }
        if ((i = (j << 6) + Long.numberOfTrailingZeros(c)) > lim) {
            i = lim;
        }
        return i;
    }

    private long epoch_begin(long t) {
        return t & (long)(-CAL_SIZE);
    }

    private long epoch_end(long t) {
        return this.epoch_begin(t + (long)CAL_SIZE);
    }

    private int cal_offset(long t) {
        return (int)t & CAL_SIZE - 1;
    }

    private void set_card_table(int b) {
        int n = b >>> 6;
        this.card_table[n] = this.card_table[n] | 1L << b;
    }

    private void clear_card_table(int b) {
        int n = b >>> 6;
        this.card_table[n] = this.card_table[n] & (1L << b ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private int promote_outliers(long t) {
        long c = this.time[this.outliers_head];
        if (c >= (t = this.epoch_end(t))) {
            return -1;
        }
        int r = this.cal_offset(c);
        this.outlier_seq.awaitNonInterruptibly(this.outlier_t++);
        do {
            int j = this.outliers_head;
            while (this.next[j] != 0 && this.time[this.next[j]] == c) {
                j = this.next[j];
            }
            int cn = this.calendar[this.cal_offset(c)];
            if (cn == 0) {
                this.last[this.cal_offset((long)c)] = j;
                this.set_card_table(this.cal_offset(c));
            }
            this.calendar[this.cal_offset((long)c)] = this.outliers_head;
            this.outliers_head = this.next[j];
            this.next[j] = cn;
        } while (this.outliers_head != 0 && (c = this.time[this.outliers_head]) < t);
        this.outlier_seq.advanceAlone();
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> T pop(MaybeMapper<T> mu, RequestManager.Callable<V, T> orElse, V closure) {
        T result;
        int r;
        long me = this.popper_tkt.getAndIncrement();
        this.popper_seq.spinAwaitNonInterruptibly(me, SPIN_AMOUNT);
        while ((r = this.fr.get()) != this.fw) {
            result = this.fastLane[r & FAST_LANE_SIZE - 1];
            if (!this.fr.compareAndSet(r, r + 1)) continue;
            return result;
        }
        int popped = 0;
        int fl = this.freeList;
        RuntimeException unboxException = null;
        while (true) {
            if (this.stolen == 0) {
                ConcurrentCalendarQueue concurrentCalendarQueue = this;
                synchronized (concurrentCalendarQueue) {
                    if (this.size.get() == popped) {
                        this.empty = true;
                        if (this.busyPeriodStart > 0L) {
                            long elapsedTime = System.currentTimeMillis() - this.busyPeriodStart;
                            this.busyPeriodStart = 0L;
                            this.resetVirtualTime();
                            fl = this.shrink();
                            ++this.queueEmptiedCounter;
                        }
                        result = orElse.call(closure);
                        break;
                    }
                    int lim = this.cal_offset(this.now);
                    this.stolen = this.calendar[lim];
                    if (this.stolen == 0) {
                        int i = this.find_next(lim, CAL_SIZE);
                        if (i == CAL_SIZE) {
                            if (this.outliers_head != 0 && this.promote_outliers(this.epoch_end(this.now)) >= 0) {
                                lim = CAL_SIZE;
                            }
                            if ((i = this.find_next(0, lim)) == lim) {
                                assert (this.outliers_head != 0) : "since size was non-zero, and calendar is empty, there must be entries in the outliers queue" + this.calqState(popped);
                                i = this.promote_outliers(this.time[this.outliers_head]);
                            }
                        }
                        lim = i;
                        this.stolen = this.calendar[lim];
                        assert (this.stolen != 0) : "expect to find a non-empty calendar entry" + this.calqState(popped);
                        this.now = this.time[this.stolen];
                    }
                    this.calendar[lim] = 0;
                    this.clear_card_table(lim);
                }
            }
            int c = this.stolen;
            ++popped;
            this.stolen = this.next[c];
            this.next[c] = fl;
            fl = c;
            result = this.data[c];
            this.data[c] = null;
            long maybeToken = this.mt[c];
            assert (result != null) : "expected a non-null item in the queue; observed c=" + c + ", stolen=" + this.stolen + ", maybeToken=" + maybeToken + this.calqState(popped);
            if (mu != null) {
                try {
                    result = mu.unbox(result, maybeToken);
                }
                catch (RuntimeException t) {
                    unboxException = t;
                    break;
                }
            }
            if (result == null) continue;
            if (this.fr.get() + FAST_LANE_SIZE == this.fw || this.popper_tkt.get() == ++me) break;
            this.fastLane[this.fw & ConcurrentCalendarQueue.FAST_LANE_SIZE - 1] = result;
            ++this.fw;
            this.popper_seq.advanceAlone();
        }
        this.size.getAndAdd(-popped);
        this.freeList = fl;
        this.popper_seq.advanceAlone();
        if (unboxException != null) {
            orElse.call(closure);
            throw unboxException;
        }
        return result;
    }

    private void grow() {
        int removed;
        if (this.allowShrinking && (removed = this.removeExpiredOutliers()) > this.next.length / 2) {
            if (ConcurrentCalendarQueue.debugEnabled()) {
                ConcurrentCalendarQueue.debug("no need to grow");
            }
            return;
        }
        int n = 2 * this.next.length;
        this.time = this.copy(this.time, new long[n]);
        this.data = this.copy(this.data, new Object[n]);
        this.mt = this.copy(this.mt, new long[n]);
        this.next = this.copy(this.next, new int[n]);
        if (ConcurrentCalendarQueue.debugEnabled()) {
            ConcurrentCalendarQueue.debug("grow() called. Arrays are of length " + this.next.length);
        }
    }

    private int[] copy(int[] src, int[] dst) {
        System.arraycopy(src, 0, dst, 0, src.length);
        return dst;
    }

    private long[] copy(long[] src, long[] dst) {
        System.arraycopy(src, 0, dst, 0, src.length);
        return dst;
    }

    private T[] copy(T[] src, T[] dst) {
        System.arraycopy(src, 0, dst, 0, src.length);
        return dst;
    }

    public int removeExpiredOutliers() {
        if (this.expiredElementMapper == null) {
            return 0;
        }
        int node = this.outliers_head;
        int removed = 0;
        int prev = 0;
        while (node > 0) {
            T value = this.data[node];
            int nextNode = this.next[node];
            if (this.expiredElementMapper.unbox(value, this.mt[node]) == null) {
                prev = node;
            } else {
                this.data[node] = null;
                if (prev == 0) {
                    this.outliers_head = this.next[node];
                } else {
                    this.next[prev] = this.next[node];
                }
                this.next[node] = this.freeList;
                this.freeList = node;
                ++removed;
            }
            node = nextNode;
        }
        this.size.getAndAdd(-removed);
        if (debug.isEnabled()) {
            ConcurrentCalendarQueue.debug("removeExpiredOutliers() removed " + removed + " entries");
        }
        return removed;
    }

    @Override
    public int size() {
        return this.size.get();
    }

    @Override
    public boolean isEmpty() {
        return this.empty;
    }

    @Override
    public long getMaxValue() {
        return Long.MAX_VALUE - (long)CAL_SIZE;
    }

    private String calqState(int popped) {
        StringBuilder s = new StringBuilder("\n--- Dump begins: ---\n");
        s.append("calendar[" + this.calendar.length + "]\n");
        s.append(this.dumpArray(this.calendar));
        s.append("last[" + this.last.length + "]\n");
        s.append(this.dumpArray(this.last));
        s.append("next[" + this.next.length + "]\n");
        s.append(this.dumpArray(this.next));
        s.append("data[" + this.data.length + "]\n");
        s.append(this.dumpDataArray(this.data));
        s.append("card_table[" + this.card_table.length + "]\n");
        s.append(this.dumpLongArray(this.card_table));
        s.append("now=" + this.now + ", stolen=" + this.stolen + ", popped=" + popped + ", size=" + this.size + "\n");
        return s.toString();
    }

    private String dumpArray(int[] array) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            s.append(array[i]);
            s.append(" ");
        }
        return s.append("\n").toString();
    }

    private String dumpDataArray(Object[] array) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            s.append(array[i] == null ? "0" : "1");
            s.append(" ");
        }
        return s.append("\n").toString();
    }

    private String dumpLongArray(long[] array) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            s.append(Long.toHexString(array[i]));
            s.append(" ");
        }
        return s.append("\n").toString();
    }

    private static boolean debugEnabled() {
        return debug.isEnabled() || SelfTuningWorkManagerImpl.debugEnabled();
    }

    private static void debug(String str) {
        SelfTuningWorkManagerImpl.debug("<ConcurrentCalendarQueue>" + str);
    }
}

