/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.zip;

import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class SafeZipFileInputStream
extends FilterInputStream {
    private ZipFile zf;
    private boolean closed = false;

    public SafeZipFileInputStream(ZipFile zf, ZipEntry ze) throws IOException {
        super(ze.getName().length() == 0 ? new FileInputStream(zf.getName()) : zf.getInputStream(ze));
        this.zf = zf;
    }

    @Override
    public void close() throws IOException {
        IOException ioe = null;
        try {
            super.close();
        }
        catch (IOException e) {
            ioe = e;
        }
        try {
            this.zf.close();
        }
        finally {
            this.closed = true;
        }
        if (ioe != null) {
            throw ioe;
        }
    }
}

