/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.wrapper;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import weblogic.utils.classfile.ClassFile;
import weblogic.utils.classfile.CodeAttribute;
import weblogic.utils.classfile.MethodInfo;
import weblogic.utils.classfile.Scope;
import weblogic.utils.classfile.Type;
import weblogic.utils.classfile.cp.CPFieldref;
import weblogic.utils.classfile.cp.CPMemberType;
import weblogic.utils.classfile.cp.CPMethodref;
import weblogic.utils.classfile.expr.AssignStatement;
import weblogic.utils.classfile.expr.CastExpression;
import weblogic.utils.classfile.expr.CatchExceptionExpression;
import weblogic.utils.classfile.expr.CompoundStatement;
import weblogic.utils.classfile.expr.Const;
import weblogic.utils.classfile.expr.Expression;
import weblogic.utils.classfile.expr.ExpressionStatement;
import weblogic.utils.classfile.expr.InvokeExpression;
import weblogic.utils.classfile.expr.InvokeSpecialExpression;
import weblogic.utils.classfile.expr.LocalVariableExpression;
import weblogic.utils.classfile.expr.MemberVarExpression;
import weblogic.utils.classfile.expr.NewArrayExpression;
import weblogic.utils.classfile.expr.NewExpression;
import weblogic.utils.classfile.expr.ReturnStatement;
import weblogic.utils.classfile.expr.ThrowStatement;
import weblogic.utils.classfile.expr.TryCatchStatement;
import weblogic.utils.wrapper.ClassList;
import weblogic.utils.wrapper.WrapperFactory;

public class WrapperClassFile
extends ClassFile {
    private static final boolean DEBUG = false;
    private HashSet wrapperInterfaces = new HashSet();
    private CPFieldref vendorObjFieldRef;
    private CPMethodref preInvokeMref;
    private CPMethodref postInvokeMref;
    private CPMethodref exceptionInvokeMref;
    private CPMethodref finalizerInvokeMref;
    private CPMethodref BooleanConstructor;
    private CPMethodref CharacterConstructor;
    private CPMethodref ByteConstructor;
    private CPMethodref ShortConstructor;
    private CPMethodref IntegerConstructor;
    private CPMethodref LongConstructor;
    private CPMethodref FloatConstructor;
    private CPMethodref DoubleConstructor;
    private WrapperFactory factory;

    public WrapperClassFile(WrapperFactory factory) {
        this.factory = factory;
    }

    public void setup(Class superClass) {
        try {
            this.vendorObjFieldRef = this.cp.getFieldref(superClass, "vendorObj", "Ljava/lang/Object;");
            Method handlerMethod = superClass.getMethod("preInvocationHandler", String.class, Object[].class);
            this.preInvokeMref = this.cp.getMethodref(handlerMethod);
            handlerMethod = superClass.getMethod("postInvocationHandler", String.class, Object[].class, Object.class);
            this.postInvokeMref = this.cp.getMethodref(handlerMethod);
            handlerMethod = superClass.getMethod("invocationExceptionHandler", String.class, Object[].class, Throwable.class);
            this.exceptionInvokeMref = this.cp.getMethodref(handlerMethod);
            if (this.factory.needFinalize()) {
                try {
                    handlerMethod = superClass.getMethod("finalizeInternal", new Class[0]);
                    this.finalizerInvokeMref = this.cp.getMethodref(handlerMethod);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.finalizerInvokeMref != null) {
                    this.addFinalizer();
                }
            }
            this.addDefaultConstructor(superClass);
            this.BooleanConstructor = this.cp.getMethodref(Boolean.class, "<init>", "(Z)V");
            this.CharacterConstructor = this.cp.getMethodref(Character.class, "<init>", "(C)V");
            this.ByteConstructor = this.cp.getMethodref(Byte.class, "<init>", "(B)V");
            this.ShortConstructor = this.cp.getMethodref(Short.class, "<init>", "(S)V");
            this.IntegerConstructor = this.cp.getMethodref(Integer.class, "<init>", "(I)V");
            this.LongConstructor = this.cp.getMethodref(Long.class, "<init>", "(J)V");
            this.FloatConstructor = this.cp.getMethodref(Float.class, "<init>", "(F)V");
            this.DoubleConstructor = this.cp.getMethodref(Double.class, "<init>", "(D)V");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addMethods(Method[] m) {
        this.addMethods(m, null);
    }

    public void addMethods(Method[] m, Object vendorObj) {
        Class<?> vendorClass = null;
        boolean pub = false;
        ClassList list = new ClassList(20);
        Class[] classArray = null;
        if (vendorObj != null) {
            vendorClass = vendorObj.getClass();
            pub = Modifier.isPublic(vendorClass.getModifiers());
            WrapperClassFile.recursivelyGetInterfaces(vendorClass, list);
            classArray = list.toArray();
        }
        for (int i = 0; i < m.length; ++i) {
            Expression[] varsCopy;
            Expression paramsExpression;
            Expression nameExpression;
            Method method;
            if (!Modifier.isPublic(m[i].getModifiers())) continue;
            if (vendorObj != null) {
                if (pub) {
                    method = m[i];
                } else {
                    method = this.getInterfaceMethod(m[i], classArray);
                    if (method == null) {
                        continue;
                    }
                }
            } else {
                method = WrapperClassFile.getInterfaceMethod(m[i]);
            }
            int modifiers = method.getModifiers();
            modifiers &= 7;
            MethodInfo mi = this.addMethod(method, modifiers |= 0x10);
            Scope scope = mi.getScope();
            Class<?>[] params = method.getParameterTypes();
            Class<?>[] exceptions = method.getExceptionTypes();
            Class<?> declaringClass = method.getDeclaringClass();
            CPMemberType mref = declaringClass.isInterface() ? this.cp.getInterfaceMethodref(method) : this.cp.getMethodref(declaringClass, method);
            Expression[] vars = mi.getScope().getArgs();
            CompoundStatement cs = new CompoundStatement();
            if (this.factory.needPreInvocationHandler(method) != 0) {
                Expression nameExpression2 = Const.NULL;
                if ((this.factory.needPreInvocationHandler(method) & 2) != 0) {
                    nameExpression2 = Const.get(method.getName());
                }
                Expression paramsExpression2 = Const.NULL;
                if ((this.factory.needPreInvocationHandler(method) & 4) != 0) {
                    Expression[] varsCopy2 = this.primitiveToObject(vars);
                    paramsExpression2 = new NewArrayExpression(Object.class, varsCopy2);
                }
                ExpressionStatement preInvokeStatement = new ExpressionStatement(new InvokeExpression(this.preInvokeMref, Const.THIS, new Expression[]{nameExpression2, paramsExpression2}));
                cs.add(preInvokeStatement);
            }
            InvokeExpression invokeResult = new InvokeExpression(mref, new CastExpression(method.getDeclaringClass(), new MemberVarExpression(Const.THIS, this.vendorObjFieldRef)), vars);
            if (this.factory.needPostInvocationHandler(method) != 0) {
                Class<?> retType;
                nameExpression = Const.NULL;
                if ((this.factory.needPostInvocationHandler(method) & 2) != 0) {
                    nameExpression = Const.get(method.getName());
                }
                paramsExpression = Const.NULL;
                if ((this.factory.needPostInvocationHandler(method) & 4) != 0) {
                    varsCopy = this.primitiveToObject(vars);
                    paramsExpression = new NewArrayExpression(Object.class, varsCopy);
                }
                if ((retType = method.getReturnType()).isPrimitive()) {
                    LocalVariableExpression tmp = null;
                    if (retType != Void.TYPE) {
                        tmp = scope.createLocalVar(Type.getType(retType));
                        cs.add(new AssignStatement(tmp, invokeResult));
                    } else {
                        cs.add(new ExpressionStatement(invokeResult));
                    }
                    Expression resultExpression = Const.NULL;
                    if (retType != Void.TYPE) {
                        resultExpression = this.primitiveToObject(new Expression[]{tmp})[0];
                    }
                    ExpressionStatement postInvokeStatement = new ExpressionStatement(new InvokeExpression(this.postInvokeMref, Const.THIS, new Expression[]{nameExpression, paramsExpression, resultExpression}));
                    cs.add(postInvokeStatement);
                    if (retType != Void.TYPE) {
                        cs.add(new ReturnStatement(tmp));
                        scope.freeLocalVar(tmp);
                    } else {
                        cs.add(new ReturnStatement());
                    }
                } else {
                    CastExpression wrapResult = new CastExpression(retType, new InvokeExpression(this.postInvokeMref, Const.THIS, new Expression[]{nameExpression, paramsExpression, invokeResult}));
                    cs.add(new ReturnStatement(wrapResult));
                }
            } else {
                cs.add(new ReturnStatement(invokeResult));
            }
            if (this.factory.needInvocationExceptionHandler(method) != 0) {
                nameExpression = Const.NULL;
                if ((this.factory.needInvocationExceptionHandler(method) & 2) != 0) {
                    nameExpression = Const.get(method.getName());
                }
                paramsExpression = Const.NULL;
                if ((this.factory.needInvocationExceptionHandler(method) & 4) != 0) {
                    varsCopy = this.primitiveToObject(vars);
                    paramsExpression = new NewArrayExpression(Object.class, varsCopy);
                }
                TryCatchStatement tryCatch = new TryCatchStatement();
                tryCatch.setBody(cs);
                CompoundStatement exceptionHandler = new CompoundStatement();
                for (int j = 0; j < exceptions.length; ++j) {
                    LocalVariableExpression tmp = scope.createLocalVar(Type.OBJECT);
                    exceptionHandler.add(new AssignStatement(tmp, new CatchExceptionExpression()));
                    exceptionHandler.add(new ExpressionStatement(new InvokeExpression(this.exceptionInvokeMref, Const.THIS, new Expression[]{nameExpression, paramsExpression, tmp})));
                    exceptionHandler.add(new ThrowStatement(tmp));
                    tmp.free();
                    tryCatch.addHandler(exceptions[j].getName().replace('.', '/'), exceptionHandler);
                }
                CodeAttribute ca = mi.getCodeAttribute();
                ca.setCode(tryCatch);
                continue;
            }
            CodeAttribute ca = mi.getCodeAttribute();
            ca.setCode(cs);
        }
    }

    @Override
    public void addInterface(String interfaceName) {
        super.addInterface(interfaceName);
    }

    public void addAllInterfaces(Class c) {
        for (Class cls = c; cls != null; cls = cls.getSuperclass()) {
            this.addInterfaces(cls.getInterfaces());
        }
    }

    private void addInterfaces(Class[] interfaces) {
        for (int i = 0; i < interfaces.length; ++i) {
            if (!Modifier.isPublic(interfaces[i].getModifiers())) {
                this.addInterfaces(interfaces[i].getInterfaces());
                continue;
            }
            String interfaceName = interfaces[i].getName();
            if (this.wrapperInterfaces.contains(interfaceName)) continue;
            super.addInterface(interfaceName);
            this.wrapperInterfaces.add(interfaceName);
        }
    }

    private void addDefaultConstructor(Class superClass) {
        CPMethodref superConstructor = this.cp.getMethodref(superClass, "<init>", "()V");
        InvokeSpecialExpression invokeResult = new InvokeSpecialExpression(superConstructor, Const.THIS, new Expression[0]);
        MethodInfo mi = this.addMethod("<init>", "()V", 1);
        CodeAttribute ca = mi.getCodeAttribute();
        ca.setCode(new ReturnStatement(invokeResult));
    }

    private void addFinalizer() {
        InvokeSpecialExpression invokeResult = new InvokeSpecialExpression(this.finalizerInvokeMref, Const.THIS, new Expression[0]);
        MethodInfo mi = this.addMethod("finalize", "()V", 1);
        CodeAttribute ca = mi.getCodeAttribute();
        ca.setCode(new ReturnStatement(invokeResult));
    }

    private Expression[] primitiveToObject(Expression[] vars) {
        Expression[] varsCopy = new Expression[vars.length];
        for (int j = 0; j < vars.length; ++j) {
            varsCopy[j] = vars[j].getType() == Type.OBJECT || vars[j].getType() == Type.ARRAY ? vars[j] : (vars[j].getType() == Type.INT ? new NewExpression(this.IntegerConstructor, new Expression[]{vars[j]}) : (vars[j].getType() == Type.BOOLEAN ? new NewExpression(this.BooleanConstructor, new Expression[]{vars[j]}) : (vars[j].getType() == Type.LONG ? new NewExpression(this.LongConstructor, new Expression[]{vars[j]}) : (vars[j].getType() == Type.FLOAT ? new NewExpression(this.FloatConstructor, new Expression[]{vars[j]}) : (vars[j].getType() == Type.DOUBLE ? new NewExpression(this.DoubleConstructor, new Expression[]{vars[j]}) : (vars[j].getType() == Type.SHORT ? new NewExpression(this.ShortConstructor, new Expression[]{vars[j]}) : (vars[j].getType() == Type.BYTE ? new NewExpression(this.ByteConstructor, new Expression[]{vars[j]}) : (vars[j].getType() == Type.CHARACTER ? new NewExpression(this.CharacterConstructor, new Expression[]{vars[j]}) : vars[j]))))))));
        }
        return varsCopy;
    }

    private Method getInterfaceMethod(Method m, Class[] list) {
        for (int i = 0; i < list.length; ++i) {
            try {
                Method foundMethod = list[i].getDeclaredMethod(m.getName(), m.getParameterTypes());
                return foundMethod;
            }
            catch (Exception exception) {
                continue;
            }
        }
        return null;
    }

    public static Method getInterfaceMethod(Method m) {
        Class<?> declaringClass = m.getDeclaringClass();
        if (Modifier.isPublic(declaringClass.getModifiers())) {
            return m;
        }
        Method foundMethod = WrapperClassFile.recursivelyGetMethod(declaringClass, m);
        return foundMethod == null ? m : foundMethod;
    }

    private static Method recursivelyGetMethod(Class decClass, Method m) {
        Method foundMethod;
        Method retVal = null;
        try {
            Method foundMethod2 = decClass.getDeclaredMethod(m.getName(), m.getParameterTypes());
            if (Modifier.isPublic(foundMethod2.getDeclaringClass().getModifiers())) {
                retVal = foundMethod2;
            }
        }
        catch (NoSuchMethodException foundMethod2) {
        }
        catch (SecurityException foundMethod2) {
            // empty catch block
        }
        Class<?>[] interfaces = decClass.getInterfaces();
        for (int i = 0; interfaces != null && i < interfaces.length; ++i) {
            Method foundMethod3 = WrapperClassFile.recursivelyGetMethod(interfaces[i], m);
            if (foundMethod3 == null || !Modifier.isPublic(foundMethod3.getDeclaringClass().getModifiers())) continue;
            retVal = foundMethod3;
        }
        if (decClass.getSuperclass() != null && (foundMethod = WrapperClassFile.recursivelyGetMethod(decClass.getSuperclass(), m)) != null && Modifier.isPublic(foundMethod.getDeclaringClass().getModifiers())) {
            retVal = foundMethod;
        }
        return retVal;
    }

    private static void recursivelyGetInterfaces(Class decClass, ClassList list) {
        if (decClass.getSuperclass() != null) {
            WrapperClassFile.recursivelyGetInterfaces(decClass.getSuperclass(), list);
        }
        Class<?>[] interfaces = decClass.getInterfaces();
        for (int i = 0; interfaces != null && i < interfaces.length; ++i) {
            WrapperClassFile.recursivelyGetInterfaces(interfaces[i], list);
        }
        if (Modifier.isPublic(decClass.getModifiers()) && !decClass.getName().equals("java.lang.Object")) {
            list.addUnique(decClass);
        }
    }
}

