/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.string;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import weblogic.utils.string.SimpleCachingDateFormat;
import weblogic.utils.string.ThreadLocalDateFormat;

public abstract class CachingDateFormat {
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    protected static final String RFC1123DatePattern = "EE, dd MMM yyyy HH:mm:ss zz";
    protected static final String RFC850DatePattern = "EEEE, dd-MMM-yy HH:mm:ss zz";
    protected static final String ASCTimeDatePattern = "EE MMM  d HH:mm:ss yyyy";
    private static final CachingDateFormat RFC1123Format = new SimpleCachingDateFormat("EE, dd MMM yyyy HH:mm:ss zz", GMT);
    private static final CachingDateFormat RFC850Format = new SimpleCachingDateFormat("EEEE, dd-MMM-yy HH:mm:ss zz", GMT);
    private static final CachingDateFormat ASCTimeFormat = new SimpleCachingDateFormat("EE MMM  d HH:mm:ss yyyy", GMT);
    protected int resolution;
    private long expiration;
    private String formatString;

    public static String getRFC1123Date() {
        return CachingDateFormat.getRFC1123Date(System.currentTimeMillis());
    }

    public static String getRFC1123Date(long date) {
        return RFC1123Format.getDate(date);
    }

    @Deprecated
    public static String getRFC850Date() {
        return CachingDateFormat.getRFC850Date(System.currentTimeMillis());
    }

    @Deprecated
    public static String getRFC850Date(long date) {
        return RFC850Format.getDate(date);
    }

    public static String getASCTimeDate() {
        return CachingDateFormat.getASCTimeDate(System.currentTimeMillis());
    }

    public static String getASCTimeDate(long date) {
        return ASCTimeFormat.getDate(date);
    }

    public static long parseDate(String value, DateFormat[] threadLocalFormats) {
        Long cachedDate = (Long)ParseCacheHolder.CACHE.get(value);
        if (cachedDate != null) {
            return cachedDate;
        }
        Long date = null;
        date = threadLocalFormats != null ? CachingDateFormat.internalParseDate(value, threadLocalFormats) : CachingDateFormat.internalParseDate(value, ThreadLocalDateFormat.getInstance().getDateFormats());
        CachingDateFormat.updateParseCache(value, date);
        if (date == null) {
            return -1L;
        }
        return date;
    }

    public final String getDate() {
        return this.getDate(System.currentTimeMillis());
    }

    public final String getDate(long utc) {
        if (utc > this.expiration || utc + (long)this.resolution <= this.expiration) {
            this.formatString = this.format(utc);
            this.expiration = utc + ((long)this.resolution - utc % (long)this.resolution);
        }
        return this.formatString;
    }

    protected abstract String format(long var1);

    private static Long internalParseDate(String value, DateFormat[] formats) {
        Date date = null;
        for (int i = 0; date == null && i < formats.length; ++i) {
            try {
                date = formats[i].parse(value);
                continue;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (date == null) {
            return null;
        }
        return new Long(date.getTime());
    }

    private static void updateParseCache(String key, Long value) {
        if (value == null) {
            return;
        }
        if (ParseCacheHolder.CACHE.size() > ParseCacheHolder.CACHE_SIZE) {
            ParseCacheHolder.CACHE.clear();
        }
        ParseCacheHolder.CACHE.put(key, value);
    }

    private static class ParseCacheHolder {
        private static final int CACHE_SIZE = Integer.getInteger("weblogic.utils.cachingdateformat.cachesize", 600);
        private static final ConcurrentHashMap CACHE = new ConcurrentHashMap(CACHE_SIZE);

        private ParseCacheHolder() {
        }
    }
}

