/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.reflect;

import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;

public final class UniqueMethod {
    private static final Map canonical = Collections.synchronizedMap(new WeakHashMap());

    public static Method intern(Method m) {
        Method cm;
        WeakReference r = (WeakReference)canonical.get(m);
        if (r != null && (cm = (Method)r.get()) != null) {
            return cm;
        }
        canonical.put(m, new WeakReference<Method>(m));
        return m;
    }

    public static Method[] internAll(Method[] m) {
        for (int i = 0; i < m.length; ++i) {
            m[i] = UniqueMethod.intern(m[i]);
        }
        return m;
    }
}

