/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import weblogic.utils.Debug;
import weblogic.utils.enumerations.PeekingEnumerator;

public class ReflectUtils {
    private static final String SET_PFX = "set";
    private static final boolean debug = true;
    private static final boolean verbose = false;
    private static final Map<String, Class<?>> primMap = new HashMap();
    private static final HashMap<Class<? extends Object>, Class<? extends Object>> classTranslation = new HashMap();
    private static final HashMap<String, String> primitiveToLang = new HashMap();

    public static boolean isPrimitiveClass(String className) {
        return primMap.containsKey(className);
    }

    public static Class<?> loadPrimitiveClass(String className) {
        return primMap.get(className);
    }

    public static Enumeration<Class<?>> allInterfaces(Class<?> c) {
        LinkedHashMap h = new LinkedHashMap();
        ReflectUtils.addInterfaces(h, c);
        return new EnumerationImpl(h.keySet());
    }

    public static List<Class<?>> everyInterface(Class<?> c) {
        LinkedHashSet retVal = new LinkedHashSet();
        while (c != null) {
            Enumeration<Class<?>> immediateInterfaces = ReflectUtils.allInterfaces(c);
            while (immediateInterfaces.hasMoreElements()) {
                retVal.add(immediateInterfaces.nextElement());
            }
            c = c.getSuperclass();
        }
        return new LinkedList(retVal);
    }

    public static Enumeration<Class<?>> allSuperclasses(Class<?> c) {
        return new SuperclassEnumerator(c);
    }

    public static Enumeration<Method> distinctInterfaceMethods(Class<?> c) {
        Debug.assertion(c.isInterface());
        LinkedHashMap<MKey, Method> h = new LinkedHashMap<MKey, Method>();
        ReflectUtils.addDistinctInterfaceMethods(h, c);
        Enumeration<Class<?>> ifcs = ReflectUtils.allInterfaces(c);
        while (ifcs.hasMoreElements()) {
            ReflectUtils.addDistinctInterfaceMethods(h, ifcs.nextElement());
        }
        return new EnumerationImpl<Method>(h.values());
    }

    public static Enumeration<Method> distinctMethods(Class<?> c) {
        LinkedHashMap<MKey, Method> h = new LinkedHashMap<MKey, Method>();
        ReflectUtils.addDistinctInterfaceMethods(h, c);
        Enumeration<Class<?>> ifcs = ReflectUtils.allInterfaces(c);
        while (ifcs.hasMoreElements()) {
            ReflectUtils.addDistinctInterfaceMethods(h, ifcs.nextElement());
        }
        Enumeration<Class<?>> superClasses = ReflectUtils.allSuperclasses(c);
        while (superClasses.hasMoreElements()) {
            ReflectUtils.addDistinctInterfaceMethods(h, superClasses.nextElement());
        }
        return new EnumerationImpl<Method>(h.values());
    }

    public static boolean haveCommonInterface(Class<?> c1, Class<?> c2) {
        return ReflectUtils.haveCommonElement(ReflectUtils.allInterfaces(c1), ReflectUtils.allInterfaces(c2));
    }

    private static boolean haveCommonElement(Enumeration<Class<?>> e1, Enumeration<Class<?>> e2) {
        LinkedHashMap map = new LinkedHashMap();
        while (e1.hasMoreElements()) {
            Class<?> o = e1.nextElement();
            map.put(o, o);
        }
        while (e2.hasMoreElements()) {
            if (!map.containsKey(e2.nextElement())) continue;
            return true;
        }
        return false;
    }

    private static void addInterfaces(LinkedHashMap<Class<?>, Class<?>> h, Class<? extends Object> c) {
        Class<?>[] ifcs = c.getInterfaces();
        for (int i = 0; i < ifcs.length; ++i) {
            Class<?> ifc = ifcs[i];
            h.put(ifc, ifc);
            ReflectUtils.addInterfaces(h, ifc);
        }
    }

    private static void addDistinctInterfaceMethods(LinkedHashMap<MKey, Method> h, Class<?> c) {
        for (Method m : c.getMethods()) {
            if (ReflectUtils.isStaticInitializer(m)) continue;
            MKey mkey = new MKey(m);
            Method m2 = h.get(mkey);
            if (m2 == null) {
                h.put(mkey, m);
                continue;
            }
            Class<?> c1 = m.getDeclaringClass();
            Class<?> c2 = m2.getDeclaringClass();
            if (!c2.isAssignableFrom(c1)) continue;
            h.put(mkey, m);
        }
    }

    private static boolean isStaticInitializer(Method m) {
        return m.getName().equals("<clinit>");
    }

    public static String getJavaLangType(String type) {
        String retVal = primitiveToLang.get(type);
        if (retVal == null) {
            return type;
        }
        return retVal;
    }

    public static Class<?> getTypeOfSetter(AccessibleObject setter) {
        if (setter instanceof Method) {
            Method method = (Method)setter;
            Class<?>[] parameters = method.getParameterTypes();
            if (parameters == null || parameters.length != 1) {
                throw new IllegalArgumentException("Invalid setter method " + setter);
            }
            return parameters[0];
        }
        if (setter instanceof Field) {
            Field field = (Field)setter;
            return field.getType();
        }
        throw new IllegalArgumentException("Invalid setter: " + setter);
    }

    public static AccessibleObject getMethodOrFieldForSetter(Class<?> targetClass, String attribute, Class<?> preferredType) throws IllegalArgumentException {
        if (targetClass == null || attribute == null) {
            throw new IllegalArgumentException("targetClass is " + targetClass + " attribute is " + attribute);
        }
        AccessibleObject retVal = ReflectUtils.getMethodForSetter(targetClass, attribute, preferredType);
        if (retVal != null) {
            return retVal;
        }
        retVal = ReflectUtils.getFieldForSetter(targetClass, attribute);
        if (retVal == null) {
            throw new IllegalArgumentException("Could not find method or setter for attribute " + attribute + " on class " + targetClass.getName() + " with preferred type " + (preferredType == null ? "<null>" : preferredType.getName()));
        }
        return retVal;
    }

    private static Field getFieldForSetter(Class<?> targetClass, String attribute) {
        try {
            return targetClass.getDeclaredField(attribute);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    private static Method getMethodForSetter(Class<?> targetClass, String attribute, Class<?> preferredType) throws IllegalArgumentException {
        String methodName = ReflectUtils.constructBeanMethodName(SET_PFX, attribute);
        if (preferredType != null) {
            try {
                return targetClass.getDeclaredMethod(methodName, preferredType);
            }
            catch (NoSuchMethodException e) {
                Method matchByName;
                if (classTranslation.containsKey(preferredType)) {
                    try {
                        return targetClass.getDeclaredMethod(methodName, classTranslation.get(preferredType));
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                if ((matchByName = ReflectUtils.getMatchByName(targetClass, methodName)) == null || !matchByName.getParameterTypes()[0].isAssignableFrom(preferredType)) {
                    return null;
                }
                return matchByName;
            }
        }
        return ReflectUtils.getMatchByName(targetClass, methodName);
    }

    private static Method getMatchByName(Class<?> targetClass, String methodName) {
        Method retVal = null;
        for (Method method : targetClass.getDeclaredMethods()) {
            Class<?>[] parameters;
            if (!methodName.equals(method.getName()) || (parameters = method.getParameterTypes()) == null || parameters.length != 1) continue;
            if (retVal != null) {
                throw new IllegalArgumentException("There are two methods named " + methodName + " on class " + targetClass.getName() + " that could be used");
            }
            retVal = method;
        }
        return retVal;
    }

    public static String constructBeanMethodName(String prefix, String attribute) {
        String firstChar = attribute.substring(0, 1);
        String otherChars = attribute.substring(1);
        firstChar = firstChar.toUpperCase();
        return prefix + firstChar + otherChars;
    }

    public static List<Method> getDeclaredMethodsOfAGivenName(Class<?> clazz, String name) {
        Method[] allDeclaredMethods;
        LinkedList<Method> retVal = new LinkedList<Method>();
        if (clazz == null || name == null) {
            return retVal;
        }
        for (Method method : allDeclaredMethods = clazz.getDeclaredMethods()) {
            if (!name.equals(method.getName())) continue;
            retVal.add(method);
        }
        return retVal;
    }

    static {
        primMap.put(Boolean.TYPE.getName(), Boolean.TYPE);
        primMap.put(Character.TYPE.getName(), Character.TYPE);
        primMap.put(Byte.TYPE.getName(), Byte.TYPE);
        primMap.put(Short.TYPE.getName(), Short.TYPE);
        primMap.put(Integer.TYPE.getName(), Integer.TYPE);
        primMap.put(Long.TYPE.getName(), Long.TYPE);
        primMap.put(Float.TYPE.getName(), Float.TYPE);
        primMap.put(Double.TYPE.getName(), Double.TYPE);
        classTranslation.put(Short.class, Short.TYPE);
        classTranslation.put(Integer.class, Integer.TYPE);
        classTranslation.put(Long.class, Long.TYPE);
        classTranslation.put(Float.class, Float.TYPE);
        classTranslation.put(Double.class, Double.TYPE);
        classTranslation.put(Boolean.class, Boolean.TYPE);
        classTranslation.put(Character.class, Character.TYPE);
        classTranslation.put(Byte.class, Byte.TYPE);
        primitiveToLang.put("short", Short.class.getName());
        primitiveToLang.put("int", Integer.class.getName());
        primitiveToLang.put("long", Long.class.getName());
        primitiveToLang.put("float", Float.class.getName());
        primitiveToLang.put("double", Double.class.getName());
        primitiveToLang.put("boolean", Boolean.class.getName());
        primitiveToLang.put("char", Character.class.getName());
        primitiveToLang.put("byte", Byte.class.getName());
    }

    private static class EnumerationImpl<T>
    implements Enumeration<T> {
        private Iterator<T> iterator;

        private EnumerationImpl(Collection<T> bar) {
            this.iterator = bar.iterator();
        }

        @Override
        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        @Override
        public T nextElement() {
            return this.iterator.next();
        }
    }

    private static class MKey {
        private Method method;

        MKey(Method m) {
            this.method = m;
        }

        public boolean equals(Object o) {
            try {
                Class<?>[] params2;
                Method m2 = ((MKey)o).method;
                if (!this.method.getName().equals(m2.getName())) {
                    return false;
                }
                Class<?>[] params = this.method.getParameterTypes();
                if (params.length != (params2 = m2.getParameterTypes()).length) {
                    return false;
                }
                for (int i = 0; i < params.length; ++i) {
                    if (params[i] == params2[i]) continue;
                    return false;
                }
            }
            catch (ClassCastException cce) {
                return false;
            }
            return true;
        }

        public int hashCode() {
            int h = this.method.getName().hashCode();
            Class<?>[] params = this.method.getParameterTypes();
            for (int i = 0; i < params.length; ++i) {
                h ^= params[i].hashCode();
            }
            return h;
        }
    }

    private static class SuperclassEnumerator
    extends PeekingEnumerator {
        private Class<?> c;

        SuperclassEnumerator(Class<?> c) {
            this.c = c.getSuperclass();
        }

        @Override
        protected Object nextObject() {
            if (this.c == null) {
                return END;
            }
            Class<?> tmp = this.c;
            this.c = this.c.getSuperclass();
            return tmp;
        }
    }
}

