/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.reflect;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class MethodKey {
    Method m;

    public MethodKey(Method m) {
        this.m = m;
    }

    public boolean equals(Object o) {
        try {
            Class<?>[] exceps2;
            Class<?>[] params2;
            Method m2 = ((MethodKey)o).m;
            if (!this.m.getName().equals(m2.getName())) {
                return false;
            }
            if (this.m.getReturnType() != m2.getReturnType()) {
                return false;
            }
            Class<?>[] params = this.m.getParameterTypes();
            if (params.length != (params2 = m2.getParameterTypes()).length) {
                return false;
            }
            for (int i = 0; i < params.length; ++i) {
                if (params[i] == params2[i]) continue;
                return false;
            }
            Class<?>[] exceps = this.m.getExceptionTypes();
            if (exceps.length != (exceps2 = m2.getExceptionTypes()).length) {
                return false;
            }
            for (int i = 0; i < exceps.length; ++i) {
                if (exceps[i] == exceps2[i]) continue;
                return false;
            }
        }
        catch (ClassCastException cce) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = this.m.getName().hashCode();
        h ^= this.m.getReturnType().hashCode();
        Class<?>[] params = this.m.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            h ^= params[i].hashCode();
        }
        Class<?>[] exceps = this.m.getExceptionTypes();
        for (int i = 0; i < exceps.length; ++i) {
            h ^= exceps[i].hashCode();
        }
        return h;
    }

    private String asString(Class[] c) {
        if (c.length == 0) {
            return "";
        }
        StringBuffer o = new StringBuffer(" ");
        for (int i = 0; i < c.length; ++i) {
            o = o.append(c[i].getName());
            if (i >= c.length - 1) continue;
            o = o.append(", ");
        }
        return o.toString();
    }

    public String toString() {
        Class<?>[] exceptions = this.m.getExceptionTypes();
        Class<?>[] parameters = this.m.getParameterTypes();
        if (exceptions.length == 0 && parameters.length == 0) {
            return Modifier.toString(this.m.getModifiers()) + " " + this.m.getReturnType() + " " + this.m.getName() + "()";
        }
        if (exceptions.length != 0 && parameters.length == 0) {
            return Modifier.toString(this.m.getModifiers()) + " " + this.m.getReturnType() + " " + this.m.getName() + "() " + this.asString(this.m.getExceptionTypes());
        }
        if (exceptions.length == 0 && parameters.length != 0) {
            return Modifier.toString(this.m.getModifiers()) + " " + this.m.getReturnType() + " " + this.m.getName() + "(" + this.asString(this.m.getParameterTypes()) + ")";
        }
        return Modifier.toString(this.m.getModifiers()) + " " + this.m.getReturnType() + " " + this.m.getName() + "(" + this.asString(this.m.getParameterTypes()) + ") " + this.asString(this.m.getExceptionTypes());
    }
}

