/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.osgi;

import weblogic.utils.osgi.OSGiVersion;

public class OSGiVersionRange {
    private static final String LOWER_INCLUSIVE = "[";
    private static final String LOWER_EXCLUSIVE = "(";
    private static final String COMMA = ",";
    private static final String UPPER_INCLUSIVE = "]";
    private static final String UPPER_EXCLUSIVE = ")";
    private static final String STAR = "*";
    private final OSGiVersion minVersion;
    private final boolean minInclusive;
    private final OSGiVersion maxVersion;
    private final boolean maxExclusive;

    public OSGiVersionRange(OSGiVersion minVersion, boolean minInclusive, OSGiVersion maxVersion, boolean maxExclusive) {
        this.minVersion = minVersion;
        this.minInclusive = minInclusive;
        this.maxVersion = maxVersion;
        this.maxExclusive = maxExclusive;
        if (minVersion.compareTo(maxVersion) > 0) {
            throw new IllegalArgumentException();
        }
    }

    public OSGiVersionRange(String parseMe) throws IllegalArgumentException {
        parseMe = parseMe.trim();
        int lowerToken = parseMe.indexOf(91);
        if (lowerToken < 0) {
            lowerToken = parseMe.indexOf(40);
            if (lowerToken < 0) {
                OSGiVersion onlyVersion;
                this.minVersion = onlyVersion = new OSGiVersion(parseMe);
                this.minInclusive = true;
                this.maxVersion = onlyVersion;
                this.maxExclusive = false;
                return;
            }
            this.minInclusive = false;
        } else {
            this.minInclusive = true;
        }
        int commaIndex = parseMe.indexOf(COMMA);
        if (commaIndex < 0) {
            throw new IllegalArgumentException();
        }
        String lowerVersion = parseMe.substring(lowerToken + 1, commaIndex).trim();
        this.minVersion = new OSGiVersion(lowerVersion);
        int upperToken = parseMe.indexOf(41, commaIndex);
        if (upperToken < 0) {
            upperToken = parseMe.indexOf(93, commaIndex);
            if (upperToken < 0) {
                throw new IllegalArgumentException();
            }
            this.maxExclusive = false;
        } else {
            this.maxExclusive = true;
        }
        String upperVersion = parseMe.substring(commaIndex + 1, upperToken).trim();
        this.maxVersion = STAR.equals(upperVersion) ? OSGiVersion.STAR_VERSION : new OSGiVersion(upperVersion);
        if (this.minVersion.compareTo(this.maxVersion) > 0) {
            throw new IllegalArgumentException();
        }
    }

    public boolean isVersionInRange(OSGiVersion checkMe) {
        int comparedToMin = checkMe.compareTo(this.minVersion);
        if (comparedToMin < 0) {
            return false;
        }
        if (comparedToMin == 0 && !this.minInclusive) {
            return false;
        }
        int comparedToMax = checkMe.compareTo(this.maxVersion);
        if (comparedToMax > 0) {
            return false;
        }
        return comparedToMax != 0 || !this.maxExclusive;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.minInclusive) {
            sb.append(LOWER_INCLUSIVE);
        } else {
            sb.append(LOWER_EXCLUSIVE);
        }
        sb.append(this.minVersion.toString());
        sb.append(COMMA);
        sb.append(this.maxVersion.toString());
        if (this.maxExclusive) {
            sb.append(UPPER_EXCLUSIVE);
        } else {
            sb.append(UPPER_INCLUSIVE);
        }
        return sb.toString();
    }
}

