/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.osgi;

import java.util.StringTokenizer;

public class OSGiVersion
implements Comparable<OSGiVersion> {
    private static final int DOT = 46;
    private static final String EMPTY = "";
    public static final OSGiVersion STAR_VERSION = new OSGiVersion();
    private final int major;
    private final int minor;
    private final int patch;
    private final String description;
    private final boolean isStar;

    private OSGiVersion() {
        this.major = Integer.MAX_VALUE;
        this.minor = Integer.MAX_VALUE;
        this.patch = Integer.MAX_VALUE;
        this.description = EMPTY;
        this.isStar = true;
    }

    public OSGiVersion(int major, int minor, int patch, String description) {
        if (description == null) {
            description = EMPTY;
        }
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.description = description;
        this.isStar = false;
    }

    public OSGiVersion(String fromString) throws IllegalArgumentException {
        if (fromString == null) {
            throw new IllegalArgumentException();
        }
        if ((fromString = fromString.trim()).length() <= 0) {
            throw new IllegalArgumentException();
        }
        StringTokenizer st = new StringTokenizer(fromString, ".");
        Integer lMajor = null;
        Integer lMinor = null;
        Integer lPatch = null;
        boolean hasDescription = false;
        int lcv = 0;
        block5: while (st.hasMoreTokens()) {
            switch (lcv++) {
                case 0: {
                    lMajor = Integer.parseInt(st.nextToken());
                    continue block5;
                }
                case 1: {
                    lMinor = Integer.parseInt(st.nextToken());
                    continue block5;
                }
                case 2: {
                    lPatch = Integer.parseInt(st.nextToken());
                    continue block5;
                }
            }
            st.nextToken();
            hasDescription = true;
        }
        String lDescription = EMPTY;
        if (hasDescription) {
            int index = fromString.indexOf(46);
            index = fromString.indexOf(46, index + 1);
            index = fromString.indexOf(46, index + 1);
            lDescription = fromString.substring(index + 1);
        }
        this.major = lMajor == null ? 0 : lMajor;
        this.minor = lMinor == null ? 0 : lMinor;
        this.patch = lPatch == null ? 0 : lPatch;
        this.description = lDescription;
        this.isStar = false;
        if (this.major < 0 || this.minor < 0 || this.patch < 0) {
            throw new IllegalArgumentException();
        }
    }

    public int hashCode() {
        return this.major ^ this.minor ^ this.patch ^ this.description.hashCode() ^ (this.isStar ? -1 : 0);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof OSGiVersion)) {
            return false;
        }
        OSGiVersion other = (OSGiVersion)o;
        if (this.major != other.major) {
            return false;
        }
        if (this.minor != other.minor) {
            return false;
        }
        if (this.patch != other.patch) {
            return false;
        }
        if (!this.description.equals(other.description)) {
            return false;
        }
        return this.isStar == other.isStar;
    }

    @Override
    public int compareTo(OSGiVersion o) {
        if (this.major > o.major) {
            return 1;
        }
        if (this.major < o.major) {
            return -1;
        }
        if (this.minor > o.minor) {
            return 1;
        }
        if (this.minor < o.minor) {
            return -1;
        }
        if (this.patch > o.patch) {
            return 1;
        }
        if (this.patch < o.patch) {
            return -1;
        }
        if (this.isStar) {
            if (o.isStar) {
                return 0;
            }
            return 1;
        }
        if (o.isStar) {
            return -1;
        }
        return this.description.compareTo(o.description);
    }

    public String toString() {
        if (this.isStar) {
            return "*";
        }
        if (EMPTY.equals(this.description)) {
            return this.major + "." + this.minor + "." + this.patch;
        }
        return this.major + "." + this.minor + "." + this.patch + "." + this.description;
    }
}

