/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.net;

import java.io.EOFException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.SocketException;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedChannelException;
import weblogic.utils.NestedThrowable;

public class SocketResetException
extends SocketException
implements NestedThrowable {
    private static final long serialVersionUID = 2608888081621018043L;
    public static final String[] RESET_MESSAGE = new String[]{"by peer", "broken pipe", "network name is no longer available", "closed", "a connection with a remote socket was reset by that socket", "there is no process to read data written to a pipe", "connection timed out", "readfile failed", "connection was aborted", "software caused connection abort", "connection reset", "socket operation on nonsocket: recv failed", "null fd object", "error 64", "bad file number", "error in poll for fd"};
    private IOException nested;

    public static boolean isResetException(IOException ioe) {
        if (ioe instanceof SocketResetException) {
            return true;
        }
        if (ioe instanceof AsynchronousCloseException) {
            return true;
        }
        if (ioe instanceof ClosedChannelException) {
            return true;
        }
        if (ioe instanceof EOFException) {
            return true;
        }
        String message = ioe.getMessage();
        if (message == null) {
            return false;
        }
        message = message.toLowerCase();
        for (int i = 0; i < RESET_MESSAGE.length; ++i) {
            if (message.indexOf(RESET_MESSAGE[i]) == -1) continue;
            return true;
        }
        return false;
    }

    public SocketResetException() {
    }

    public SocketResetException(String message) {
        super(message);
    }

    public SocketResetException(IOException ioe) {
        this.nested = ioe;
    }

    public SocketResetException(String message, IOException ioe) {
        super(message);
        this.nested = ioe;
    }

    @Override
    public Throwable getNested() {
        return this.nested;
    }

    @Override
    public String superToString() {
        return super.toString();
    }

    @Override
    public void superPrintStackTrace(PrintStream ps) {
        super.printStackTrace(ps);
    }

    @Override
    public void superPrintStackTrace(PrintWriter pw) {
        super.printStackTrace(pw);
    }

    @Override
    public String toString() {
        return NestedThrowable.Util.toString(this);
    }

    @Override
    public void printStackTrace(PrintStream s) {
        NestedThrowable.Util.printStackTrace((NestedThrowable)this, s);
    }

    @Override
    public void printStackTrace(PrintWriter w) {
        NestedThrowable.Util.printStackTrace((NestedThrowable)this, w);
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }
}

