/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.net;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import weblogic.utils.net.AddressUtils;

public class InetAddressHelper {
    public static boolean isIPV6Address(String url) {
        int atIndex = -1;
        if (url == null || (atIndex = url.indexOf("@")) != -1 && url.lastIndexOf(":") > atIndex || url.indexOf("[") != -1 || url.startsWith("file:")) {
            return false;
        }
        if (url.indexOf("::") != -1) {
            return true;
        }
        if (url.indexOf(".") == -1) {
            StringTokenizer st = new StringTokenizer(url, ":");
            return st.countTokens() > 3;
        }
        return false;
    }

    public static String convertToIPV6URL(String url) {
        if (url.indexOf("[") != -1 || url.indexOf("localhost") != -1 || url.indexOf(":") == -1) {
            return url;
        }
        if (url.indexOf("corbaloc") != -1) {
            return InetAddressHelper.convertCorbaURL(url);
        }
        int protocolIndex = -1;
        protocolIndex = url.indexOf("://");
        if (protocolIndex == -1) {
            return InetAddressHelper.convertHostPortURL(url);
        }
        return InetAddressHelper.convertProtocolHostPortURL(url, protocolIndex);
    }

    public static String convertIfIPV6URL(String url) {
        if (InetAddressHelper.isIPV6Address(url)) {
            return InetAddressHelper.convertToIPV6URL(url);
        }
        return url;
    }

    public static String convertHostIfIPV6(String host) {
        if (InetAddressHelper.isIPV6Address(host) && host.indexOf("[") == -1) {
            return "[" + host + "]";
        }
        return host;
    }

    private static String convertHostPortURL(String url) {
        int portIndex = url.lastIndexOf(":");
        if (portIndex == -1) {
            return url;
        }
        int queryIndex = url.indexOf("/");
        if (queryIndex == -1 || queryIndex < portIndex) {
            queryIndex = url.length();
        }
        String host = url.substring(0, portIndex);
        String port = url.substring(portIndex, queryIndex);
        String queryString = "";
        if (queryIndex < url.length()) {
            queryString = url.substring(queryIndex, url.length());
        }
        return "[" + host + "]" + port + queryString;
    }

    private static String convertProtocolHostPortURL(String url, int protocolIndex) {
        int portIndex = url.lastIndexOf(":");
        if (portIndex <= protocolIndex) {
            return url;
        }
        int queryIndex = url.lastIndexOf("/");
        String queryString = "";
        if (queryIndex > protocolIndex + 3) {
            queryString = url.substring(queryIndex);
        } else {
            queryIndex = url.length();
        }
        String host = url.substring(protocolIndex + 3, portIndex);
        String protocol = url.substring(0, protocolIndex + 3);
        String port = url.substring(portIndex, queryIndex);
        return protocol + "[" + host + "]" + port + queryString;
    }

    private static String convertCorbaURL(String url) {
        int iiopIndex = url.indexOf("iiop");
        int secondColonIndex = url.indexOf(":", iiopIndex + 1);
        int portIndex = url.lastIndexOf(":");
        String protocol = url.substring(0, secondColonIndex + 1);
        String host = url.substring(secondColonIndex + 1, portIndex);
        String port = url.substring(portIndex);
        return protocol + "[" + host + "]" + port;
    }

    public static boolean hasIPv4Stack() {
        for (InetAddress ia : AddressUtils.getIPAny()) {
            if (!(ia instanceof Inet4Address)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasIPv6Stack() {
        for (InetAddress ia : AddressUtils.getIPAny()) {
            if (!(ia instanceof Inet6Address)) continue;
            return true;
        }
        return false;
    }

    public static boolean isIPv6MulticastAddress(String mcastAddress) {
        try {
            InetAddress ia = InetAddress.getByName(mcastAddress);
            if (ia instanceof Inet4Address) {
                return false;
            }
            return ia.isMulticastAddress();
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
    }

    public static boolean isIPv4MulticastAddress(String mcastAddress) {
        try {
            InetAddress ia = InetAddress.getByName(mcastAddress);
            if (ia instanceof Inet6Address) {
                return false;
            }
            return ia.isMulticastAddress();
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
    }
}

