/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.net;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;

public class AddressUtils {
    public static InetAddress getLoopback() {
        return AddressMaker.LOOPBACK;
    }

    public static InetAddress getLocalHost() {
        return AddressMaker.LOCALHOST;
    }

    public static InetAddress[] getIPAny() {
        return AddressMaker.IP_ANY;
    }

    public static InetAddress getIPForLocalHost() {
        return AddressMaker.IP_ANY[0];
    }

    public static String getIPAny(int index, boolean resolve) {
        return resolve ? AddressMaker.IP_ANY[index].getHostName().toLowerCase() : AddressMaker.IP_ANY[index].getHostAddress();
    }

    private static class AddressMaker {
        private static final InetAddress LOOPBACK = AddressMaker.getLoopback();
        private static final InetAddress LOCALHOST = AddressMaker.getLocalHost();
        private static final InetAddress[] IP_ANY = AddressMaker.getAllAddresses();

        private AddressMaker() {
        }

        private static InetAddress getLoopback() {
            try {
                return InetAddress.getByName(null);
            }
            catch (UnknownHostException uhe) {
                AssertionError assertion = new AssertionError((Object)"Could not obtain the loopback address. The most likely cause is an error in the network configuration of this machine.");
                ((Throwable)((Object)assertion)).initCause(uhe);
                throw assertion;
            }
        }

        private static InetAddress getLocalHost() {
            try {
                return InetAddress.getLocalHost();
            }
            catch (UnknownHostException uhe) {
                AssertionError assertion = new AssertionError((Object)"Could not obtain the localhost address. The most likely cause is an error in the network configuration of this machine.");
                ((Throwable)((Object)assertion)).initCause(uhe);
                throw assertion;
            }
        }

        private static InetAddress[] getAllAddresses() {
            try {
                ArrayList<InetAddress> ips = new ArrayList<InetAddress>();
                ArrayList<InetAddress> loopbacks = new ArrayList<InetAddress>();
                ArrayList<InetAddress> sitelocals = new ArrayList<InetAddress>();
                ArrayList<InetAddress> virtualips = new ArrayList<InetAddress>();
                ArrayList<InetAddress> virtualloopbacks = new ArrayList<InetAddress>();
                ArrayList<InetAddress> virtualsitelocals = new ArrayList<InetAddress>();
                ips.add(LOCALHOST);
                Enumeration<NetworkInterface> eni = NetworkInterface.getNetworkInterfaces();
                while (eni.hasMoreElements()) {
                    InetAddress ia;
                    Enumeration<InetAddress> eia;
                    NetworkInterface ni = eni.nextElement();
                    boolean isVirtual = ni.isVirtual();
                    if (isVirtual) {
                        eia = ni.getInetAddresses();
                        while (eia.hasMoreElements()) {
                            ia = eia.nextElement();
                            if (ia.equals(LOCALHOST)) continue;
                            if (ia.isLoopbackAddress()) {
                                virtualloopbacks.add(ia);
                                continue;
                            }
                            if (ia.isSiteLocalAddress()) {
                                virtualsitelocals.add(ia);
                                continue;
                            }
                            if (ia.isLinkLocalAddress() || ia.isMulticastAddress() || ia.isAnyLocalAddress()) continue;
                            virtualips.add(ia);
                        }
                        continue;
                    }
                    eia = ni.getInetAddresses();
                    while (eia.hasMoreElements()) {
                        ia = eia.nextElement();
                        if (ia.equals(LOCALHOST)) continue;
                        if (ia.isLoopbackAddress()) {
                            loopbacks.add(ia);
                            continue;
                        }
                        if (ia.isSiteLocalAddress()) {
                            sitelocals.add(ia);
                            continue;
                        }
                        if (ia.isLinkLocalAddress() || ia.isMulticastAddress() || ia.isAnyLocalAddress()) continue;
                        ips.add(ia);
                    }
                }
                if (!virtualips.isEmpty()) {
                    ips.addAll(virtualips);
                }
                if (!sitelocals.isEmpty()) {
                    ips.addAll(sitelocals);
                }
                if (!virtualsitelocals.isEmpty()) {
                    ips.addAll(virtualsitelocals);
                }
                if (!loopbacks.isEmpty()) {
                    ips.addAll(loopbacks);
                }
                if (!virtualloopbacks.isEmpty()) {
                    ips.addAll(virtualloopbacks);
                }
                return ips.toArray(new InetAddress[ips.size()]);
            }
            catch (SocketException se) {
                AssertionError assertion = new AssertionError((Object)"An error occurred while retrieving the network addresses for this machine. The most likely cause is an error in the network configuration of this machine.");
                ((Throwable)((Object)assertion)).initCause(se);
                throw assertion;
            }
        }
    }
}

