/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.jars;

import java.io.File;
import java.io.IOException;
import java.util.jar.JarFile;
import weblogic.utils.jars.ExplodedJarFile;
import weblogic.utils.jars.JarFileDelegate;
import weblogic.utils.jars.SplitExplodedJarFile;
import weblogic.utils.jars.VirtualJarFile;

public final class VirtualJarFactory {
    private VirtualJarFactory() {
    }

    public static VirtualJarFile createVirtualJar(File[] f) throws IOException {
        if (f.length == 1) {
            return VirtualJarFactory.createVirtualJar(f[0]);
        }
        return new SplitExplodedJarFile(f);
    }

    public static VirtualJarFile createVirtualJar(File f) throws IOException {
        if (f.isDirectory()) {
            return new ExplodedJarFile(f);
        }
        return new JarFileDelegate(f);
    }

    public static VirtualJarFile createVirtualJar(File srcDir, File outDir) {
        return new SplitExplodedJarFile(srcDir, outDir);
    }

    public static VirtualJarFile createVirtualJar(JarFile jf) {
        return new JarFileDelegate(jf);
    }
}

