/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.jars;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public final class ManifestManager {
    private static final String MANIFEST = "META-INF/MANIFEST.MF";
    private static final String SERVICES = "META-INF/services";
    private static final String WLS_MAIN_JAR_MATCH_STRING = "/weblogic.jar";
    private static final boolean DEBUG = false;
    private static volatile boolean firstCallForManifests = true;
    private static volatile ArrayList<Manifest> cache = null;

    public static Iterator<Manifest> getManifests(boolean wlsMainOnly) {
        if (firstCallForManifests || wlsMainOnly) {
            firstCallForManifests = false;
            return ManifestManager.getManifestEntries(wlsMainOnly).iterator();
        }
        if (cache == null) {
            cache = ManifestManager.getManifestEntries(false);
        }
        return cache.iterator();
    }

    public static Iterator<Manifest> getManifests() {
        return ManifestManager.getManifests(false);
    }

    public static <T> ArrayList<T> getServices(Class<T> c) {
        return ManifestManager.getProviderEntries(c);
    }

    public static <T> ArrayList<T> getServices(Class<T> c, ClassLoader cl) {
        return ManifestManager.getProviderEntries(c, cl);
    }

    private ManifestManager() {
    }

    private static ArrayList<Manifest> getManifestEntries(boolean wlsMainOnly) {
        Enumeration<URL> e;
        ClassLoader cl = ManifestManager.class.getClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        ArrayList<Manifest> manifestsReturn = new ArrayList<Manifest>();
        try {
            e = cl.getResources(MANIFEST);
        }
        catch (IOException ioe) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)ioe.getMessage()))).initCause(ioe);
        }
        boolean ctr = false;
        while (e.hasMoreElements()) {
            try {
                File f;
                URI uri;
                URL url = e.nextElement();
                String file = url.toString();
                if (wlsMainOnly && file.indexOf(WLS_MAIN_JAR_MATCH_STRING) < 0) continue;
                if (file.startsWith("jar:file:")) {
                    uri = new URI(file.substring(4, file.indexOf(33)));
                    f = null;
                    f = uri.getAuthority() != null ? new File(file.substring(9, file.indexOf(33))) : new File(uri);
                    if (!f.exists() || !f.canRead() || !f.isFile()) continue;
                    JarFile jar = new JarFile(f, false, 1);
                    manifestsReturn.add(jar.getManifest());
                    jar.close();
                } else if (!wlsMainOnly && file.startsWith("zip:")) {
                    URI uri2;
                    File f2;
                    String file1 = file = file.substring(4, file.indexOf(33));
                    if (!file1.startsWith("/")) {
                        file1 = "/" + file1;
                    }
                    if (!(f2 = (uri2 = new URI(file1 = "file:" + file1)).getAuthority() != null ? new File(file) : new File(uri2)).exists() || !f2.canRead() || !f2.isFile()) continue;
                    JarFile jar = new JarFile(f2, false, 1);
                    manifestsReturn.add(jar.getManifest());
                    jar.close();
                } else {
                    if (wlsMainOnly || !file.startsWith("file:") || !(f = (uri = new URI(file)).getAuthority() != null ? new File(file.substring(5)) : new File(uri)).exists() || !f.canRead() || !f.isFile()) continue;
                    FileInputStream fin = new FileInputStream(f);
                    manifestsReturn.add(new Manifest(fin));
                    fin.close();
                }
                if (!wlsMainOnly || manifestsReturn.isEmpty()) continue;
                return manifestsReturn;
            }
            catch (IOException ioe2) {
            }
            catch (URISyntaxException use) {
            }
        }
        return manifestsReturn;
    }

    private static <T> ArrayList<T> getProviderEntries(Class<T> service) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        return ManifestManager.getProviderEntries(service, cl);
    }

    private static <T> ArrayList<T> getProviderEntries(Class<T> service, ClassLoader cl) {
        Enumeration<URL> e;
        ArrayList ret = new ArrayList();
        try {
            e = cl.getResources("META-INF/services/" + service.getName());
        }
        catch (IOException ioe) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)ioe.getMessage()))).initCause(ioe);
        }
        while (e.hasMoreElements()) {
            try {
                String line;
                URL url = e.nextElement();
                InputStream in = url.openStream();
                InputStreamReader r = new InputStreamReader(in);
                BufferedReader br = new BufferedReader(r);
                while ((line = br.readLine()) != null) {
                    int idx = line.indexOf(35);
                    if (idx >= 0) {
                        line = line.substring(0, idx);
                    }
                    if ((line = line.trim()).length() <= 0) continue;
                    try {
                        ret.add(cl.loadClass(line).newInstance());
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (InstantiationException instantiationException) {}
                }
                br.close();
                ((Reader)r).close();
                in.close();
            }
            catch (IOException iOException) {}
        }
        return ret;
    }

    private static void p(String msg) {
        System.out.println("<ManifestManager>: " + msg);
    }
}

