/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.jars;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import weblogic.utils.Debug;
import weblogic.utils.FileUtils;
import weblogic.utils.io.DataIO;
import weblogic.utils.io.StreamUtils;
import weblogic.utils.jars.VirtualJarFactory;
import weblogic.utils.jars.VirtualJarFile;

public final class JarFileUtils {
    private static final boolean debug = true;
    private static final String MANIFEST_FILE_NAME = "META-INF/MANIFEST.MF";
    private static final byte[] MAGIC_NUMBER = new byte[]{80, 75, 3, 4};

    private JarFileUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createJarFileFromDirectory(File jar, File dir, String rootPath) throws IOException {
        Debug.assertion(jar != null);
        Debug.assertion(dir != null);
        Debug.assertion(dir.isDirectory());
        if (jar.exists()) {
            Debug.assertion(!jar.isDirectory());
        }
        try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(jar));
             JarOutputStream jos = new JarOutputStream(fos);){
            JarFileUtils.addFilesToJar(jos, rootPath, dir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addFilesToJar(JarOutputStream jos, String rootPath, File dir) throws IOException {
        for (File f : dir.listFiles()) {
            String zeName = f.isDirectory() ? rootPath + f.getName() + '/' : rootPath + f.getName();
            if (MANIFEST_FILE_NAME.equals(zeName)) continue;
            ZipEntry ze = new ZipEntry(zeName);
            ze.setTime(f.lastModified());
            jos.putNextEntry(ze);
            if (f.isDirectory()) {
                jos.closeEntry();
                JarFileUtils.addFilesToJar(jos, zeName, f);
                continue;
            }
            try (FileInputStream fis = new FileInputStream(f);){
                StreamUtils.writeTo(fis, jos);
                jos.closeEntry();
            }
        }
    }

    public static void createJarFileFromDirectory(String jar, File dir) throws IOException {
        JarFileUtils.createJarFileFromDirectory(new File(jar), dir);
    }

    public static void createJarFileFromDirectory(File jarFile, File dir) throws IOException {
        JarFileUtils.createJarFileFromDirectory(jarFile, dir, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createJarFileFromDirectory(File jarFile, File dir, boolean forceManifestCreation) throws IOException {
        Manifest man;
        File manFile = new File(dir, MANIFEST_FILE_NAME);
        if (manFile.exists()) {
            try (FileInputStream fis = new FileInputStream(manFile);){
                man = new Manifest(fis);
            }
        } else {
            man = forceManifestCreation ? new Manifest() : null;
        }
        JarFileUtils.createJarFileFromDirectory(jarFile, dir, man);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createJarFileFromDirectory(File jar, File dir, Manifest man) throws IOException {
        Debug.assertion(jar != null);
        Debug.assertion(dir != null);
        Debug.assertion(dir.isDirectory());
        if (jar.exists()) {
            Debug.assertion(!jar.isDirectory());
        }
        try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(jar));
             JarOutputStream jos = man != null ? new JarOutputStream((OutputStream)fos, man) : new JarOutputStream(fos);){
            JarFileUtils.addFilesToJar(jos, "", dir);
        }
    }

    public static void extract(InputStream jar, File dir) throws IOException {
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File tempFile = File.createTempFile("__tmp", ".jar", dir);
        try {
            FileUtils.writeToFile(jar, tempFile);
            JarFileUtils.extract(tempFile, dir);
        }
        finally {
            tempFile.delete();
        }
    }

    public static void extract(File jar, File dir) throws IOException {
        try (VirtualJarFile vj = VirtualJarFactory.createVirtualJar(jar);){
            JarFileUtils.extract(vj, dir);
        }
    }

    public static void extract(JarFile jar, File dir) throws IOException {
        JarFileUtils.extract(VirtualJarFactory.createVirtualJar(jar), dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extract(VirtualJarFile jar, File dir) throws IOException {
        Debug.assertion(jar != null);
        Debug.assertion(dir != null);
        if (dir.exists()) {
            Debug.assertion(dir.isDirectory());
        }
        if (!dir.exists()) {
            dir.mkdirs();
        }
        String dirCanonPath = dir.getCanonicalPath();
        dir = dir.getCanonicalFile();
        ArrayList<DirLastModSetter> dirList = new ArrayList<DirLastModSetter>();
        Iterator<ZipEntry> i = jar.entries();
        while (i.hasNext()) {
            ZipEntry ze = i.next();
            long entryTime = ze.getTime();
            try {
                String fileName = ze.getName().replace('/', File.separatorChar);
                File f = new File(dir, fileName);
                if (!f.getCanonicalPath().startsWith(dirCanonPath)) {
                    throw new IOException("File path " + fileName + " is not contained within " + dirCanonPath);
                }
                if (ze.isDirectory()) {
                    f.mkdirs();
                    dirList.add(new DirLastModSetter(f, entryTime));
                    continue;
                }
                try (InputStream in = jar.getInputStream(ze);){
                    FileUtils.writeToFile(in, f);
                }
                f.setLastModified(entryTime);
            }
            catch (FileNotFoundException e) {
                throw new PathLengthException(e);
            }
        }
        JarFileUtils.updateLastModified(dirList);
    }

    private static final void updateLastModified(List<DirLastModSetter> dirList) {
        if (dirList == null || dirList.size() == 0) {
            return;
        }
        for (DirLastModSetter setter : dirList) {
            setter.updateLastModified();
        }
        dirList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isJar(File file) {
        try (FileInputStream in = new FileInputStream(file);){
            byte[] magicNumber = new byte[4];
            DataIO.readFully(in, magicNumber);
            for (int i = 0; i < 4; ++i) {
                if (magicNumber[i] == MAGIC_NUMBER[i]) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private static final class DirLastModSetter {
        private final File dir;
        private final long lastModified;

        DirLastModSetter(File f, long lastMod) {
            this.dir = f;
            this.lastModified = lastMod;
        }

        void updateLastModified() {
            this.dir.setLastModified(this.lastModified);
        }
    }

    public static class PathLengthException
    extends FileNotFoundException {
        public PathLengthException(FileNotFoundException cause) {
            super(cause.getMessage() + "::Probably the string length of the path of the file being extracted was too long or failed to overwrite the file");
            super.setStackTrace(cause.getStackTrace());
        }
    }
}

