/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.jars;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import weblogic.utils.collections.Iterators;
import weblogic.utils.enumerations.EmptyEnumerator;
import weblogic.utils.enumerations.FileEnumeration;
import weblogic.utils.jars.BaseExplodedJarFile;

final class ExplodedJarFile
extends BaseExplodedJarFile {
    private final File directory;

    public ExplodedJarFile(File directory) {
        this.directory = directory;
    }

    @Override
    public String getName() {
        return this.directory.toString();
    }

    @Override
    public void close() {
    }

    @Override
    public Iterator<ZipEntry> entries() {
        return this.getEntries(null);
    }

    @Override
    public Iterator<ZipEntry> getEntries(String uri) {
        File subDir = this.directory;
        if (uri != null && !uri.equals("/") && !(subDir = new File(this.directory, uri.replace('/', File.separatorChar))).exists()) {
            return Iterators.EMPTY_ITERATOR;
        }
        final File dir = subDir;
        return new Iterator<ZipEntry>(){
            private int dirLen;
            Enumeration e;
            {
                this.dirLen = ExplodedJarFile.this.directory.toString().length();
            }

            private void init() {
                if (this.e != null) {
                    return;
                }
                try {
                    this.e = new FileEnumeration(dir);
                }
                catch (FileNotFoundException fnfe) {
                    this.e = new EmptyEnumerator();
                }
            }

            @Override
            public ZipEntry next() {
                this.init();
                String filename = this.e.nextElement().toString();
                filename = filename.replace(File.separatorChar, '/').substring(this.dirLen + (filename.length() == this.dirLen ? 0 : 1));
                return new BaseExplodedJarFile.VirtualJarEntry(ExplodedJarFile.this.directory, filename);
            }

            @Override
            public boolean hasNext() {
                this.init();
                return this.e.hasMoreElements();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public ZipEntry getEntry(String name) {
        return this.getEntry(this.directory, name);
    }

    @Override
    public File[] getRootFiles() {
        return new File[]{this.directory};
    }

    @Override
    public File getDirectory() {
        return this.directory;
    }

    public String toString() {
        return "ExplodedJarFile{" + this.getName() + "}";
    }
}

