/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.jars;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import weblogic.utils.FileUtils;
import weblogic.utils.jars.VirtualJarFile;

abstract class BaseExplodedJarFile
implements VirtualJarFile {
    private Manifest manifest;
    private static final Logger LOGGER = Logger.getLogger("weblogic.utils.Debug");
    private final Map<String, VirtualJarEntry> entryCache = new HashMap<String, VirtualJarEntry>();

    BaseExplodedJarFile() {
    }

    @Override
    public Manifest getManifest() throws IOException {
        if (this.manifest == null) {
            VirtualJarEntry man = (VirtualJarEntry)this.getEntry("META-INF/MANIFEST.MF");
            if (man == null) {
                return null;
            }
            File f = man.getFile();
            if (f.exists()) {
                try (FileInputStream fis = new FileInputStream(f);){
                    this.manifest = new Manifest(fis);
                }
            }
        }
        return this.manifest;
    }

    @Override
    public InputStream getInputStream(ZipEntry ze) throws IOException {
        VirtualJarEntry vze = (VirtualJarEntry)ze;
        return new FileInputStream(vze.getFile());
    }

    protected ZipEntry getEntry(File dir, String name) {
        File f;
        VirtualJarEntry result = this.entryCache.get(name);
        if (result == null && (f = new File(dir, name.replace('/', File.separatorChar))).exists()) {
            result = new VirtualJarEntry(dir, name);
            this.entryCache.put(name, result);
        }
        return result;
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public JarFile getJarFile() {
        return null;
    }

    @Override
    public URL getResource(String name) {
        VirtualJarEntry e = (VirtualJarEntry)this.getEntry(name);
        try {
            return e == null ? null : e.getFile().toURL();
        }
        catch (IOException ioe) {
            return null;
        }
    }

    protected static class VirtualJarEntry
    extends JarEntry {
        private final File file;
        private long crc = -1L;

        VirtualJarEntry(File directory, String name) {
            super(name);
            this.file = new File(directory, name);
        }

        File getFile() {
            return this.file;
        }

        @Override
        public int hashCode() {
            return this.file.getName().hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof VirtualJarEntry) {
                VirtualJarEntry other = (VirtualJarEntry)o;
                try {
                    return this.file.getCanonicalPath().equals(other.file.getCanonicalPath());
                }
                catch (IOException ioe) {
                    throw new AssertionError((Object)("Unexpected exception " + ioe));
                }
            }
            return false;
        }

        @Override
        public void setTime(long time) {
            if (this.file == null) {
                super.setTime(time);
                return;
            }
            this.file.setLastModified(time);
        }

        @Override
        public long getTime() {
            if (this.file == null) {
                return super.getTime();
            }
            return this.file.lastModified();
        }

        @Override
        public void setSize(long size) {
            if (this.file == null) {
                super.setSize(size);
            }
        }

        @Override
        public long getSize() {
            if (this.file == null) {
                return super.getSize();
            }
            return this.file.length();
        }

        @Override
        public long getCompressedSize() {
            if (this.file == null) {
                return super.getCompressedSize();
            }
            return this.file.length();
        }

        @Override
        public void setCompressedSize(long csize) {
            if (this.file == null) {
                super.setCompressedSize(csize);
            }
        }

        @Override
        public void setCrc(long crc) {
            if (this.file == null) {
                super.setCrc(crc);
            }
            this.crc = crc;
        }

        @Override
        public long getCrc() {
            if (this.crc != -1L) {
                return this.crc;
            }
            if (this.file == null) {
                return super.getCrc();
            }
            try {
                return FileUtils.computeCRC(this.file);
            }
            catch (IOException ioe) {
                return -1L;
            }
        }

        @Override
        public boolean isDirectory() {
            if (this.file == null) {
                return super.isDirectory();
            }
            return this.file.isDirectory();
        }

        @Override
        public String getName() {
            if (this.file != null && this.file.isDirectory()) {
                return super.getName() + "/";
            }
            return super.getName();
        }
    }
}

