/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.io.oif;

import sun.misc.ObjectInputFilter;
import weblogic.utils.io.oif.WebLogicObjectInputFilterWrapperPerStreamInner;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class WebLogicObjectInputFilterWrapperPerStream
implements ObjectInputFilter {
    private ObjectInputFilter wrapperFilter;
    private ObjectInputFilter innerFilter;

    public WebLogicObjectInputFilterWrapperPerStream() {
    }

    public WebLogicObjectInputFilterWrapperPerStream(Object filter, long maxTimeLimit) {
        if (maxTimeLimit > 0L) {
            this.innerFilter = new WebLogicObjectInputFilterWrapperPerStreamInner(filter, maxTimeLimit);
            this.wrapperFilter = (ObjectInputFilter)filter;
        } else {
            this.innerFilter = this.wrapperFilter = (ObjectInputFilter)filter;
        }
    }

    public void replaceInnerFilter(long maxTimeLimit) {
        this.innerFilter = maxTimeLimit > 0L ? new WebLogicObjectInputFilterWrapperPerStreamInner(this.wrapperFilter, maxTimeLimit) : this.wrapperFilter;
    }

    public void replaceInnerFilter(long maxTimeLimit, Object argFilter) {
        ObjectInputFilter filter = (ObjectInputFilter)argFilter;
        if (maxTimeLimit > 0L) {
            this.innerFilter = new WebLogicObjectInputFilterWrapperPerStreamInner(filter, maxTimeLimit);
            this.wrapperFilter = filter;
        } else {
            this.innerFilter = filter;
            this.wrapperFilter = filter;
        }
    }

    public ObjectInputFilter.Status checkInput(ObjectInputFilter.FilterInfo filterInfo) {
        return this.innerFilter.checkInput(filterInfo);
    }

    static final class Dummy
    implements ObjectInputFilter {
        private boolean allow = false;

        public Dummy(boolean value) {
            this.allow = value;
        }

        public ObjectInputFilter.Status checkInput(ObjectInputFilter.FilterInfo filterInfo) {
            if (this.allow) {
                return ObjectInputFilter.Status.ALLOWED;
            }
            return ObjectInputFilter.Status.REJECTED;
        }
    }
}

