/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.io.oif;

import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import weblogic.utils.io.oif.FilterInitializationException;
import weblogic.utils.io.oif.JreFilterApiProxy;
import weblogic.utils.io.oif.MessageLogger;
import weblogic.utils.io.oif.PermissionChecker;
import weblogic.utils.io.oif.WebLogicFilterConfig;
import weblogic.utils.io.oif.WebLogicObjectInputFilterHelper;
import weblogic.utils.io.oif.WebLogicObjectInputFilterWrapperHelper;
import weblogic.utils.io.oif.WebLogicObjectInputFilterWrapperPerStream;

public final class WebLogicObjectInputFilter {
    private static final Set<String> primitiveTypes = new HashSet<String>(Arrays.asList("boolean", "byte", "char", "double", "float", "int", "long", "short", "void"));
    private static JreFilterApiProxy filterApiProxy = null;
    private static WebLogicFilterConfig filterConfig = null;
    private static boolean isJreFilteringAvailable = false;
    private static boolean isGlobalJreFilterConfigured = false;
    private static boolean isWebLogicJreFilterConfigured = false;
    private static Object jreFilterGlobal = null;
    private static Object jreFilterWebLogic = null;
    private static Object jreFilterUnauthenticated = null;
    private static String unauthenticatedSerialFilter = null;
    private static Set<String> LEGACY_BLACKLIST = null;
    private static boolean initialized = false;
    private static boolean globalScopeAllowed = false;
    public static final String MAX_DESERIL_TIME_LIMIT_PROP = "weblogic.rmi.stream.deserialization.timelimitmillis";
    public static final long MAX_DESERIL_TIME_LIMIT_DEF = 0L;
    private static Exception initializationException = null;
    public static final Set<String> serialListRecordedClasses = new HashSet<String>();
    public static final Set<String> globalListRecordedClasses = new HashSet<String>();
    private static PermissionChecker permissionChecker = null;
    private static boolean isKernelPermissionSet = false;
    private static MessageLogger messageLogger = null;
    private static long maxTimeLimit = 0L;
    private static String propFileDir;

    protected WebLogicObjectInputFilter() {
    }

    private static synchronized void initializeInternal(boolean isStaticInit, JreFilterApiProxy proxy) {
        block15: {
            if (!globalScopeAllowed && proxy != null) {
                globalScopeAllowed = true;
            }
            if (!initialized || proxy != null) {
                if (initializationException != null && proxy == null) {
                    if (isStaticInit) {
                        throw new IllegalStateException("Static initializer called twice!");
                    }
                    throw new FilterInitializationException("Exception during initalization", initializationException);
                }
                try {
                    initialized = false;
                    initializationException = null;
                    isGlobalJreFilterConfigured = false;
                    jreFilterGlobal = null;
                    isWebLogicJreFilterConfigured = false;
                    jreFilterWebLogic = null;
                    jreFilterUnauthenticated = null;
                    LEGACY_BLACKLIST = null;
                    if (!globalScopeAllowed) {
                        return;
                    }
                    filterApiProxy = proxy != null ? proxy : new JreFilterApiProxy();
                    isJreFilteringAvailable = filterApiProxy.isAvailable();
                    if (isJreFilteringAvailable) {
                        jreFilterGlobal = filterApiProxy.getGlobalFilter();
                        isGlobalJreFilterConfigured = jreFilterGlobal != null;
                    }
                    filterConfig = new WebLogicFilterConfig(isJreFilteringAvailable, isGlobalJreFilterConfigured, propFileDir);
                    if (isJreFilteringAvailable) {
                        if (filterConfig.getWebLogicSerialFilterMode() == WebLogicFilterConfig.FilterMode.DISABLE) {
                            jreFilterWebLogic = null;
                            isWebLogicJreFilterConfigured = false;
                        } else {
                            String allowSerialFilter = filterConfig.getWebLogicAllowSerialFilter();
                            Object allowFilter = filterApiProxy.createFilterForString(allowSerialFilter);
                            String blockSerialFilter = filterConfig.getWebLogicBlockSerialFilter();
                            Object blockFilter = filterApiProxy.createFilterForString(blockSerialFilter);
                            WebLogicObjectInputFilterHelper.setWebLogicFilterWrapper(allowFilter, blockFilter);
                            WebLogicObjectInputFilterHelper.setWebLogicBlockListFilterWrapper(blockFilter);
                            if (filterConfig.getWebLogicSerialFilterScope() == WebLogicFilterConfig.FilterScope.WEBLOGIC || !globalScopeAllowed) {
                                jreFilterWebLogic = WebLogicObjectInputFilterHelper.getWebLogicFilterWrapper();
                                isWebLogicJreFilterConfigured = true;
                            } else {
                                String allowSerialGlobalFilter = filterConfig.getWebLogicAllowSerialGlobalFilter();
                                Object allowGlobalFilter = filterApiProxy.createFilterForString(allowSerialGlobalFilter);
                                String blockSerialGlobalFilter = filterConfig.getWebLogicBlockSerialGlobalFilter();
                                Object blockGlobalFilter = filterApiProxy.createFilterForString(blockSerialGlobalFilter);
                                WebLogicObjectInputFilterHelper.setGlobalFilterWrapper(allowGlobalFilter, blockGlobalFilter);
                                if (allowGlobalFilter != null || blockGlobalFilter != null) {
                                    filterApiProxy.setGlobalFilter(WebLogicObjectInputFilterHelper.getGlobalFilterWrapper());
                                    isGlobalJreFilterConfigured = true;
                                }
                                jreFilterGlobal = WebLogicObjectInputFilterHelper.getGlobalFilterWrapper();
                                jreFilterWebLogic = WebLogicObjectInputFilterHelper.getWebLogicFilterWrapper();
                                isWebLogicJreFilterConfigured = true;
                            }
                            unauthenticatedSerialFilter = filterConfig.getUnauthenticatedSerialFilter();
                            jreFilterUnauthenticated = filterApiProxy.createFilterForString(unauthenticatedSerialFilter);
                        }
                    } else {
                        LEGACY_BLACKLIST = filterConfig.getLegacyBlacklist();
                    }
                    initialized = true;
                }
                catch (Exception e) {
                    initialized = false;
                    if (proxy != null) break block15;
                    initializationException = e;
                }
            }
        }
    }

    public static void setRMIDeserializationMaxTimeLimit(long limit) {
        maxTimeLimit = limit;
    }

    public static void updateWeblogicFilterWrappers() {
        WebLogicObjectInputFilter.checkInitialized();
        if (permissionChecker != null) {
            permissionChecker.check();
        }
        String allowListSerialFilter = filterConfig.getWebLogicAllowSerialFilter();
        Object allowSerialFilter = filterApiProxy.createFilterForString(allowListSerialFilter);
        String blockListSerialFilter = filterConfig.getWebLogicBlockSerialFilter();
        Object blockSerialFilter = filterApiProxy.createFilterForString(blockListSerialFilter);
        if (WebLogicObjectInputFilterHelper.getWebLogicFilterWrapper() != null) {
            WebLogicObjectInputFilterHelper.updateWebLogicFilterWrapper(allowSerialFilter, blockSerialFilter);
        }
        if (WebLogicObjectInputFilterHelper.getWebLogicBlockListFilterWrapper() != null) {
            WebLogicObjectInputFilterHelper.updateWebLogicBlockListFilterWrapper(blockSerialFilter);
        }
    }

    public static void updateGlobalFilterWrappers() {
        WebLogicObjectInputFilter.checkInitialized();
        if (permissionChecker != null) {
            permissionChecker.check();
        }
        String allowListSerialGlobalFilter = filterConfig.getWebLogicAllowSerialGlobalFilter();
        Object allowGlobalFilter = filterApiProxy.createFilterForString(allowListSerialGlobalFilter);
        String blockListSerialGlobalFilter = filterConfig.getWebLogicBlockSerialGlobalFilter();
        Object blockGlobalFilter = filterApiProxy.createFilterForString(blockListSerialGlobalFilter);
        if (WebLogicObjectInputFilterHelper.getGlobalFilterWrapper() != null) {
            WebLogicObjectInputFilterHelper.updateGlobalFilterWrapper(allowGlobalFilter, blockGlobalFilter);
        }
    }

    public static void processSerialFilterFile(String file) throws Exception {
        if (permissionChecker != null) {
            permissionChecker.check();
        }
        filterConfig.processWebLogicSerialFilterProperties(file);
    }

    public static String getPropFileLocation() {
        return filterConfig.getPropFileLocation();
    }

    public static String getPropFileFileName() {
        return filterConfig.getPropFileName();
    }

    public static String getSerialFilterProperty() {
        return filterConfig.getSerialFilterProperty();
    }

    public static String getSerialGlobalFilterProperty() {
        return filterConfig.getSerialGlobalFilterProperty();
    }

    public static String getSerialUnauthenticatedFilterProperty() {
        return filterConfig.getSerialUnauthenticatedFilterProperty();
    }

    public static String getSerialFilter() {
        return filterConfig.getWebLogicSerialFilter();
    }

    public static String getAllowListSerialFilter() {
        return filterConfig.getWebLogicAllowSerialFilter();
    }

    public static String getBlocklistSerialFilter() {
        return filterConfig.getWebLogicBlockSerialFilter();
    }

    public static String getSerialGlobalFilter() {
        return filterConfig.getWebLogicSerialGlobalFilter();
    }

    public static String getAllowListSerialGlobalFilter() {
        return filterConfig.getWebLogicAllowSerialGlobalFilter();
    }

    public static String getPropUnauthenticatedSerialFilter() {
        return filterConfig.getPropUnauthenticatedSerialFilter();
    }

    public static long getSerialFilterPollingInterval() {
        return filterConfig.getWebLogicSerialFilterPollingInterval();
    }

    public static int getSerialRecordingSenderInterval() {
        return filterConfig.getWebLogicSerialRecordingSenderInterval();
    }

    public static int getSerialRecordingMaxArraySize() {
        return filterConfig.getWebLogicSerialRecordingMaxArraySize();
    }

    public static String getSerialFilterPropDirs() {
        return filterConfig.getWebLogicSerialFilterPropDirs();
    }

    private static void checkInitialized() {
        if (!initialized) {
            WebLogicObjectInputFilter.initializeInternal(false, null);
        }
    }

    private static void reInitialize() {
        WebLogicObjectInputFilter.initializeInternal(false, null);
    }

    public static void initialize(String propDir) throws FilterInitializationException {
        globalScopeAllowed = true;
        propFileDir = propDir != null ? propDir : System.getProperty("java.io.tmpdir");
        WebLogicObjectInputFilter.initializeInternal(false, null);
    }

    public static void initialize() throws FilterInitializationException {
        WebLogicObjectInputFilter.initialize(null);
    }

    public static void setFilterPermissionChecks(PermissionChecker pChecker) throws FilterInitializationException {
        if (isKernelPermissionSet) {
            throw new IllegalStateException("KernelPermission already set.");
        }
        permissionChecker = pChecker;
        isKernelPermissionSet = true;
    }

    public static void setWebLogicFilterForStream(final ObjectInputStream ois) {
        WebLogicObjectInputFilter.checkInitialized();
        if (isJreFilteringAvailable && isWebLogicJreFilterConfigured) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    long value = WebLogicObjectInputFilter.getMaxTimeLimitMillis();
                    if (value > 0L) {
                        filterApiProxy.setFilterForStream(ois, WebLogicObjectInputFilter.isAllowListEnabled() ? new WebLogicObjectInputFilterWrapperPerStream(WebLogicObjectInputFilterHelper.getWebLogicFilterWrapper(), value) : new WebLogicObjectInputFilterWrapperPerStream(WebLogicObjectInputFilterHelper.getWebLogicBlockListFilterWrapper(), value));
                    } else {
                        filterApiProxy.setFilterForStream(ois, WebLogicObjectInputFilter.isAllowListEnabled() ? WebLogicObjectInputFilterHelper.getWebLogicFilterWrapper() : WebLogicObjectInputFilterHelper.getWebLogicBlockListFilterWrapper());
                    }
                    return null;
                }
            });
        }
    }

    public static void resetMTLFilter(final ObjectInputStream ois) {
        WebLogicObjectInputFilter.checkInitialized();
        if (isJreFilteringAvailable && isWebLogicJreFilterConfigured) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Object obj = filterApiProxy.getFilterForStream(ois);
                    if (obj != null && obj instanceof WebLogicObjectInputFilterWrapperPerStream) {
                        WebLogicObjectInputFilterWrapperPerStream filter = (WebLogicObjectInputFilterWrapperPerStream)obj;
                        filter.replaceInnerFilter(WebLogicObjectInputFilter.getMaxTimeLimitMillis());
                    }
                    return null;
                }
            });
        }
    }

    public static void setWebLogicFilterForStreamWithOnlyBlock(ObjectInputStream ois) {
        WebLogicObjectInputFilter.checkInitialized();
        WebLogicObjectInputFilter.setWebLogicFilterForStreamWithOnlyBlockInternal(ois);
    }

    private static void setWebLogicFilterForStreamWithOnlyBlockInternal(final ObjectInputStream ois) {
        if (isJreFilteringAvailable && isWebLogicJreFilterConfigured) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    long value = WebLogicObjectInputFilter.getMaxTimeLimitMillis();
                    if (value > 0L) {
                        filterApiProxy.setFilterForStream(ois, new WebLogicObjectInputFilterWrapperPerStream(WebLogicObjectInputFilterHelper.getWebLogicBlockListFilterWrapper(), value));
                    } else {
                        filterApiProxy.setFilterForStream(ois, WebLogicObjectInputFilterHelper.getWebLogicBlockListFilterWrapper());
                    }
                    return null;
                }
            });
        }
    }

    public static void setUnauthenticatedFilterForStream(final ObjectInputStream ois) {
        WebLogicObjectInputFilter.checkInitialized();
        if (isJreFilteringAvailable && jreFilterUnauthenticated != null) {
            if (!unauthenticatedSerialFilter.equals(filterConfig.getUnauthenticatedSerialFilter())) {
                jreFilterUnauthenticated = filterApiProxy.createFilterForString(filterConfig.getUnauthenticatedSerialFilter());
            }
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    long value = WebLogicObjectInputFilter.getMaxTimeLimitMillis();
                    Object obj = filterApiProxy.getFilterForStream(ois);
                    if (obj != null && obj instanceof WebLogicObjectInputFilterWrapperPerStream) {
                        WebLogicObjectInputFilterWrapperPerStream filter = (WebLogicObjectInputFilterWrapperPerStream)obj;
                        filter.replaceInnerFilter(value, jreFilterUnauthenticated);
                    } else if (value > 0L) {
                        filterApiProxy.setFilterForStream(ois, new WebLogicObjectInputFilterWrapperPerStream(jreFilterUnauthenticated, value));
                    } else {
                        filterApiProxy.setFilterForStream(ois, jreFilterUnauthenticated);
                    }
                    return null;
                }
            });
        }
    }

    public static void clearObjectFilterForStream(final ObjectInputStream ois) {
        WebLogicObjectInputFilter.checkInitialized();
        if (isJreFilteringAvailable) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    filterApiProxy.setFilterForStream(ois, null);
                    return null;
                }
            });
        }
    }

    public static void checkLegacyBlacklistIfNeeded(String className) throws InvalidClassException {
        WebLogicObjectInputFilter.checkInitialized();
        if (isJreFilteringAvailable) {
            return;
        }
        if (WebLogicObjectInputFilter.isBlacklistedLegacy(className)) {
            throw new InvalidClassException(className, "Unauthorized deserialization attempt");
        }
    }

    public static boolean isClassAllowed(Class<?> clz) {
        WebLogicObjectInputFilter.checkInitialized();
        if (isJreFilteringAvailable) {
            Object filter = isWebLogicJreFilterConfigured ? (WebLogicObjectInputFilter.isAllowListEnabled() ? WebLogicObjectInputFilterHelper.getWebLogicFilterWrapper() : WebLogicObjectInputFilterHelper.getWebLogicBlockListFilterWrapper()) : jreFilterGlobal;
            return filterApiProxy.isClassAllowedByFilter(filter, clz);
        }
        return !WebLogicObjectInputFilter.isBlacklistedLegacy(clz.getName());
    }

    public static boolean isFilterAvailable() {
        WebLogicObjectInputFilter.checkInitialized();
        return isJreFilteringAvailable;
    }

    public static boolean isFilterLoggingEnabled() {
        WebLogicObjectInputFilter.checkInitialized();
        return filterConfig.isWebLogicSerialFilterLogEnabled();
    }

    public static boolean isAllowListLogViolationAction() {
        WebLogicObjectInputFilter.checkInitialized();
        return filterConfig.isWebLogicAllowListLogViolationAction();
    }

    public static boolean isAllowListViolationActionChanged() {
        WebLogicObjectInputFilter.checkInitialized();
        return filterConfig.isWebLogicAllowListViolationActionChanged();
    }

    public static void setAllowListViolationAction(String violation) {
        WebLogicObjectInputFilter.checkInitialized();
        try {
            filterConfig.setWebLogicAllowListViolationAction(violation);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getAllowListViolationAction() {
        WebLogicObjectInputFilter.checkInitialized();
        return filterConfig.getWebLogicAllowListViolationAction();
    }

    public static boolean isAllowListEnabled() {
        WebLogicObjectInputFilter.checkInitialized();
        return filterConfig.isWebLogicAllowListEnabled();
    }

    public static boolean isAllowListRecordingEnabled() {
        WebLogicObjectInputFilter.checkInitialized();
        return filterConfig.isWebLogicAllowListRecordingEnabled();
    }

    public static void setAllowListRecordingEnabled(boolean allow) {
        WebLogicObjectInputFilter.checkInitialized();
        try {
            filterConfig.setWebLogicAllowListRecordingEnabled(allow);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static WebLogicFilterConfig getWebLogicFilterConfig() {
        WebLogicObjectInputFilter.checkInitialized();
        return filterConfig;
    }

    public static void setMessageLogger(MessageLogger mLogger) throws FilterInitializationException {
        messageLogger = mLogger;
    }

    public static void setDeniedMessage(String message) {
        WebLogicObjectInputFilter.checkInitialized();
        if (messageLogger != null) {
            messageLogger.logDeniedMessage(message);
        }
    }

    public static void setFilterDeserializationTimeExceeded() {
        WebLogicObjectInputFilter.checkInitialized();
        if (messageLogger != null) {
            messageLogger.logFilterDeserializationTimeExceeded();
        }
    }

    public static void setSerialListRecordedClasses(List<String> classes) {
        WebLogicObjectInputFilter.checkInitialized();
        serialListRecordedClasses.addAll(classes);
    }

    public static List<String> getSerialListRecordedClasses() {
        WebLogicObjectInputFilter.checkInitialized();
        serialListRecordedClasses.addAll(WebLogicObjectInputFilterWrapperHelper.copySerialArrayToList());
        return new ArrayList<String>(serialListRecordedClasses);
    }

    public static void setGlobalListRecordedClasses(List<String> classes) {
        WebLogicObjectInputFilter.checkInitialized();
        globalListRecordedClasses.addAll(classes);
    }

    public static List<String> getGlobalListRecordedClasses() {
        WebLogicObjectInputFilter.checkInitialized();
        globalListRecordedClasses.addAll(WebLogicObjectInputFilterWrapperHelper.copyGlobalArrayToList());
        return new ArrayList<String>(globalListRecordedClasses);
    }

    public static void clearRecordedLists() {
        serialListRecordedClasses.clear();
        globalListRecordedClasses.clear();
    }

    public static String getFilterMode() {
        WebLogicObjectInputFilter.checkInitialized();
        return filterConfig.getWebLogicSerialFilterMode().toString();
    }

    public static Set<String> getWebLogicRaSerialFilterElements(RaElementType type, Scope scope) {
        String filter;
        WebLogicObjectInputFilter.checkInitialized();
        String string = filter = scope == Scope.WEBLOGIC ? filterConfig.getWebLogicSerialFilter() : filterConfig.getWebLogicSerialGlobalFilter();
        if (filter == null) {
            return new HashSet<String>();
        }
        HashSet<String> limits = new HashSet<String>();
        HashSet<String> positives = new HashSet<String>();
        HashSet<String> negatives = new HashSet<String>();
        String[] elements = filter.split(";");
        for (int i = 0; i < elements.length; ++i) {
            String element = elements[i];
            if (element.contains("=")) {
                limits.add(element);
                continue;
            }
            if (element.startsWith("!")) {
                negatives.add(element.substring(1));
                continue;
            }
            positives.add(element);
        }
        if (type.equals((Object)RaElementType.LIMITS)) {
            return limits;
        }
        if (type.equals((Object)RaElementType.NEGATIVE)) {
            return negatives;
        }
        if (type.equals((Object)RaElementType.POSITIVE)) {
            return positives;
        }
        return new HashSet<String>();
    }

    public static ArrayList<String> getFilterBlacklistClasses(Scope scope) {
        WebLogicObjectInputFilter.checkInitialized();
        return filterConfig.getWebLogicSerialFilterElements(WebLogicFilterConfig.ElementType.CLASS, scope == Scope.WEBLOGIC ? WebLogicFilterConfig.FilterScope.WEBLOGIC : WebLogicFilterConfig.FilterScope.GLOBAL);
    }

    public static ArrayList<String> getFilterBlacklistPackages(Scope scope) {
        WebLogicObjectInputFilter.checkInitialized();
        return filterConfig.getWebLogicSerialFilterElements(WebLogicFilterConfig.ElementType.PACKAGE, scope == Scope.WEBLOGIC ? WebLogicFilterConfig.FilterScope.WEBLOGIC : WebLogicFilterConfig.FilterScope.GLOBAL);
    }

    public static ArrayList<String> getFilterLimits(Scope scope) {
        WebLogicObjectInputFilter.checkInitialized();
        return filterConfig.getWebLogicSerialFilterElements(WebLogicFilterConfig.ElementType.LIMIT, scope == Scope.WEBLOGIC ? WebLogicFilterConfig.FilterScope.WEBLOGIC : WebLogicFilterConfig.FilterScope.GLOBAL);
    }

    public static ArrayList<String> getFilterAllowlists(Scope scope) {
        WebLogicObjectInputFilter.checkInitialized();
        return filterConfig.getWebLogicSerialFilterElements(WebLogicFilterConfig.ElementType.ALLOWLIST, scope == Scope.WEBLOGIC ? WebLogicFilterConfig.FilterScope.WEBLOGIC : WebLogicFilterConfig.FilterScope.GLOBAL);
    }

    public static String getFilterScope() {
        WebLogicObjectInputFilter.checkInitialized();
        return filterConfig.getWebLogicSerialFilterScope().toString();
    }

    public static boolean isGlobalFilterScope() {
        WebLogicObjectInputFilter.checkInitialized();
        return filterConfig.getWebLogicSerialFilterScope() == WebLogicFilterConfig.FilterScope.GLOBAL;
    }

    private static boolean isBlacklistedLegacy(String className) {
        String normalizedName = WebLogicObjectInputFilter.normalizeClassName(className);
        if (LEGACY_BLACKLIST == null || normalizedName == null) {
            return false;
        }
        if (LEGACY_BLACKLIST.contains(normalizedName)) {
            return true;
        }
        String pkgName = null;
        try {
            pkgName = normalizedName.substring(0, normalizedName.lastIndexOf(46));
        }
        catch (Exception ignored) {
            return false;
        }
        return pkgName != null && !pkgName.isEmpty() && LEGACY_BLACKLIST.contains(pkgName);
    }

    static String normalizeClassName(String className) {
        String newName;
        String string = newName = className == null ? null : className.trim();
        if (newName == null || newName.isEmpty()) {
            return null;
        }
        if (newName.startsWith("[") || primitiveTypes.contains(newName)) {
            return null;
        }
        return newName;
    }

    public static long getMaxTimeLimitMillis() {
        long time = Long.getLong(MAX_DESERIL_TIME_LIMIT_PROP, maxTimeLimit);
        return time;
    }

    public static enum ViolationAction {
        LOG,
        DENY,
        IGNORE;

    }

    public static enum RaElementType {
        LIMITS,
        POSITIVE,
        NEGATIVE;

    }

    public static enum Scope {
        GLOBAL,
        WEBLOGIC;

    }
}

