/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.io.oif;

import java.io.ObjectInputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import weblogic.utils.io.oif.ApiProxyException;

final class JreFilterApiProxy {
    private static final String PUBLIC_FILTER_PACKAGE = "java.io";
    private static final String HIDDEN_FILTER_PACKAGE = "sun.misc";
    private static final String CN_OBJECT_INPUT_FILTER = "ObjectInputFilter";
    private static final String PUBLIC_OIS_GET_FILTER_METHOD = "getObjectInputFilter";
    private static final String HIDDEN_OIS_GET_FILTER_METHOD = "getInternalObjectInputFilter";
    private static final String PUBLIC_OIS_SET_FILTER_METHOD = "setObjectInputFilter";
    private static final String HIDDEN_OIS_SET_FILTER_METHOD = "setInternalObjectInputFilter";
    private FilterSupportLevel filterSupportLevel = FilterSupportLevel.NONE;
    private String filterPackage = null;
    private boolean initialized = false;
    private Class<?> classFilter = null;
    private Method methodFilterCheckInput = null;
    private Class<?> classFilterConfig = null;
    private Method methodConfigCreateFilter = null;
    private Method methodConfigGetSerialFilter = null;
    private Method methodConfigSetSerialFilter = null;
    private Class<?> classFilterInfo = null;
    private Class<? extends Enum> classFilterStatus = null;
    private Class<?> classObjectInputStream = null;
    private Method methodInputStreamGetFilter = null;
    private Method methodInputStreamSetFilter = null;
    private Enum<? extends Enum> rejectedFilterStatus;

    JreFilterApiProxy() {
        this.determineJreFilterSupportLevel();
        if (this.filterSupportLevel != FilterSupportLevel.NONE) {
            try {
                this.classFilter = Class.forName(this.filterPackage + "." + CN_OBJECT_INPUT_FILTER);
                this.classFilterConfig = Class.forName(this.filterPackage + ".ObjectInputFilter$Config");
                this.classFilterInfo = Class.forName(this.filterPackage + ".ObjectInputFilter$FilterInfo");
                this.classFilterStatus = Class.forName(this.filterPackage + ".ObjectInputFilter$Status");
                this.methodFilterCheckInput = this.classFilter.getMethod("checkInput", this.classFilterInfo);
                this.methodConfigCreateFilter = this.classFilterConfig.getMethod("createFilter", String.class);
                this.methodConfigGetSerialFilter = this.classFilterConfig.getMethod("getSerialFilter", new Class[0]);
                this.methodConfigSetSerialFilter = this.classFilterConfig.getMethod("setSerialFilter", this.classFilter);
                this.classObjectInputStream = Class.forName("java.io.ObjectInputStream");
                if (this.filterSupportLevel == FilterSupportLevel.PUBLIC) {
                    this.methodInputStreamGetFilter = this.classObjectInputStream.getMethod(PUBLIC_OIS_GET_FILTER_METHOD, new Class[0]);
                    this.methodInputStreamSetFilter = this.classObjectInputStream.getMethod(PUBLIC_OIS_SET_FILTER_METHOD, this.classFilter);
                } else {
                    this.methodInputStreamGetFilter = this.classObjectInputStream.getDeclaredMethod(HIDDEN_OIS_GET_FILTER_METHOD, new Class[0]);
                    this.methodInputStreamGetFilter.setAccessible(true);
                    this.methodInputStreamSetFilter = this.classObjectInputStream.getDeclaredMethod(HIDDEN_OIS_SET_FILTER_METHOD, this.classFilter);
                    this.methodInputStreamSetFilter.setAccessible(true);
                }
                this.rejectedFilterStatus = Enum.valueOf(this.classFilterStatus, "REJECTED");
                this.initialized = true;
            }
            catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
                this.initialized = false;
                throw new ApiProxyException("Unable to initialize API proxy", e);
            }
        }
    }

    private void determineJreFilterSupportLevel() {
        if (this.isClassExists("java.io.ObjectInputFilter")) {
            this.filterSupportLevel = FilterSupportLevel.PUBLIC;
            this.filterPackage = PUBLIC_FILTER_PACKAGE;
        } else if (this.isClassExists("sun.misc.ObjectInputFilter")) {
            this.filterSupportLevel = FilterSupportLevel.HIDDEN;
            this.filterPackage = HIDDEN_FILTER_PACKAGE;
        }
    }

    private boolean isClassExists(String className) {
        Class<?> clz = null;
        try {
            clz = Class.forName(className);
        }
        catch (ClassNotFoundException cnfe) {
            clz = null;
        }
        return clz != null;
    }

    private void checkInitialized() {
        if (!this.initialized) {
            throw new ApiProxyException(this.filterSupportLevel == FilterSupportLevel.NONE ? "API not available!" : "API not initialized!");
        }
    }

    boolean isAvailable() {
        return this.initialized;
    }

    Object createFilterForString(String filter) {
        this.checkInitialized();
        try {
            return this.methodConfigCreateFilter.invoke(null, filter);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            Throwable cause;
            if (e instanceof InvocationTargetException && (cause = e.getCause()) instanceof IllegalArgumentException) {
                RuntimeException re = (RuntimeException)cause;
                throw re;
            }
            throw new ApiProxyException("Unexpected exception", e);
        }
    }

    Object getGlobalFilter() {
        this.checkInitialized();
        try {
            return this.methodConfigGetSerialFilter.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ApiProxyException("Unexpected exception", e);
        }
    }

    void setGlobalFilter(Object filter) {
        this.checkInitialized();
        try {
            this.methodConfigSetSerialFilter.invoke(null, filter);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            Throwable cause;
            if (e instanceof InvocationTargetException && ((cause = e.getCause()) instanceof IllegalStateException || cause instanceof SecurityException)) {
                RuntimeException re = (RuntimeException)cause;
                throw re;
            }
            throw new ApiProxyException("Unexpected exception", e);
        }
    }

    Object getFilterForStream(ObjectInputStream ois) {
        this.checkInitialized();
        try {
            return this.methodInputStreamGetFilter.invoke((Object)ois, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ApiProxyException("Unexpected exception", e);
        }
    }

    void setFilterForStream(ObjectInputStream ois, Object filter) {
        this.checkInitialized();
        try {
            this.methodInputStreamSetFilter.invoke((Object)ois, filter);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            Throwable cause;
            if (e instanceof InvocationTargetException && ((cause = e.getCause()) instanceof IllegalStateException || cause instanceof SecurityException)) {
                RuntimeException re = (RuntimeException)cause;
                throw re;
            }
            throw new ApiProxyException("Unexpected exception", e);
        }
    }

    boolean isClassAllowedByFilter(Object filter, Class clz) {
        this.checkInitialized();
        if (filter == null || clz == null) {
            return true;
        }
        Object filterInfoProxy = this.makeFilterInfoProxy(clz);
        try {
            Object status = this.methodFilterCheckInput.invoke(filter, filterInfoProxy);
            return status != null && !status.equals(this.rejectedFilterStatus);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ApiProxyException("Unexpected exception", e);
        }
    }

    private Object makeFilterInfoProxy(Class clz) {
        FilterInfoProxyHandler handler = new FilterInfoProxyHandler(clz);
        return Proxy.newProxyInstance(this.classFilterInfo.getClassLoader(), new Class[]{this.classFilterInfo}, (InvocationHandler)handler);
    }

    private static class FilterInfoProxyHandler
    implements InvocationHandler {
        private Class clz = null;

        private FilterInfoProxyHandler() {
        }

        private FilterInfoProxyHandler(Class clz) {
            this.clz = clz;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("serialClass")) {
                return this.clz;
            }
            if (method.getName().equals("arrayLength")) {
                return new Long(-1L);
            }
            if (method.getName().equals("depth")) {
                return new Long(1L);
            }
            if (method.getName().equals("references")) {
                return new Long(0L);
            }
            if (method.getName().equals("streamBytes")) {
                return new Long(0L);
            }
            return null;
        }
    }

    private static enum FilterSupportLevel {
        NONE,
        HIDDEN,
        PUBLIC;

    }
}

