/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.io;

import java.io.IOException;
import java.lang.reflect.Array;
import weblogic.utils.PropertyHelper;
import weblogic.utils.io.InvalidMessageSizeException;

public class ReadObjectUtils
implements AutoCloseable {
    static boolean skipGC = PropertyHelper.getBoolean("weblogic.utils.io.ReadObjectUtils.skipGC");
    private static ThreadLocal<Integer> threadLocalMaxMessageSize = new ThreadLocal(){

        protected Integer initialValue() {
            return 0;
        }
    };
    static ReadObjectUtils singleton = new ReadObjectUtils();
    static int serverMaxMessageSize = 10000000;

    public static void initialize(int maxMessageSize) {
        serverMaxMessageSize = maxMessageSize;
    }

    public static void ensureValidSize(int size) throws InvalidMessageSizeException {
        int maxMessageSize;
        int threadMaxMessageSize = threadLocalMaxMessageSize.get();
        int n = maxMessageSize = threadMaxMessageSize > 0 ? threadMaxMessageSize : serverMaxMessageSize;
        if (maxMessageSize > 0 && size > maxMessageSize) {
            throw new InvalidMessageSizeException(size);
        }
    }

    public static byte[] createByteArray(int size) throws InvalidMessageSizeException {
        ReadObjectUtils.ensureValidSize(size);
        return new byte[size];
    }

    public static <T> T[] createArray(Class<T> type, int size) throws InvalidMessageSizeException {
        ReadObjectUtils.ensureValidSize(size);
        return (Object[])Array.newInstance(type, size);
    }

    public static ReadObjectUtils withMaxMessageSize(int maxMessageSize) {
        threadLocalMaxMessageSize.set(maxMessageSize);
        return singleton;
    }

    @Override
    public void close() throws IOException {
        threadLocalMaxMessageSize.set(0);
    }

    public static IOException handleOutOfMemoryError(OutOfMemoryError oome) {
        if (!skipGC) {
            System.gc();
        }
        return new IOException("Encountered " + oome + " while reading an object");
    }
}

