/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.io;

import weblogic.kernel.KernelStatus;

public class ExceptionClassReplacer {
    private static final String CANDIDATE_PREFIX = "javax.";
    private static final String REPLACEMENT_PREFIX = "jakarta.";
    private static Boolean onServer = null;

    public static Class<?> getReplacementClassIfAvailable(ClassLoader classLoader, String className) {
        if (ExceptionClassReplacer.isOnServer() || !className.startsWith(CANDIDATE_PREFIX)) {
            return null;
        }
        String replacementClassName = className.replace(CANDIDATE_PREFIX, REPLACEMENT_PREFIX);
        try {
            Class<?> aClass = Class.forName(replacementClassName, false, classLoader);
            if (Throwable.class.isAssignableFrom(aClass)) {
                return aClass;
            }
            return null;
        }
        catch (ClassNotFoundException ignored) {
            return null;
        }
    }

    private static boolean isOnServer() {
        if (onServer == null) {
            onServer = KernelStatus.isServer();
        }
        return onServer;
    }
}

