/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.io;

import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import weblogic.utils.StringUtils;

public final class DataIO {
    private DataIO() {
    }

    public static void writeBoolean(OutputStream out, boolean v) throws IOException {
        out.write(v ? 1 : 0);
    }

    public static void writeByte(OutputStream out, int v) throws IOException {
        out.write(v);
    }

    public static void writeShort(OutputStream out, int v) throws IOException {
        out.write(v >>> 8 & 0xFF);
        out.write(v >>> 0 & 0xFF);
    }

    public static void writeChar(OutputStream out, int v) throws IOException {
        out.write(v >>> 8 & 0xFF);
        out.write(v >>> 0 & 0xFF);
    }

    public static void writeInt(OutputStream out, int v) throws IOException {
        out.write(v >>> 24 & 0xFF);
        out.write(v >>> 16 & 0xFF);
        out.write(v >>> 8 & 0xFF);
        out.write(v >>> 0 & 0xFF);
    }

    public static void writeLong(OutputStream out, long v) throws IOException {
        out.write((int)(v >>> 56) & 0xFF);
        out.write((int)(v >>> 48) & 0xFF);
        out.write((int)(v >>> 40) & 0xFF);
        out.write((int)(v >>> 32) & 0xFF);
        out.write((int)(v >>> 24) & 0xFF);
        out.write((int)(v >>> 16) & 0xFF);
        out.write((int)(v >>> 8) & 0xFF);
        out.write((int)(v >>> 0) & 0xFF);
    }

    public static void writeFloat(OutputStream out, float v) throws IOException {
        DataIO.writeInt(out, Float.floatToIntBits(v));
    }

    public static void writeDouble(OutputStream out, double v) throws IOException {
        DataIO.writeLong(out, Double.doubleToLongBits(v));
    }

    public static void writeBytes(OutputStream out, String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            out.write((byte)s.charAt(i));
        }
    }

    public static void writeChars(OutputStream out, String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char v = s.charAt(i);
            out.write(v >>> 8 & 0xFF);
            out.write(v >>> 0 & 0xFF);
        }
    }

    public static void writeUTF(OutputStream out, String str) throws IOException {
        int utflen = StringUtils.getUTFLength(str);
        if (utflen > 65535) {
            throw new UTFDataFormatException();
        }
        out.write(utflen >>> 8 & 0xFF);
        out.write(utflen >>> 0 & 0xFF);
        if (utflen == str.length()) {
            DataIO.writeBytes(out, str);
        } else {
            for (int i = 0; i < str.length(); ++i) {
                DataIO.writeUTF(out, str.charAt(i));
            }
        }
    }

    public static int writeUTF(OutputStream out, int c) throws IOException {
        if (c >= 1 && c <= 127) {
            out.write((byte)c);
            return 1;
        }
        if (c > 2047) {
            out.write((byte)(0xE0 | c >> 12 & 0xF));
            out.write((byte)(0x80 | c >> 6 & 0x3F));
            out.write((byte)(0x80 | c >> 0 & 0x3F));
            return 3;
        }
        out.write((byte)(0xC0 | c >> 6 & 0x1F));
        out.write((byte)(0x80 | c >> 0 & 0x3F));
        return 2;
    }

    public static int writeUTFChar(DataOutput out, int c) throws IOException {
        if (c >= 1 && c <= 127) {
            out.write((byte)c);
            return 1;
        }
        if (c > 2047) {
            out.write((byte)(0xE0 | c >> 12 & 0xF));
            out.write((byte)(0x80 | c >> 6 & 0x3F));
            out.write((byte)(0x80 | c >> 0 & 0x3F));
            return 3;
        }
        out.write((byte)(0xC0 | c >> 6 & 0x1F));
        out.write((byte)(0x80 | c >> 0 & 0x3F));
        return 2;
    }

    public static void writeUTF8(OutputStream out, String s) throws IOException {
        char c;
        int i;
        int utflen = 0;
        for (i = 0; i < s.length(); ++i) {
            c = s.charAt(i);
            if ((c & 0xFF80) == 0) {
                ++utflen;
                continue;
            }
            if ((c & 0xF800) == 0) {
                utflen += 2;
                continue;
            }
            utflen += 3;
        }
        DataIO.writeInt(out, utflen);
        if (utflen == s.length()) {
            DataIO.writeBytes(out, s);
        } else {
            for (i = 0; i < s.length(); ++i) {
                c = s.charAt(i);
                if ((c & 0xFF80) == 0) {
                    out.write((byte)c);
                    continue;
                }
                if ((c & 0xF800) == 0) {
                    out.write((byte)(0xC0 | c >> 6 & 0x1F));
                    out.write((byte)(0x80 | c >> 0 & 0x3F));
                    continue;
                }
                out.write((byte)(0xE0 | c >> 12 & 0xF));
                out.write((byte)(0x80 | c >> 6 & 0x3F));
                out.write((byte)(0x80 | c >> 0 & 0x3F));
            }
        }
    }

    public static void writeASCII(OutputStream out, String s) throws IOException {
        int len = s.length();
        DataIO.writeLength(out, len);
        for (int i = 0; i < len; ++i) {
            out.write((byte)s.charAt(i));
        }
    }

    public static void writeLength(OutputStream out, int i) throws IOException {
        if (i >= 0) {
            if (i < 254) {
                out.write(i);
                return;
            }
            if (i <= 65535) {
                out.write(254);
                out.write(i >> 8);
                out.write(i & 0xFF);
                return;
            }
        }
        out.write(255);
        DataIO.writeInt(out, i);
    }

    public static void readFully(InputStream in, byte[] b) throws IOException {
        DataIO.readFully(in, b, 0, b.length);
    }

    public static void readFully(InputStream in, byte[] b, int off, int len) throws IOException {
        int count;
        for (int n = 0; n < len; n += count) {
            count = in.read(b, off + n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }

    public static int skipBytes(InputStream in, int n) throws IOException {
        for (int i = 0; i < n; i += (int)in.skip(n - i)) {
        }
        return n;
    }

    public static boolean readBoolean(InputStream in) throws IOException {
        int ch = in.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch != 0;
    }

    public static byte readByte(InputStream in) throws IOException {
        int ch = in.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return (byte)ch;
    }

    public static int readUnsignedByte(InputStream in) throws IOException {
        int ch = in.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch;
    }

    public static short readShort(InputStream in) throws IOException {
        int ch2;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read())) < 0) {
            throw new EOFException();
        }
        return (short)((ch1 << 8) + (ch2 << 0));
    }

    public static int readUnsignedShort(InputStream in) throws IOException {
        int ch2;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 8) + (ch2 << 0);
    }

    public static char readChar(InputStream in) throws IOException {
        int ch2;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read())) < 0) {
            throw new EOFException();
        }
        return (char)((ch1 << 8) + (ch2 << 0));
    }

    public static int readInt(InputStream in) throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read()) | (ch3 = in.read()) | (ch4 = in.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public static long readLong(InputStream in) throws IOException {
        return ((long)DataIO.readInt(in) << 32) + ((long)DataIO.readInt(in) & 0xFFFFFFFFL);
    }

    public static float readFloat(InputStream in) throws IOException {
        return Float.intBitsToFloat(DataIO.readInt(in));
    }

    public static double readDouble(InputStream in) throws IOException {
        return Double.longBitsToDouble(DataIO.readLong(in));
    }

    @Deprecated
    public static final String readLine(InputStream in) throws IOException {
        char[] buf = new char[128];
        int offset = 0;
        int c = in.read();
        while (true) {
            if (c == -1) {
                if (offset != 0) break;
                return null;
            }
            if (c == 10) {
                if (offset <= 0 || buf[offset - 1] != '\r') break;
                --offset;
                break;
            }
            if (offset == buf.length) {
                char[] old = buf;
                buf = new char[offset + 128];
                System.arraycopy(old, 0, buf, 0, offset);
            }
            buf[offset++] = (char)c;
            c = in.read();
        }
        return String.copyValueOf(buf, 0, offset);
    }

    public static String readUTF(InputStream in) throws IOException {
        int utflen = DataIO.readUnsignedShort(in);
        char[] str = new char[utflen];
        int count = 0;
        int strlen = 0;
        block5: while (count < utflen) {
            int c = DataIO.readUnsignedByte(in);
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    str[strlen++] = (char)c;
                    continue block5;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    int char2 = DataIO.readUnsignedByte(in);
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str[strlen++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    continue block5;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    int char2 = DataIO.readUnsignedByte(in);
                    int char3 = DataIO.readUnsignedByte(in);
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str[strlen++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    continue block5;
                }
            }
            throw new UTFDataFormatException();
        }
        return new String(str, 0, strlen);
    }

    public static final String readUTF8(InputStream is) throws IOException {
        int len = DataIO.readInt(is);
        char[] buf = new char[len];
        int off = 0;
        int cpos = 0;
        while (off < len) {
            int c2;
            int c = DataIO.readUnsignedByte(is) & 0xFF;
            if ((c & 0x80) == 0) {
                ++off;
            } else if ((c & 0xE0) == 192) {
                c2 = DataIO.readUnsignedByte(is) & 0xFF;
                c = ((c & 0x1F) << 6) + (c2 & 0x3F);
                off += 2;
            } else {
                c2 = DataIO.readUnsignedByte(is) & 0xFF;
                int c3 = DataIO.readUnsignedByte(is) & 0xFF;
                c = ((c & 0xF) << 12) + ((c2 & 0x3F) << 6) + (c3 & 0x3F);
                off += 3;
            }
            buf[cpos++] = (char)c;
        }
        return StringUtils.getString(buf, 0, cpos);
    }

    public static final String readUTF8(byte[] inBuf) {
        char[] buf = new char[inBuf.length];
        int off = 0;
        int cpos = 0;
        while (off < inBuf.length) {
            int c;
            if (((c = inBuf[off++] & 0xFF) & 0x80) != 0) {
                int c2;
                if ((c & 0xE0) == 192) {
                    c2 = inBuf[off++] & 0xFF;
                    c = ((c & 0x1F) << 6) + (c2 & 0x3F);
                } else {
                    c2 = inBuf[off++] & 0xFF;
                    int c3 = inBuf[off++] & 0xFF;
                    c = ((c & 0xF) << 12) + ((c2 & 0x3F) << 6) + (c3 & 0x3F);
                }
            }
            buf[cpos++] = (char)c;
        }
        return StringUtils.getString(buf, 0, cpos);
    }

    public static String readASCII(InputStream in) throws IOException {
        int len = DataIO.readLength(in);
        char[] chars = new char[len];
        for (int i = 0; i < len; ++i) {
            chars[i] = (char)DataIO.readUnsignedByte(in);
        }
        return new String(chars);
    }

    public static int readLength(InputStream in) throws IOException {
        int res = DataIO.readUnsignedByte(in);
        if (res < 254) {
            return res;
        }
        if (res == 255) {
            return DataIO.readInt(in);
        }
        res = DataIO.readUnsignedByte(in) << 8;
        return res + DataIO.readUnsignedByte(in);
    }
}

