/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.io;

import java.io.IOException;
import java.io.OutputStream;
import weblogic.utils.Debug;
import weblogic.utils.Hex;
import weblogic.utils.io.Chunk;

public class ChunkedOutputStream
extends OutputStream {
    private static final boolean ASSERT = false;
    protected static final boolean READONLY_CHECK = true;
    protected Chunk head;
    protected Chunk current;
    protected int chunkPos;
    protected int streamPos;
    private boolean written = false;

    public ChunkedOutputStream() {
        this.init(Chunk.getChunk());
    }

    protected ChunkedOutputStream(Chunk head) {
        this.init(head);
    }

    protected final void init(Chunk c) {
        this.head = this.current = c;
        this.head.end = 0;
        this.chunkPos = 0;
        this.streamPos = 0;
        this.written = false;
    }

    @Override
    public final void write(int b) {
        this.checkWritable();
        if (this.chunkPos == Chunk.CHUNK_SIZE) {
            this.advance();
            this.checkWritable();
        }
        this.current.buf[this.chunkPos++] = (byte)b;
    }

    protected final void advance() {
        if (this.current.next == null) {
            this.current.next = Chunk.getChunk();
        }
        this.current.end = this.chunkPos;
        this.current = this.current.next;
        this.streamPos += this.chunkPos;
        this.chunkPos = 0;
    }

    @Override
    public final void write(byte[] b, int off, int len) {
        this.checkWritable();
        while (len > 0) {
            if (this.chunkPos == Chunk.CHUNK_SIZE) {
                this.advance();
                this.checkWritable();
            }
            int toCopy = Math.min(Chunk.CHUNK_SIZE - this.chunkPos, len);
            System.arraycopy(b, off, this.current.buf, this.chunkPos, toCopy);
            off += toCopy;
            len -= toCopy;
            this.chunkPos += toCopy;
        }
    }

    protected void checkWritable() {
        if (this.current.readOnlySharedBuf) {
            throw new AssertionError();
        }
    }

    public Chunk getChunks() {
        this.current.end = Math.max(this.current.end, this.chunkPos);
        this.streamPos = 0;
        this.chunkPos = 0;
        Chunk tmp = this.head;
        this.current = null;
        this.head = null;
        this.written = true;
        return tmp;
    }

    public Chunk getSharedBeforeCopyTail() {
        this.current.end = Math.max(this.current.end, this.chunkPos);
        Chunk tmp = this.head;
        while (tmp != null && tmp != this.current) {
            tmp = tmp.next;
        }
        if (tmp != this.current) {
            throw new AssertionError();
        }
        return this.head.getSharedBeforeTailCopy(this.current);
    }

    public String dumpBuf() {
        byte[] buf = this.getBuffer();
        return Hex.dump(buf, 0, buf.length);
    }

    public byte[] getBuffer() {
        byte[] b = new byte[this.getSize()];
        Chunk tmp = this.head;
        int off = 0;
        while (tmp != null) {
            System.arraycopy(tmp.buf, 0, b, off, tmp.end);
            off += tmp.end;
            tmp = tmp.next;
        }
        return b;
    }

    public final int getSize() {
        this.current.end = Math.max(this.current.end, this.chunkPos);
        return Chunk.size(this.head);
    }

    public final int getPosition() {
        return this.streamPos + this.chunkPos;
    }

    public int getChunkPos() {
        return this.chunkPos;
    }

    public Chunk getCurrentChunk() {
        return this.current;
    }

    protected final void check() {
        Debug.assertion(!this.written);
    }

    public final void setPosition(int position) {
        this.current.end = Math.max(this.current.end, this.chunkPos);
        this.current = this.head;
        this.streamPos = position;
        while (position > this.current.end) {
            if (this.current.next == null) {
                this.current.next = Chunk.getChunk();
                this.current.end = Math.min(Chunk.CHUNK_SIZE, position);
            }
            position -= this.current.end;
            this.current = this.current.next;
        }
        this.chunkPos = position;
        this.streamPos -= this.chunkPos;
    }

    public final void skip(int skip) {
        while (skip > 0) {
            if (this.chunkPos == Chunk.CHUNK_SIZE) {
                this.advance();
            }
            int toSkip = Math.min(Chunk.CHUNK_SIZE - this.chunkPos, skip);
            skip -= toSkip;
            this.chunkPos += toSkip;
        }
    }

    public void writeTo(OutputStream out) throws IOException {
        this.current.end = Math.max(this.current.end, this.chunkPos);
        while (this.head != null) {
            if (this.head.end > 0) {
                out.write(this.head.buf, 0, this.head.end);
            }
            Chunk tmp = this.head;
            this.head = this.head.next;
            Chunk.releaseChunk(tmp);
        }
        this.written = true;
    }

    public void reset() {
        if (this.head != null && this.head.next != null) {
            Chunk.releaseChunks(this.head.next);
            this.head.next = null;
        }
        if (this.head == null || this.head.readOnlySharedBuf) {
            this.head = Chunk.getChunk();
        }
        this.init(this.head);
    }

    public byte[] getBytesSince(Chunk chunk, int chunkByteOffset, int remaining) {
        byte[] data = new byte[remaining];
        int dataIndex = 0;
        while (remaining > 0) {
            int length = 0;
            if (chunk.end == 0) {
                length = remaining;
            } else {
                length = chunk.end - chunkByteOffset;
                if (remaining < length) {
                    length = remaining;
                }
            }
            System.arraycopy(chunk.buf, chunkByteOffset, data, dataIndex, length);
            remaining -= length;
            dataIndex += length;
            chunk = chunk.next;
            chunkByteOffset = 0;
        }
        return data;
    }

    public String toString() {
        return super.toString() + " - chunkPos: '" + this.chunkPos + "', currentChunk: '" + this.current + "'";
    }
}

