/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.io;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import weblogic.utils.io.Chunk;
import weblogic.utils.io.ChunkOutput;
import weblogic.utils.io.ChunkedDataOutputStream;
import weblogic.utils.io.DataIO;
import weblogic.utils.io.ObjectOutput;
import weblogic.utils.io.ObjectStreamClass;
import weblogic.utils.io.Replacer;
import weblogic.utils.io.StringOutput;

public class ChunkedObjectOutputStream
extends ChunkedDataOutputStream
implements ObjectOutput {
    private static final boolean DEBUG = false;
    private ObjectOutputStream objectStream = new NestedObjectOutputStream(this);
    private Replacer replacer = null;
    private boolean objectStreamNeedsReset = true;

    @Override
    public void reset() {
        super.reset();
        try {
            this.initNestedStream();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        this.objectStreamNeedsReset = true;
    }

    public final void setReplacer(Replacer replacer) {
        this.replacer = replacer;
    }

    protected final Object replaceObject(Object obj) throws IOException {
        return this.replacer == null ? obj : this.replacer.replaceObject(obj);
    }

    protected Object replaceNonSerializable(Object o) throws IOException {
        return o;
    }

    protected final void annotateClass(Class c) {
    }

    protected void annotateProxyClass(Class c) throws IOException {
    }

    protected void writeClassDescriptor(java.io.ObjectStreamClass descriptor) throws IOException {
        this.writeUTF(descriptor.getName());
        this.writeLong(descriptor.getSerialVersionUID());
        this.writeUTF("");
    }

    @Override
    public void writeObject(Object o, Class c) throws IOException {
        this.writeObject(o);
    }

    @Override
    public void writeObject(Object o) throws IOException {
        this.getOutputStream().writeObject(o);
    }

    public ObjectOutputStream getOutputStream() {
        return this.objectStream;
    }

    public void writeObjectToPreDiabloPeer(Object o) throws IOException {
        if (!this.objectStreamNeedsReset) {
            this.getOutputStream().flush();
        }
        if (o instanceof Externalizable) {
            Externalizable e = (Externalizable)o;
            Class<?> clazz = e.getClass();
            ObjectStreamClass osc = ObjectStreamClass.lookup(clazz);
            while (osc.hasWriteReplace() && (o = osc.writeReplace(o)) != null && o.getClass() != clazz) {
                clazz = o.getClass();
                osc = ObjectStreamClass.lookup(clazz);
            }
            this.writeByte(4);
            this.writeClassDescriptor(osc.getObjectStreamClass());
            int startEnvelope = this.getPosition();
            this.writeInt(-1);
            e.writeExternal(this);
            int endEnvelope = this.getPosition();
            this.setPosition(startEnvelope);
            this.writeInt(endEnvelope - (startEnvelope + 4));
            this.setPosition(endEnvelope);
        } else {
            this.writeByte(2);
            if (!(o instanceof Serializable)) {
                o = this.replaceNonSerializable(o);
            }
            if (this.objectStreamNeedsReset) {
                this.getOutputStream().reset();
                this.objectStreamNeedsReset = false;
            }
            this.getOutputStream().writeObject(o);
        }
    }

    protected void initNestedStream() throws IOException {
        this.objectStream = new NestedObjectOutputStream(this);
    }

    protected class NestedObjectOutputStream
    extends ObjectOutputStream
    implements ChunkOutput,
    StringOutput {
        protected NestedObjectOutputStream(OutputStream out) throws IOException {
            super(out);
            try {
                this.enableReplaceObject(true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }

        protected final void annotateClass(Class c) throws IOException {
            ChunkedObjectOutputStream.this.annotateClass(c);
        }

        protected final void annotateProxyClass(Class c) throws IOException {
            ChunkedObjectOutputStream.this.annotateProxyClass(c);
        }

        @Override
        protected Object replaceObject(Object obj) throws IOException {
            return ChunkedObjectOutputStream.this.replaceObject(obj);
        }

        @Override
        protected final void writeClassDescriptor(java.io.ObjectStreamClass descriptor) throws IOException {
            this.drain();
            ChunkedObjectOutputStream.this.writeClassDescriptor(descriptor);
        }

        @Override
        protected final void writeStreamHeader() throws IOException {
        }

        @Override
        public final void writeChunks(Chunk cos) throws IOException {
            this.drain();
            ChunkedObjectOutputStream.this.writeChunks(cos);
        }

        @Override
        public final void writeASCII(String str) throws IOException {
            DataIO.writeASCII(this, str);
        }

        @Override
        public final void writeUTF8(String str) throws IOException {
            DataIO.writeUTF8(this, str);
        }
    }
}

