/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.io;

import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import weblogic.utils.Debug;
import weblogic.utils.collections.Stack;
import weblogic.utils.io.Chunk;
import weblogic.utils.io.ChunkInputStreamAccess;
import weblogic.utils.io.ChunkedDataInputStream;
import weblogic.utils.io.DataIO;
import weblogic.utils.io.FilteringObjectInputStream;
import weblogic.utils.io.ObjectInput;
import weblogic.utils.io.ObjectStreamClass;
import weblogic.utils.io.ReadObjectUtils;
import weblogic.utils.io.Replacer;
import weblogic.utils.io.StringInput;
import weblogic.utils.io.oif.WebLogicObjectInputFilter;

public class ChunkedObjectInputStream
extends ChunkedDataInputStream
implements ObjectInput {
    private static final boolean DEBUG = false;
    protected Class lastClass;
    private NestedObjectInputStream objectStream;
    private int curEndEnvelope = -1;
    private final Stack externalizableInfos = new Stack();
    private String curExternalizableName;
    private Replacer replacer;
    private boolean validatingClass;

    public ChunkedObjectInputStream(Chunk c, int skip) throws IOException {
        super(c, skip);
        this.initNestedStream();
    }

    protected ChunkedObjectInputStream() throws IOException {
        this.objectStream = new NestedObjectInputStream(this);
    }

    protected ChunkedObjectInputStream(boolean setFilter) throws IOException {
        this.objectStream = new NestedObjectInputStream(this, setFilter);
    }

    protected ChunkedObjectInputStream(boolean setFilter, boolean isUnTrusted) throws IOException {
        this.objectStream = new NestedObjectInputStream(this, setFilter, isUnTrusted);
    }

    protected void initNestedStream() throws IOException {
        this.objectStream = new NestedObjectInputStream(this);
    }

    protected Class resolveClass(java.io.ObjectStreamClass c) throws IOException, ClassNotFoundException {
        WebLogicObjectInputFilter.checkLegacyBlacklistIfNeeded(c.getName());
        return this.lastClass;
    }

    public final void setReplacer(Replacer r) {
        this.replacer = r;
    }

    public final void setValidatingClass(boolean validate) {
        this.validatingClass = validate;
    }

    protected final Object resolveObject(Object obj) throws IOException {
        return this.replacer == null ? obj : this.replacer.resolveObject(obj);
    }

    protected java.io.ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        String classname = this.readUTF();
        long UID = this.readLong();
        String annotation = this.readUTF();
        Class c = this.loadClass(classname, annotation);
        if (!Serializable.class.isAssignableFrom(c)) {
            java.io.ObjectStreamClass result = java.io.ObjectStreamClass.lookupAny(c);
            if (result == null) {
                throw new ClassNotFoundException("Could not lookup ObjectStreamClass for class: " + c);
            }
            this.lastClass = result.forClass();
            return result;
        }
        ObjectStreamClass descriptor = ObjectStreamClass.lookup(c);
        if (descriptor.getSerialVersionUID() != UID) {
            throw new InvalidClassException(classname, "Expected uid: '" + UID + ", found uid: '" + descriptor.getSerialVersionUID() + "'");
        }
        this.lastClass = descriptor.forClass();
        return descriptor.getObjectStreamClass();
    }

    protected Class loadClass(String classname, String annotation) throws ClassNotFoundException {
        return Class.forName(classname, false, Thread.currentThread().getContextClassLoader());
    }

    private void pushExternalizableInfo(int endEnvelope, String name) {
        if (this.curEndEnvelope != -1) {
            this.externalizableInfos.push(new ExternalizableInfo(this.curEndEnvelope, this.curExternalizableName));
        }
        this.curEndEnvelope = endEnvelope;
        this.curExternalizableName = name;
    }

    private void popExternalizableInfo() {
        if (this.externalizableInfos.isEmpty()) {
            this.curEndEnvelope = -1;
            this.curExternalizableName = null;
        } else {
            ExternalizableInfo info = (ExternalizableInfo)this.externalizableInfos.pop();
            this.curEndEnvelope = info.endEnvelope;
            this.curExternalizableName = info.name;
        }
    }

    @Override
    public final void init(Chunk data, int skip) {
        super.init(data, skip);
        this.lastClass = null;
    }

    @Override
    protected void ensureAvailable(int len) throws IOException {
        this.checkIfReadPastEnvelope(len);
    }

    private void checkIfReadPastEnvelope(int len) throws EOFException {
        if (this.curEndEnvelope > 0 && this.pos() + len > this.curEndEnvelope) {
            throw new EOFException("Externalizable (" + this.curExternalizableName + ") reads too much data.");
        }
    }

    @Override
    public final int available() {
        int avail = super.available();
        if (this.curEndEnvelope > 0 && this.pos() + avail > this.curEndEnvelope) {
            return this.curEndEnvelope - this.pos();
        }
        return avail;
    }

    @Override
    public final int read() throws IOException {
        if (this.curEndEnvelope > 0 && this.pos() == this.curEndEnvelope) {
            return -1;
        }
        return super.read();
    }

    @Override
    public final int read(byte[] buf, int off, int len) throws IOException {
        if (this.curEndEnvelope > 0 && this.pos() + len > this.curEndEnvelope) {
            if (len > 0 && this.pos() == this.curEndEnvelope) {
                return -1;
            }
            len = this.curEndEnvelope - this.pos();
        }
        return super.read(buf, off, len);
    }

    @Override
    public final long skip(long toSkip) throws IOException {
        this.checkIfReadPastEnvelope((int)toSkip);
        return super.skip(toSkip);
    }

    @Override
    public final byte readByte() throws IOException {
        this.checkIfReadPastEnvelope(1);
        return super.readByte();
    }

    @Override
    public final short readShort() throws IOException {
        this.checkIfReadPastEnvelope(2);
        return super.readShort();
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        this.checkIfReadPastEnvelope(2);
        return super.readUnsignedShort();
    }

    @Override
    public final char readChar() throws IOException {
        this.checkIfReadPastEnvelope(2);
        return super.readChar();
    }

    @Override
    public final int readInt() throws IOException {
        this.checkIfReadPastEnvelope(4);
        return super.readInt();
    }

    @Override
    public final int readLength() throws IOException {
        if (this.curEndEnvelope == -1 || this.curEndEnvelope >= this.pos() + 5) {
            return super.readLength();
        }
        return DataIO.readLength(this);
    }

    @Override
    public final Object readObject(Class c) throws IOException, ClassNotFoundException {
        if (this.validatingClass) {
            return this.readObjectValidated(c);
        }
        return this.readObject();
    }

    @Override
    public Object readObject() throws IOException, ClassNotFoundException {
        try {
            return this.getInputStream().readObject();
        }
        catch (OutOfMemoryError oome) {
            throw ReadObjectUtils.handleOutOfMemoryError(oome);
        }
    }

    public final Object readObjectValidated(Class returnType) throws IOException, ClassNotFoundException {
        return this.getInputStream().readObjectValidated(returnType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object readObjectFromPreDiabloPeer() throws IOException, ClassNotFoundException {
        block2: {
            byte b = this.readByte();
            if (b != 4) break block2;
            java.io.ObjectStreamClass desc = this.readClassDescriptor();
            Class cl = this.resolveClass(desc);
            ObjectStreamClass osc = ObjectStreamClass.lookup(cl);
            Externalizable e = (Externalizable)osc.newInstance();
            int envelopeLength = this.readInt();
            int startEnvelope = this.pos();
            this.pushExternalizableInfo(startEnvelope + envelopeLength, cl.getName());
            try {
                e.readExternal(this.getWrapperObjectInputStream());
            }
            catch (Throwable throwable) {
                int unread = this.curEndEnvelope - this.pos();
                this.popExternalizableInfo();
                Debug.assertion(unread >= 0);
                this.skip(unread);
                throw throwable;
            }
            int unread = this.curEndEnvelope - this.pos();
            this.popExternalizableInfo();
            Debug.assertion(unread >= 0);
            this.skip(unread);
            return this.resolveObject(osc.readResolve(e));
        }
        return this.getInputStream().readObject();
    }

    public NestedObjectInputStream getInputStream() {
        Debug.assertion(this.objectStream != null);
        return this.objectStream;
    }

    public ObjectInputStream getWrapperObjectInputStream() throws IOException {
        return new WrapperObjectInputStream(this);
    }

    class WrapperObjectInputStream
    extends ObjectInputStream {
        private ObjectInput delegate;

        WrapperObjectInputStream(ChunkedObjectInputStream in) throws IOException {
            if (ChunkedObjectInputStream.this.objectStream.getFilterType() == FilterType.UNAUTHENTICATED) {
                WebLogicObjectInputFilter.setUnauthenticatedFilterForStream(this);
            } else {
                WebLogicObjectInputFilter.setWebLogicFilterForStream(this);
            }
            this.delegate = in;
        }

        @Override
        protected Object readObjectOverride() throws IOException, ClassNotFoundException {
            return this.delegate.readObject();
        }

        @Override
        public int read() throws IOException {
            return this.delegate.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.delegate.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.delegate.read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.delegate.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.delegate.available();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }

        @Override
        public void readFully(byte[] b) throws IOException {
            this.delegate.readFully(b);
        }

        @Override
        public void readFully(byte[] b, int off, int len) throws IOException {
            this.delegate.readFully(b, off, len);
        }

        @Override
        public int skipBytes(int n) throws IOException {
            return this.delegate.skipBytes(n);
        }

        @Override
        public boolean readBoolean() throws IOException {
            return this.delegate.readBoolean();
        }

        @Override
        public byte readByte() throws IOException {
            return this.delegate.readByte();
        }

        @Override
        public int readUnsignedByte() throws IOException {
            return this.delegate.readUnsignedByte();
        }

        @Override
        public short readShort() throws IOException {
            return this.delegate.readShort();
        }

        @Override
        public int readUnsignedShort() throws IOException {
            return this.delegate.readUnsignedShort();
        }

        @Override
        public char readChar() throws IOException {
            return this.delegate.readChar();
        }

        @Override
        public int readInt() throws IOException {
            return this.delegate.readInt();
        }

        @Override
        public long readLong() throws IOException {
            return this.delegate.readLong();
        }

        @Override
        public float readFloat() throws IOException {
            return this.delegate.readFloat();
        }

        @Override
        public double readDouble() throws IOException {
            return this.delegate.readDouble();
        }

        @Override
        public String readLine() throws IOException {
            return this.delegate.readLine();
        }

        @Override
        public String readUTF() throws IOException {
            return this.delegate.readUTF();
        }
    }

    protected class NestedObjectInputStream
    extends FilteringObjectInputStream
    implements ChunkInputStreamAccess,
    StringInput,
    ObjectInput {
        private FilterType filterType;

        protected NestedObjectInputStream(InputStream in) throws IOException {
            this(in, true);
        }

        protected NestedObjectInputStream(InputStream in, boolean setFilter) throws IOException {
            super(in, setFilter);
            this.filterType = null;
            try {
                this.enableResolveObject(true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }

        protected NestedObjectInputStream(InputStream in, boolean setFilter, boolean isUnTrusted) throws IOException {
            super(in, setFilter, isUnTrusted);
            this.filterType = null;
            try {
                this.enableResolveObject(true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }

        protected final Class resolveClass(java.io.ObjectStreamClass c) throws IOException, ClassNotFoundException {
            return ChunkedObjectInputStream.this.resolveClass(c);
        }

        @Override
        protected final Object resolveObject(Object obj) throws IOException {
            return ChunkedObjectInputStream.this.resolveObject(obj);
        }

        @Override
        protected final java.io.ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
            return ChunkedObjectInputStream.this.readClassDescriptor();
        }

        @Override
        protected final void readStreamHeader() throws IOException {
        }

        @Override
        public final Chunk readChunks() throws IOException {
            return ChunkedObjectInputStream.this.readChunks();
        }

        @Override
        public final int readChunkLength() throws IOException {
            return ChunkedObjectInputStream.this.readInt();
        }

        @Override
        public final int readByteArray(byte[] buf, int off, int len) throws IOException {
            return ChunkedObjectInputStream.this.read(buf, off, len);
        }

        @Override
        public final String readASCII() throws IOException {
            return DataIO.readASCII(this);
        }

        @Override
        public final String readUTF8() throws IOException {
            return DataIO.readUTF8(this);
        }

        @Override
        public final Object readObject(Class c) throws IOException, ClassNotFoundException {
            return this.readObject();
        }

        public FilterType getFilterType() {
            return this.filterType;
        }

        public void setFilterType(FilterType ftype) {
            this.filterType = ftype;
        }
    }

    private static final class ExternalizableInfo {
        final int endEnvelope;
        final String name;

        ExternalizableInfo(int endEnvelope, String name) {
            this.endEnvelope = endEnvelope;
            this.name = name;
        }
    }

    public static enum FilterType {
        WLS,
        UNAUTHENTICATED;

    }
}

