/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.io;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import weblogic.utils.io.Chunk;
import weblogic.utils.io.ChunkOutput;
import weblogic.utils.io.ChunkedDataInputStream;
import weblogic.utils.io.ChunkedOutputStream;
import weblogic.utils.io.DataIO;
import weblogic.utils.io.StringOutput;

public class ChunkedDataOutputStream
extends ChunkedOutputStream
implements DataOutput,
StringOutput,
ChunkOutput {
    private static final int CHAR_BUF_SIZE = 256;
    private char[] cbuf;

    @Override
    public final void writeBoolean(boolean v) {
        this.write(v ? 1 : 0);
    }

    @Override
    public final void writeByte(int v) {
        this.write(v);
    }

    @Override
    public final void writeShort(int v) {
        int pos = this.chunkPos;
        if (pos <= Chunk.CHUNK_SIZE - 2) {
            this.checkWritable();
            byte[] buf = this.current.buf;
            buf[pos++] = (byte)(v >>> 8);
            buf[pos++] = (byte)(v >>> 0);
            this.chunkPos = pos;
            return;
        }
        try {
            DataIO.writeShort(this, v);
        }
        catch (IOException ioe) {
            throw new AssertionError((Object)ioe);
        }
    }

    @Override
    public final void writeChar(int v) {
        int pos = this.chunkPos;
        if (pos <= Chunk.CHUNK_SIZE - 2) {
            this.checkWritable();
            byte[] buf = this.current.buf;
            buf[pos++] = (byte)(v >>> 8);
            buf[pos++] = (byte)(v >>> 0);
            this.chunkPos = pos;
            return;
        }
        try {
            DataIO.writeChar(this, v);
        }
        catch (IOException ioe) {
            throw new AssertionError();
        }
    }

    @Override
    public final void writeInt(int v) {
        int pos = this.chunkPos;
        if (pos <= Chunk.CHUNK_SIZE - 4) {
            this.checkWritable();
            byte[] buf = this.current.buf;
            buf[pos++] = (byte)(v >>> 24);
            buf[pos++] = (byte)(v >>> 16);
            buf[pos++] = (byte)(v >>> 8);
            buf[pos++] = (byte)(v >>> 0);
            this.chunkPos = pos;
            return;
        }
        try {
            DataIO.writeInt(this, v);
        }
        catch (IOException ioe) {
            throw new AssertionError();
        }
    }

    @Override
    public final void writeLong(long v) {
        int pos = this.chunkPos;
        if (pos <= Chunk.CHUNK_SIZE - 8) {
            this.checkWritable();
            byte[] buf = this.current.buf;
            buf[pos++] = (byte)(v >>> 56);
            buf[pos++] = (byte)(v >>> 48);
            buf[pos++] = (byte)(v >>> 40);
            buf[pos++] = (byte)(v >>> 32);
            buf[pos++] = (byte)(v >>> 24);
            buf[pos++] = (byte)(v >>> 16);
            buf[pos++] = (byte)(v >>> 8);
            buf[pos++] = (byte)(v >>> 0);
            this.chunkPos = pos;
            return;
        }
        try {
            DataIO.writeLong(this, v);
        }
        catch (IOException ioe) {
            throw new AssertionError();
        }
    }

    @Override
    public final void writeFloat(float v) {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public final void writeDouble(double v) {
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    public final void writeBytes(String s) {
        int toGet;
        this.checkWritable();
        int len = s.length();
        for (int i = 0; i < len; i += toGet) {
            if (this.chunkPos == Chunk.CHUNK_SIZE) {
                this.advance();
                this.checkWritable();
            }
            toGet = Math.min(Chunk.CHUNK_SIZE - this.chunkPos, len - i);
            s.getBytes(i, i + toGet, this.current.buf, this.chunkPos);
            this.chunkPos += toGet;
        }
    }

    @Override
    public final void writeChars(String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char v = s.charAt(i);
            this.writeChar(v);
        }
    }

    @Override
    public final void writeUTF(String value) throws IOException {
        int cpos = this.chunkPos;
        Chunk cur = this.current;
        this.writeShort(0);
        int utflen = this.writeUTFChars(value);
        int tailPos = this.chunkPos;
        int tailStreamPos = this.streamPos;
        Chunk tail = this.current;
        this.current = cur;
        this.chunkPos = cpos;
        if (utflen > 65535) {
            this.current.end = this.chunkPos;
            throw new UTFDataFormatException("String too long: " + utflen);
        }
        this.writeShort(utflen);
        this.chunkPos = tailPos;
        this.streamPos = tailStreamPos;
        this.current = tail;
    }

    protected void getBytes(String str, int srcBegin, int srcEnd, byte[] dst, int dstBegin) {
        str.getBytes(srcBegin, srcEnd, dst, dstBegin);
    }

    private int writeUTFChars(String value) throws IOException {
        int size = value.length();
        if (size > 0) {
            this.createCharBuffer();
        }
        int utfLen = 0;
        int off = 0;
        while (off < size) {
            this.checkWritable();
            while (off < size && this.chunkPos < Chunk.CHUNK_SIZE - 3) {
                int i;
                int toCopy = Math.min(256, size - off);
                value.getChars(off, off + toCopy, this.cbuf, 0);
                int pos = this.chunkPos;
                for (i = 0; i < toCopy && pos < Chunk.CHUNK_SIZE - 3; ++i) {
                    char c = this.cbuf[i];
                    if (c >= '\u0001' && c <= '\u007f') {
                        this.current.buf[pos++] = (byte)c;
                        continue;
                    }
                    if (c > '\u07ff') {
                        this.current.buf[pos++] = (byte)(0xE0 | c >> 12 & 0xF);
                        this.current.buf[pos++] = (byte)(0x80 | c >> 6 & 0x3F);
                        this.current.buf[pos++] = (byte)(0x80 | c >> 0 & 0x3F);
                        continue;
                    }
                    this.current.buf[pos++] = (byte)(0xC0 | c >> 6 & 0x1F);
                    this.current.buf[pos++] = (byte)(0x80 | c >> 0 & 0x3F);
                }
                utfLen += pos - this.chunkPos;
                this.chunkPos = pos;
                off += i;
            }
            while (off < size && this.chunkPos >= Chunk.CHUNK_SIZE - 3) {
                utfLen += DataIO.writeUTF((OutputStream)this, value.charAt(off++));
            }
        }
        return utfLen;
    }

    private void createCharBuffer() {
        if (this.cbuf == null) {
            this.cbuf = new char[256];
        }
    }

    @Override
    public final void writeUTF8(String value) {
        if (ChunkedDataOutputStream.isASCII(value)) {
            this.writeInt(value.length());
            this.writeBytes(value);
        } else {
            this.writeUTF8String(value);
        }
    }

    private static boolean isASCII(String value) {
        for (int i = 0; i < value.length(); ++i) {
            if ((value.charAt(i) & 0xFF80) == 0) continue;
            return false;
        }
        return true;
    }

    private void writeUTF8String(String value) {
        int cpos = this.chunkPos;
        Chunk cur = this.current;
        this.writeInt(0);
        int utflen = this.writeUTF8Chars(value);
        int tailPos = this.chunkPos;
        int tailStreamPos = this.streamPos;
        Chunk tail = this.current;
        this.current = cur;
        this.chunkPos = cpos;
        this.writeInt(utflen);
        this.chunkPos = tailPos;
        this.streamPos = tailStreamPos;
        this.current = tail;
    }

    private int writeUTF8Chars(String value) {
        int size = value.length();
        if (size > 0) {
            this.createCharBuffer();
        }
        int utfLen = 0;
        int off = 0;
        while (off < size) {
            this.checkWritable();
            while (off < size && this.chunkPos < Chunk.CHUNK_SIZE - 3) {
                int i;
                int toCopy = Math.min(256, size - off);
                value.getChars(off, off + toCopy, this.cbuf, 0);
                int pos = this.chunkPos;
                for (i = 0; i < toCopy && pos < Chunk.CHUNK_SIZE - 3; ++i) {
                    char c = this.cbuf[i];
                    if ((c & 0xFF80) == 0) {
                        this.current.buf[pos++] = (byte)c;
                        continue;
                    }
                    if ((c & 0xF800) == 0) {
                        this.current.buf[pos++] = (byte)(0xC0 | c >> 6 & 0x1F);
                        this.current.buf[pos++] = (byte)(0x80 | c >> 0 & 0x3F);
                        continue;
                    }
                    this.current.buf[pos++] = (byte)(0xE0 | c >> 12 & 0xF);
                    this.current.buf[pos++] = (byte)(0x80 | c >> 6 & 0x3F);
                    this.current.buf[pos++] = (byte)(0x80 | c >> 0 & 0x3F);
                }
                utfLen += pos - this.chunkPos;
                this.chunkPos = pos;
                off += i;
            }
            while (off < size && this.chunkPos >= Chunk.CHUNK_SIZE - 3) {
                utfLen += this.writeUTF8(value.charAt(off++));
            }
        }
        return utfLen;
    }

    private int writeUTF8(int c) {
        if ((c & 0xFF80) == 0) {
            this.write((byte)c);
            return 1;
        }
        if ((c & 0xF800) == 0) {
            this.write((byte)(0xC0 | c >> 6 & 0x1F));
            this.write((byte)(0x80 | c >> 0 & 0x3F));
            return 2;
        }
        this.write((byte)(0xE0 | c >> 12 & 0xF));
        this.write((byte)(0x80 | c >> 6 & 0x3F));
        this.write((byte)(0x80 | c >> 0 & 0x3F));
        return 3;
    }

    public final void writeLength(int i) {
        int pos = this.chunkPos;
        if (pos <= Chunk.CHUNK_SIZE - 5) {
            this.checkWritable();
            byte[] buf = this.current.buf;
            if (i >= 0) {
                if (i < 254) {
                    buf[pos++] = (byte)i;
                    this.chunkPos = pos;
                    return;
                }
                if (i <= 65535) {
                    buf[pos++] = -2;
                    buf[pos++] = (byte)(i >> 8);
                    buf[pos++] = (byte)(i & 0xFF);
                    this.chunkPos = pos;
                    return;
                }
            }
            buf[pos++] = -1;
            buf[pos++] = (byte)(i >>> 24);
            buf[pos++] = (byte)(i >>> 16);
            buf[pos++] = (byte)(i >>> 8);
            buf[pos++] = (byte)(i >>> 0);
            this.chunkPos = pos;
            return;
        }
        try {
            DataIO.writeLength(this, i);
        }
        catch (IOException ioe) {
            throw new AssertionError((Object)ioe);
        }
    }

    @Override
    public final void writeASCII(String s) {
        this.writeLength(s.length());
        this.writeBytes(s);
    }

    @Override
    public final void writeChunks(Chunk cos) {
        this.current.end = Math.max(this.current.end, this.chunkPos);
        if (cos.buf.length != Chunk.CHUNK_SIZE && !cos.readOnlySharedBuf) {
            throw new AssertionError((Object)"custom sized chunk not read only");
        }
        Chunk newhead = cos;
        int len = 0;
        while (cos.next != null) {
            len += cos.end;
            cos = cos.next;
            if (cos.buf.length != Chunk.CHUNK_SIZE && !cos.readOnlySharedBuf) {
                throw new AssertionError((Object)"custom sized chunk not read only");
            }
        }
        if (cos.readOnlySharedBuf) {
            throw new AssertionError((Object)"last chunk not writable");
        }
        this.writeInt(len += cos.end);
        this.current.end = this.chunkPos;
        this.streamPos += this.chunkPos;
        this.current.next = newhead;
        this.chunkPos = cos.end;
        this.current = cos;
        this.streamPos = this.streamPos + len - this.chunkPos;
    }

    public final ChunkedDataInputStream makeChunkedDataInputStream() {
        return new ChunkedDataInputStream(this.getChunks(), 0);
    }
}

