/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.io;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import weblogic.utils.StringUtils;
import weblogic.utils.io.Chunk;
import weblogic.utils.io.ChunkInput;
import weblogic.utils.io.ChunkedInputStream;
import weblogic.utils.io.DataIO;
import weblogic.utils.io.StringInput;

public class ChunkedDataInputStream
extends ChunkedInputStream
implements DataInput,
StringInput,
ChunkInput {
    private boolean hasBackingInputStream = false;

    protected ChunkedDataInputStream() {
    }

    public ChunkedDataInputStream(Chunk head, int skip) {
        super(head, skip);
    }

    public ChunkedDataInputStream(Chunk head, int skip, InputStream is) throws IOException {
        super(head, skip, is);
        this.hasBackingInputStream = true;
    }

    @Override
    public final void readFully(byte[] b) throws IOException {
        DataIO.readFully(this, b);
    }

    @Override
    public final void readFully(byte[] b, int off, int len) throws IOException {
        DataIO.readFully(this, b, off, len);
    }

    @Override
    public final int skipBytes(int n) throws IOException {
        return DataIO.skipBytes(this, n);
    }

    @Override
    public final boolean readBoolean() throws IOException {
        return DataIO.readBoolean(this);
    }

    @Override
    public byte readByte() throws IOException {
        Chunk c = this.head;
        if (this.chunkPos + 1 <= c.end) {
            return c.buf[this.chunkPos++];
        }
        return DataIO.readByte(this);
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        return DataIO.readUnsignedByte(this);
    }

    @Override
    public short readShort() throws IOException {
        int pos = this.chunkPos;
        Chunk c = this.head;
        if (pos + 2 <= c.end) {
            byte[] buf = c.buf;
            int ch1 = buf[pos++] & 0xFF;
            int ch2 = buf[pos++] & 0xFF;
            this.chunkPos = pos;
            return (short)((ch1 << 8) + (ch2 << 0));
        }
        return DataIO.readShort(this);
    }

    @Override
    public int readUnsignedShort() throws IOException {
        int pos = this.chunkPos;
        Chunk c = this.head;
        if (pos + 2 <= c.end) {
            byte[] buf = c.buf;
            int ch1 = buf[pos++] & 0xFF;
            int ch2 = buf[pos++] & 0xFF;
            this.chunkPos = pos;
            return (ch1 << 8) + (ch2 << 0);
        }
        return DataIO.readUnsignedShort(this);
    }

    @Override
    public char readChar() throws IOException {
        int pos = this.chunkPos;
        Chunk c = this.head;
        if (pos + 2 <= c.end) {
            byte[] buf = c.buf;
            int ch1 = buf[pos++] & 0xFF;
            int ch2 = buf[pos++] & 0xFF;
            this.chunkPos = pos;
            return (char)((ch1 << 8) + (ch2 << 0));
        }
        return DataIO.readChar(this);
    }

    @Override
    public int readInt() throws IOException {
        int pos = this.chunkPos;
        Chunk c = this.head;
        if (pos + 4 <= c.end) {
            byte[] buf = c.buf;
            int ch1 = buf[pos++] & 0xFF;
            int ch2 = buf[pos++] & 0xFF;
            int ch3 = buf[pos++] & 0xFF;
            int ch4 = buf[pos++] & 0xFF;
            this.chunkPos = pos;
            return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
        }
        return DataIO.readInt(this);
    }

    @Override
    public final long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public int readLength() throws IOException {
        int pos = this.chunkPos;
        Chunk c = this.head;
        if (pos + 5 <= c.end) {
            int res;
            if ((res = c.buf[pos++] & 0xFF) < 254) {
                this.chunkPos = pos;
                return res;
            }
            if (res == 254) {
                byte[] buf = c.buf;
                int ch1 = buf[pos++] & 0xFF;
                int ch2 = buf[pos++] & 0xFF;
                this.chunkPos = pos;
                return (ch1 << 8) + ch2;
            }
            byte[] buf = c.buf;
            int ch1 = buf[pos++] & 0xFF;
            int ch2 = buf[pos++] & 0xFF;
            int ch3 = buf[pos++] & 0xFF;
            int ch4 = buf[pos++] & 0xFF;
            this.chunkPos = pos;
            return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
        }
        return DataIO.readLength(this);
    }

    @Override
    public final String readASCII() throws IOException {
        int len = this.readLength();
        this.ensureAvailable(len);
        byte[] b = new byte[len];
        this.read(b);
        return StringUtils.getString(b);
    }

    @Override
    public final String readLine() throws IOException {
        return DataIO.readLine(this);
    }

    @Override
    public final String readUTF() throws IOException {
        if (this.hasBackingInputStream) {
            return DataIO.readUTF(this);
        }
        int utflen = this.readUnsignedShort();
        char[] str = new char[utflen];
        int strlen = 0;
        int charlen = 0;
        int[] numCharsRead = new int[1];
        while (strlen < utflen) {
            int read = this.readUTFFromChunk(str, charlen, utflen - strlen, numCharsRead);
            strlen += read;
            charlen += numCharsRead[0];
        }
        return new String(str, 0, charlen);
    }

    private int readUTFFromChunk(char[] str, int strPos, int lengthToRead, int[] numCharsRead) throws IOException {
        int c;
        int endMarker;
        int availBytesInCurrentChunk = this.head.end - this.chunkPos;
        int count = 0;
        int numChars = 0;
        boolean lastChunk = false;
        if (availBytesInCurrentChunk < lengthToRead) {
            endMarker = availBytesInCurrentChunk;
        } else {
            endMarker = lengthToRead;
            lastChunk = true;
        }
        while (count < endMarker) {
            if ((c = this.head.buf[this.chunkPos++] & 0xFF) > 127) {
                --this.chunkPos;
                break;
            }
            ++count;
            str[strPos++] = (char)c;
            ++numChars;
        }
        block6: while (count < endMarker) {
            c = this.head.buf[this.chunkPos++] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    str[strPos++] = (char)c;
                    ++numChars;
                    continue block6;
                }
                case 12: 
                case 13: {
                    int char2;
                    int availBytes;
                    count += 2;
                    if (lastChunk) {
                        if (count > endMarker) {
                            throw new UTFDataFormatException("malformed input: partial character at end");
                        }
                    } else if (count > endMarker) {
                        if (!this.advanceChunk()) {
                            throw new UTFDataFormatException("malformed input: partial character at end");
                        }
                        availBytes = this.head.end - this.chunkPos;
                        if (availBytes < 1) {
                            throw new UTFDataFormatException("malformed input: partial character at end");
                        }
                    }
                    if (((char2 = this.head.buf[this.chunkPos++] & 0xFF) & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str[strPos++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    ++numChars;
                    continue block6;
                }
                case 14: {
                    int char3;
                    int char2;
                    int availBytes;
                    count += 3;
                    if (lastChunk) {
                        if (count > endMarker) {
                            throw new UTFDataFormatException("malformed input: partial character at end");
                        }
                        char2 = this.head.buf[this.chunkPos++] & 0xFF;
                        char3 = this.head.buf[this.chunkPos++] & 0xFF;
                    } else if (count > endMarker) {
                        if (count - endMarker == 1) {
                            char2 = this.head.buf[this.chunkPos++] & 0xFF;
                            if (!this.advanceChunk()) {
                                throw new UTFDataFormatException("malformed input: partial character at end");
                            }
                            availBytes = this.head.end - this.chunkPos;
                            if (availBytes < 1) {
                                throw new UTFDataFormatException("malformed input: partial character at end");
                            }
                            char3 = this.head.buf[this.chunkPos++] & 0xFF;
                        } else {
                            if (!this.advanceChunk()) {
                                throw new UTFDataFormatException("malformed input: partial character at end");
                            }
                            availBytes = this.head.end - this.chunkPos;
                            if (availBytes < 2) {
                                throw new UTFDataFormatException("malformed input: partial character at end");
                            }
                            char2 = this.head.buf[this.chunkPos++] & 0xFF;
                            char3 = this.head.buf[this.chunkPos++] & 0xFF;
                        }
                    } else {
                        char2 = this.head.buf[this.chunkPos++] & 0xFF;
                        char3 = this.head.buf[this.chunkPos++] & 0xFF;
                    }
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str[strPos++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    ++numChars;
                    continue block6;
                }
            }
            throw new UTFDataFormatException();
        }
        this.advanceChunk();
        numCharsRead[0] = numChars;
        return count;
    }

    private boolean advanceChunk() {
        if (this.chunkPos == this.head.end && this.head.next != null) {
            this.advanceList();
            return true;
        }
        return false;
    }

    public final int peekInt() throws IOException {
        return this.peekInt(0);
    }

    protected void ensureAvailable(int size) throws IOException {
    }

    @Override
    public final String readUTF8() throws IOException {
        int pos;
        int len = this.readInt();
        this.ensureAvailable(len);
        char[] buf = new char[len];
        int cpos = 0;
        for (int off = 0; off < len; off += pos - this.chunkPos) {
            while (this.head.end - this.chunkPos < 3 && off < len) {
                int streampos = this.pos();
                buf[cpos++] = this.readUTF8wchar();
                off += this.pos() - streampos;
            }
            int copyLen = Math.min(this.head.end - this.chunkPos - 2, len - off);
            pos = this.chunkPos;
            while (pos < this.chunkPos + copyLen) {
                int c;
                if (((c = this.head.buf[pos++] & 0xFF) & 0x80) != 0) {
                    int c2;
                    if ((c & 0xE0) == 192) {
                        c2 = this.head.buf[pos++] & 0xFF;
                        c = ((c & 0x1F) << 6) + (c2 & 0x3F);
                    } else {
                        c2 = this.head.buf[pos++] & 0xFF;
                        int c3 = this.head.buf[pos++] & 0xFF;
                        c = ((c & 0xF) << 12) + ((c2 & 0x3F) << 6) + (c3 & 0x3F);
                    }
                }
                buf[cpos++] = (char)c;
            }
            this.chunkPos = pos;
        }
        return StringUtils.getString(buf, 0, cpos);
    }

    private final char readUTF8wchar() throws IOException {
        int c = this.read() & 0xFF;
        if ((c & 0x80) != 0) {
            if ((c & 0xE0) == 192) {
                int c2 = this.read() & 0xFF;
                c = ((c & 0x1F) << 6) + (c2 & 0x3F);
            } else {
                int c2 = this.read() & 0xFF;
                int c3 = this.read() & 0xFF;
                c = ((c & 0xF) << 12) + ((c2 & 0x3F) << 6) + (c3 & 0x3F);
            }
        }
        return (char)c;
    }

    @Override
    public final Chunk readChunks() throws IOException {
        Chunk nextChunk;
        int len = this.readInt();
        if (len > this.head.end - this.chunkPos) {
            Chunk finalChunk;
            nextChunk = Chunk.split(this.head, this.chunkPos);
            this.head.next = finalChunk = Chunk.split(nextChunk, len);
        } else {
            nextChunk = Chunk.getChunk();
            System.arraycopy(this.head.buf, this.chunkPos, nextChunk.buf, 0, len);
            nextChunk.end += len;
            this.chunkPos += len;
        }
        return nextChunk;
    }

    public final int peekInt(int offset) throws IOException {
        int b1 = this.peek(offset);
        if (b1 < 0) {
            throw new EOFException();
        }
        int b2 = this.peek(offset + 1);
        if (b2 < 0) {
            throw new EOFException();
        }
        int b3 = this.peek(offset + 2);
        if (b3 < 0) {
            throw new EOFException();
        }
        int b4 = this.peek(offset + 3);
        if (b4 < 0) {
            throw new EOFException();
        }
        return (b1 << 24) + (b2 << 16) + (b3 << 8) + (b4 << 0);
    }

    public final short peekShort() throws IOException {
        return this.peekShort(0);
    }

    public final short peekShort(int offset) throws IOException {
        int b1 = this.peek(offset);
        if (b1 < 0) {
            throw new EOFException();
        }
        int b2 = this.peek(offset + 1);
        if (b2 < 0) {
            throw new EOFException();
        }
        return (short)((b1 << 8) + (b2 << 0));
    }

    public final int peekLength() throws IOException {
        return this.peekLength(0);
    }

    public final int peekLength(int offset) throws IOException {
        int res = this.peek();
        if (res < 0) {
            throw new EOFException();
        }
        if (res < 254) {
            return res;
        }
        if (res == 254) {
            return this.peekShort(offset + 1);
        }
        return this.peekInt(offset + 1);
    }
}

