/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.io;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import weblogic.utils.io.ByteBufferOutputStream;
import weblogic.utils.io.DataIO;
import weblogic.utils.io.StringOutput;

public class ByteBufferDataOutputStream
extends ByteBufferOutputStream
implements DataOutput,
StringOutput {
    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.write(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        if (this.currentBuffer.remaining() >= 2) {
            this.currentBuffer.putShort((short)v);
        } else {
            DataIO.writeShort(this, v);
        }
    }

    @Override
    public void writeChar(int v) throws IOException {
        if (this.currentBuffer.remaining() >= 2) {
            this.currentBuffer.putChar((char)v);
        } else {
            DataIO.writeChar(this, v);
        }
    }

    @Override
    public void writeInt(int v) throws IOException {
        if (this.currentBuffer.remaining() >= 4) {
            this.currentBuffer.putInt(v);
        } else {
            DataIO.writeInt(this, v);
        }
    }

    @Override
    public void writeLong(long v) throws IOException {
        if (this.currentBuffer.remaining() >= 8) {
            this.currentBuffer.putLong(v);
        } else {
            DataIO.writeLong(this, v);
        }
    }

    @Override
    public void writeFloat(float v) throws IOException {
        if (this.currentBuffer.remaining() >= 4) {
            this.currentBuffer.putFloat(v);
        } else {
            DataIO.writeFloat(this, v);
        }
    }

    @Override
    public void writeDouble(double v) throws IOException {
        if (this.currentBuffer.remaining() >= 8) {
            this.currentBuffer.putDouble(v);
        } else {
            DataIO.writeDouble(this, v);
        }
    }

    @Override
    public final void writeBytes(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.write((byte)s.charAt(i));
        }
    }

    @Override
    public final void writeChars(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char v = s.charAt(i);
            this.writeChar(v);
        }
    }

    @Override
    public void writeUTF(String str) throws IOException {
        DataIO.writeUTF((OutputStream)this, str);
    }

    @Override
    public void writeASCII(String s) throws IOException {
        DataIO.writeASCII(this, s);
    }

    @Override
    public void writeUTF8(String s) throws IOException {
        DataIO.writeUTF8(this, s);
    }
}

