/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.http;

import weblogic.utils.http.RequestParser;

public class HttpRequestParseException
extends Exception {
    private static final long serialVersionUID = 4000640802731315034L;
    private String method;
    private String uri;
    private String protocol;
    private int maxTotalHeadersSize = -1;
    private int maxSingleHeaderSize = -1;

    public HttpRequestParseException() {
    }

    public HttpRequestParseException(String msg) {
        super(msg);
    }

    public HttpRequestParseException(Throwable th) {
        super(th);
    }

    public HttpRequestParseException(String msg, Throwable th) {
        super(msg, th);
    }

    public HttpRequestParseException(String msg, Throwable th, RequestParser parser) {
        this(msg, th);
        this.init(parser);
    }

    public HttpRequestParseException(String msg, RequestParser parser) {
        this(msg);
        this.init(parser);
    }

    private void init(RequestParser parser) {
        this.method = parser.getMethod();
        this.uri = parser.getRequestURI();
        this.protocol = parser.getProtocol();
    }

    public static HttpRequestParseException maxHeaderSizeExceeded(int maxSingleHeaderSize, int maxTotalHeadersSize) {
        HttpRequestParseException exception = new HttpRequestParseException();
        exception.maxSingleHeaderSize = maxSingleHeaderSize;
        exception.maxTotalHeadersSize = maxTotalHeadersSize;
        return exception;
    }

    public String getMethod() {
        return this.method;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getURI() {
        return this.uri;
    }

    public int getMaxTotalHeadersSize() {
        return this.maxTotalHeadersSize;
    }

    public int getMaxSingleHeaderSize() {
        return this.maxSingleHeaderSize;
    }

    public boolean isHeaderSizeExceeded() {
        return this.maxSingleHeaderSize > -1 || this.maxTotalHeadersSize > -1;
    }
}

