/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.http;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.BitSet;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicReferenceArray;
import weblogic.utils.Hex;
import weblogic.utils.StringUtils;
import weblogic.utils.encoders.BASE64Decoder;
import weblogic.utils.http.BytesToString;
import weblogic.utils.http.QueryParams;

public final class HttpParsing {
    static BitSet dontNeedEncoding;
    static final boolean VERBOSE = false;
    private static final EncodedStringCache encodedStringCache;
    private static final String platformEncoding;

    private HttpParsing() {
    }

    public static String[] getAuthInfo(String authHdr) {
        int i;
        byte[] decode;
        if (authHdr == null) {
            return null;
        }
        String[] inf = StringUtils.split(authHdr, ' ');
        if (inf.length < 2 || !"Basic".equals(inf[0]) || inf[1] == null) {
            return null;
        }
        try {
            BASE64Decoder decoder = new BASE64Decoder();
            decode = decoder.decodeBuffer(inf[1]);
        }
        catch (IOException e) {
            return null;
        }
        for (i = 0; i < decode.length && decode[i] != 58; ++i) {
        }
        if (i >= decode.length - 1) {
            return null;
        }
        String[] ret = new String[]{new String(decode, 0, 0, i), new String(decode, 0, ++i, decode.length - i)};
        return ret;
    }

    public static void parseQueryString(String str, Map res) {
        HttpParsing.parseQueryString(str, res, null);
    }

    public static void parseQueryString(String str, Map res, String encoding) {
        int i = str.indexOf(35);
        if (i > 0) {
            str = str.substring(0, i);
        }
        StringTokenizer st = new StringTokenizer(str.replace('+', ' '), "&");
        while (st.hasMoreTokens()) {
            String qp = st.nextToken();
            String[] pair2 = StringUtils.split(qp, '=');
            res.put(HttpParsing.unescape(pair2[0], encoding), HttpParsing.unescape(pair2[1], encoding));
        }
    }

    public static void parseQueryString(byte[] qstr, int begin, int len, Map res, String encoding) {
        int limit = begin + len;
        boolean is8BitUnicodeSubset = BytesToString.is8BitUnicodeSubset(encoding);
        while (true) {
            String val;
            String key;
            int end;
            boolean firsteq = true;
            boolean needUnescapeKey = false;
            boolean needUnescapeValue = false;
            int eq = -1;
            for (end = begin; end < limit; ++end) {
                if (qstr[end] == 61 && firsteq) {
                    eq = end;
                    firsteq = false;
                }
                if (qstr[end] == 43 || qstr[end] == 37 && end + 2 < limit && Hex.isHexChar(qstr[end + 1]) && Hex.isHexChar(qstr[end + 2])) {
                    if (firsteq) {
                        needUnescapeKey = true;
                    } else {
                        needUnescapeValue = true;
                    }
                }
                if (qstr[end] == 38) break;
            }
            if (eq >= 0) {
                key = HttpParsing.unescape(qstr, begin, eq - begin, encoding, is8BitUnicodeSubset, needUnescapeKey, true);
                val = HttpParsing.unescape(qstr, ++eq, end - eq, encoding, is8BitUnicodeSubset, needUnescapeValue);
                res.put(key, val);
            } else if (end > begin) {
                key = HttpParsing.unescape(qstr, begin, end - begin, encoding, is8BitUnicodeSubset, needUnescapeKey, true);
                val = "";
                res.put(key, val);
            }
            if (++end >= limit) break;
            begin = end;
        }
    }

    public static void prependQueryString(String str, QueryParams qParams, String encoding) {
        StringTokenizer st = new StringTokenizer(str.replace('+', ' '), "&");
        int total = st.countTokens();
        int i = 0;
        String[] tokens = new String[total];
        while (st.hasMoreTokens()) {
            tokens[i] = st.nextToken();
            ++i;
        }
        int j = tokens.length;
        while (--j >= 0) {
            String[] pair2 = StringUtils.split(tokens[j], '=');
            qParams.prepend(HttpParsing.unescape(pair2[0], encoding), HttpParsing.unescape(pair2[1], encoding));
            tokens[j] = null;
        }
    }

    public static String makeURI(String uri, String[][] params) {
        return HttpParsing.makeURI(uri, params, null);
    }

    public static String makeURI(String uri, String[][] params, String encoding) {
        StringBuilder sb = new StringBuilder(uri);
        int len = params.length;
        if (uri.indexOf(63) < 0) {
            sb.append('?');
        } else if (len > 0) {
            sb.append('&');
        }
        for (int i = 0; i < len; ++i) {
            sb.append(HttpParsing.isURLEncoded(params[i][0]) ? params[i][0] : HttpParsing.escape(params[i][0], encoding));
            sb.append('=');
            sb.append(HttpParsing.isURLEncoded(params[i][1]) ? params[i][1] : HttpParsing.escape(params[i][1], encoding));
            if (i >= len - 1) continue;
            sb.append('&');
        }
        return sb.toString();
    }

    private static boolean isURLEncoded(String str) {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c == ' ') {
                return false;
            }
            if (dontNeedEncoding.get(c)) continue;
            if (c == '%' && i + 2 < len && Hex.isHexChar(str.charAt(i + 1)) && Hex.isHexChar(str.charAt(i + 2))) {
                i += 2;
                continue;
            }
            return false;
        }
        return true;
    }

    public static String escape(String str, String encoding) {
        if (encoding != null) {
            String s = null;
            try {
                s = URLEncoder.encode(str, encoding);
            }
            catch (UnsupportedEncodingException uee) {
                s = URLEncoder.encode(str);
            }
            return s;
        }
        return HttpParsing.escape(str);
    }

    public static String escape(String str) {
        int len = str.length();
        byte[] orig = new byte[len];
        str.getBytes(0, len, orig, 0);
        StringBuffer escaped = new StringBuffer(orig.length + 16);
        for (int i = 0; i < orig.length; ++i) {
            byte c = orig[i];
            if (HttpParsing.isUnsafe(c) || c == 32) {
                escaped.append("%" + Hex.asHex(c));
                continue;
            }
            escaped.append(str.charAt(i));
        }
        return escaped.toString();
    }

    public static String unescape(String str) {
        return HttpParsing.unescape(str, null);
    }

    public static String unescape(String str, String encoding) {
        if (str.indexOf(37) < 0) {
            return str;
        }
        if (encoding == null || encoding.length() == 0) {
            encoding = platformEncoding;
        }
        int out = 0;
        byte[] strbytes = str.getBytes();
        int len = strbytes.length;
        boolean foundNonAscii = false;
        int in = 0;
        while (in < len) {
            if (strbytes[in] == 37 && in + 2 < len && Hex.isHexChar(strbytes[in + 1]) && Hex.isHexChar(strbytes[in + 2])) {
                strbytes[out] = (byte)((Hex.hexValueOf(strbytes[in + 1]) << 4) + (Hex.hexValueOf(strbytes[in + 2]) << 0));
                in += 2;
            } else {
                if (!(foundNonAscii || strbytes[in] > 31 && strbytes[in] != 127)) {
                    encoding = System.getProperty("file.encoding");
                    foundNonAscii = true;
                }
                strbytes[out] = strbytes[in];
            }
            ++in;
            ++out;
        }
        return BytesToString.newString(strbytes, 0, out, encoding);
    }

    private static String unescape(byte[] b, int off, int len, String encoding, boolean is8BitUnicodeSubset, boolean needUnescape) {
        return HttpParsing.unescape(b, off, len, encoding, is8BitUnicodeSubset, needUnescape, false);
    }

    private static String unescape(byte[] b, int off, int len, String encoding, boolean is8BitUnicodeSubset, boolean needUnescape, boolean doCaching) {
        if (needUnescape) {
            int lim = off + len;
            byte[] result = new byte[len];
            int offset = 0;
            for (int i = off; i < lim; ++i) {
                if (b[i] == 37 && i + 2 < lim && Hex.isHexChar(b[i + 1]) && Hex.isHexChar(b[i + 2])) {
                    result[offset++] = (byte)((Hex.hexValueOf(b[i + 1]) << 4) + (Hex.hexValueOf(b[i + 2]) << 0));
                    i += 2;
                    continue;
                }
                result[offset++] = b[i] == 43 ? 32 : b[i];
            }
            b = result;
            off = 0;
            len = offset;
        }
        if (is8BitUnicodeSubset) {
            if (doCaching) {
                return encodedStringCache.getEncodedString(b, off, len);
            }
            return BytesToString.newAsciiString(b, off, len);
        }
        return BytesToString.newNonAsciiString(b, off, len, encoding);
    }

    public static final boolean isUnsafe(int c) {
        if (c >= 0 && c <= 31 || c >= 127 && c <= 255) {
            return true;
        }
        switch (c) {
            case 34: 
            case 35: 
            case 37: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 92: 
            case 94: 
            case 96: 
            case 123: 
            case 124: 
            case 125: 
            case 126: {
                return true;
            }
        }
        return false;
    }

    public static final String StripHTTPFieldValue(String orig) {
        int pos = orig.indexOf(40);
        if (pos > 0) {
            orig = orig.substring(0, pos).trim();
        }
        if (orig.length() > 2 && orig.charAt(0) == '\"' && orig.charAt(orig.length() - 1) == '\"') {
            orig = orig.substring(1, orig.length() - 1).trim();
        }
        return orig;
    }

    public static final String ensureStartingSlash(String s) {
        int len = s.length();
        if (len == 0) {
            return "/";
        }
        if (s.charAt(0) == '/') {
            return s;
        }
        return new StringBuffer(len + 1).append('/').append(s).toString();
    }

    public static final String ensureEndingSlash(String s) {
        int len = s.length();
        if (len == 0) {
            return "/";
        }
        if (s.charAt(len - 1) == '/') {
            return s;
        }
        return new StringBuffer(len + 1).append(s).append('/').toString();
    }

    public static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isWS(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n';
    }

    public static boolean isSpace(char c) {
        return c == '\t' || c == '\r' || c == '\n';
    }

    private static boolean isCTL(char c) {
        return c >= '\u0000' && c <= '\u001f' || c >= '\u007f';
    }

    private static boolean isTspecial(char c) {
        switch (c) {
            case '\t': 
            case ' ': 
            case '\"': 
            case '(': 
            case ')': 
            case ',': 
            case '/': 
            case ':': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '@': 
            case '[': 
            case '\\': 
            case ']': 
            case '{': 
            case '}': {
                return true;
            }
        }
        return false;
    }

    public static boolean isTokenClean(String s) {
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (!HttpParsing.isCTL(c) && !HttpParsing.isTspecial(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNetscapeSpecial(char c) {
        return c == ';';
    }

    public static boolean isQuoted(String s) {
        if (s == null || s.length() < 2) {
            return false;
        }
        return s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"';
    }

    static {
        int i;
        dontNeedEncoding = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            dontNeedEncoding.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            dontNeedEncoding.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            dontNeedEncoding.set(i);
        }
        dontNeedEncoding.set(32);
        dontNeedEncoding.set(45);
        dontNeedEncoding.set(95);
        dontNeedEncoding.set(46);
        dontNeedEncoding.set(42);
        dontNeedEncoding.set(91);
        dontNeedEncoding.set(93);
        Integer escMaxLen = Integer.getInteger("weblogic.http.EncodedStringCacheMaxLen", 64);
        Integer escEntryCount = Integer.getInteger("weblogic.http.EncodedStringCacheEntryCount", 64);
        encodedStringCache = new EncodedStringCache(escMaxLen, escEntryCount);
        platformEncoding = null;
        try {
            System.getProperty("file.encoding");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    static class EncodedStringCache {
        AtomicReferenceArray<EncodedStringEntry>[] cache;
        volatile int nextToEvict;
        int maxBufferLen;
        int entryCount;

        EncodedStringCache(int maxBufferLen, int entryCount) {
            this.maxBufferLen = maxBufferLen;
            this.entryCount = entryCount;
            this.cache = new AtomicReferenceArray[maxBufferLen];
            for (int i = 0; i < maxBufferLen; ++i) {
                this.cache[i] = new AtomicReferenceArray(entryCount);
            }
        }

        String getEncodedString(byte[] buf, int pos, int length) {
            if (length >= this.maxBufferLen) {
                return BytesToString.newAsciiString(buf, pos, length);
            }
            AtomicReferenceArray<EncodedStringEntry> currentCachePos = this.cache[length];
            for (int entryOffset = 0; entryOffset < this.entryCount; ++entryOffset) {
                int j;
                EncodedStringEntry currentEntry = currentCachePos.get(entryOffset);
                if (currentEntry == null) {
                    byte[] bytes = new byte[length];
                    System.arraycopy(buf, pos, bytes, 0, length);
                    String result = BytesToString.newAsciiString(buf, pos, length);
                    currentCachePos.set(entryOffset, new EncodedStringEntry(bytes, result));
                    return result;
                }
                byte[] currentEntryBytes = currentEntry.bytes;
                for (j = length - 1; j >= 0 && buf[pos + j] == currentEntryBytes[j]; --j) {
                }
                if (j != -1) continue;
                return currentEntry.result;
            }
            byte[] bytes = new byte[length];
            System.arraycopy(buf, pos, bytes, 0, length);
            String result = BytesToString.newAsciiString(buf, pos, length);
            int evictee = this.nextToEvict++;
            if (evictee >= this.entryCount) {
                evictee = 0;
                this.nextToEvict = 0;
            }
            currentCachePos.set(evictee, new EncodedStringEntry(bytes, result));
            return result;
        }

        class EncodedStringEntry {
            byte[] bytes;
            String result;

            public EncodedStringEntry(byte[] bytes, String result) {
                this.bytes = bytes;
                this.result = result;
            }
        }
    }
}

