/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.enumerations;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class SequencingEnumerator<E>
implements Enumeration<E> {
    private static final int SIZE_UNIT = 8;
    private Enumeration<E>[] enums;
    private int cur = 0;
    private int tail = 0;

    public SequencingEnumerator() {
        this.enums = new Enumeration[8];
    }

    public SequencingEnumerator(Enumeration<E>[] enums) {
        this.enums = enums;
        this.tail = enums.length;
    }

    public synchronized void addEnumeration(Enumeration<E> e) {
        if (e == null) {
            throw new IllegalArgumentException("Null Enumeration passed in");
        }
        if (this.tail == this.enums.length) {
            int len = this.enums.length;
            Enumeration[] new_enums = new Enumeration[len + 8];
            System.arraycopy(this.enums, 0, new_enums, 0, len);
            this.enums = new_enums;
        }
        this.enums[this.tail++] = e;
    }

    @Override
    public synchronized boolean hasMoreElements() {
        while (this.cur < this.tail) {
            if (this.enums[this.cur].hasMoreElements()) {
                return true;
            }
            ++this.cur;
        }
        return false;
    }

    @Override
    public synchronized E nextElement() {
        while (this.cur < this.tail) {
            if (this.enums[this.cur].hasMoreElements()) {
                return this.enums[this.cur].nextElement();
            }
            ++this.cur;
        }
        throw new NoSuchElementException();
    }
}

