/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.enumerations;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class ArrayEnumerator<T>
implements Enumeration<T>,
Serializable,
Cloneable {
    private static final long serialVersionUID = 7377964619523380123L;
    private T[] array;
    private int idx;

    public ArrayEnumerator(T[] array) {
        this.array = array;
        this.idx = 0;
    }

    @Override
    public boolean hasMoreElements() {
        return this.idx < this.array.length;
    }

    @Override
    public T nextElement() {
        try {
            return this.array[this.idx++];
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            throw new NoSuchElementException();
        }
    }

    public int which() {
        if (this.idx == 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.idx - 1;
    }

    public synchronized Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new RuntimeException("Contents of enum not cloneable" + cnse);
        }
    }
}

