/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.encoders;

import java.util.ArrayList;

abstract class ThreadLocalCache<K, V> {
    private ThreadLocal<ArrayList<V>> cache = new ThreadLocal();
    private final int size;

    ThreadLocalCache(int size) {
        this.size = size;
    }

    abstract V createValue(K var1);

    abstract boolean isIncluded(V var1, K var2);

    void moveToFirst(ArrayList<V> arrayList, int location) {
        V value = arrayList.remove(location);
        arrayList.add(0, value);
    }

    V findOrCreateByName(K name) {
        ArrayList<Object> arrayList = this.cache.get();
        if (arrayList == null) {
            arrayList = new ArrayList(this.size);
            this.cache.set(arrayList);
        } else {
            for (int i = 0; i < arrayList.size(); ++i) {
                Object value = arrayList.get(i);
                if (value == null || !this.isIncluded(value, name)) continue;
                if (i != 0) {
                    this.moveToFirst(arrayList, i);
                }
                return (V)value;
            }
        }
        V value = this.createValue(name);
        if (arrayList.size() == this.size) {
            arrayList.set(arrayList.size() - 1, value);
        } else {
            arrayList.add(value);
        }
        if (arrayList.size() > 1) {
            this.moveToFirst(arrayList, arrayList.size() - 1);
        }
        return value;
    }
}

