/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.concurrent.locks;

public class NonRecursiveReadWriteLock {
    private int counter;
    private int waitingWriters;

    public synchronized void lockRead() {
        while (this.counter < 0 || this.waitingWriters > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        ++this.counter;
    }

    public synchronized void unlockRead() {
        assert (this.isLockedForRead());
        --this.counter;
        if (this.waitingWriters > 0) {
            this.notifyAll();
        }
    }

    public synchronized boolean isLockedForRead() {
        return this.counter > 0;
    }

    public synchronized void lockWrite() {
        while (this.counter != 0) {
            ++this.waitingWriters;
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
            continue;
            finally {
                --this.waitingWriters;
            }
        }
        this.counter = -1;
    }

    public synchronized void unlockWrite() {
        assert (this.isLockedForWrite());
        this.counter = 0;
        this.notifyAll();
    }

    public synchronized boolean isLockedForWrite() {
        return this.counter < 0;
    }
}

