/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.concurrent.atomic;

import weblogic.utils.concurrent.atomic.AtomicLong;

public final class JavaAtomicLong
implements AtomicLong {
    private long value;

    JavaAtomicLong() {
    }

    @Override
    public synchronized long addAndGet(long delta) {
        this.value += delta;
        return this.value;
    }

    @Override
    public synchronized long decrementAndGet() {
        return --this.value;
    }

    @Override
    public synchronized long get() {
        return this.value;
    }

    @Override
    public synchronized long getAndAdd(long delta) {
        long before = this.value;
        this.value += delta;
        return before;
    }

    @Override
    public synchronized long getAndDecrement() {
        return this.value--;
    }

    @Override
    public synchronized long getAndIncrement() {
        return this.value++;
    }

    @Override
    public synchronized long getAndSet(long newValue) {
        long before = this.value;
        this.value = newValue;
        return before;
    }

    @Override
    public synchronized long incrementAndGet() {
        return ++this.value;
    }

    @Override
    public synchronized void set(long newValue) {
        this.value = newValue;
    }

    public synchronized boolean equals(Object obj) {
        try {
            return ((JavaAtomicLong)obj).value == this.value;
        }
        catch (ClassCastException cce) {
            return false;
        }
        catch (NullPointerException cce) {
            return false;
        }
    }

    public synchronized int hashCode() {
        return (int)this.value;
    }

    public synchronized String toString() {
        return String.valueOf(this.value);
    }
}

