/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.concurrent;

import java.util.concurrent.atomic.AtomicInteger;

public class WaterMark {
    private volatile int originalLevel;
    private AtomicInteger currentLevel;
    private volatile boolean enabled;

    public WaterMark(int level) {
        this.originalLevel = level;
        this.currentLevel = new AtomicInteger(level);
        if (this.originalLevel > 0) {
            this.enabled = true;
        }
    }

    public int getOriginalLevel() {
        return this.originalLevel;
    }

    public int getCurrentLevel() {
        return this.currentLevel.get();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public synchronized void resetLevel(int newLevel) {
        if (this.originalLevel == newLevel) {
            return;
        }
        int diff = newLevel - this.originalLevel;
        this.changeCurrentLevel(diff);
        this.originalLevel = newLevel;
        this.enabled = newLevel > 0;
    }

    public synchronized int diff() {
        return this.originalLevel - this.getCurrentLevel();
    }

    public boolean tryDecreaseByOne() {
        int available;
        do {
            if ((available = this.getCurrentLevel()) >= 1) continue;
            return false;
        } while (!this.currentLevel.compareAndSet(available, available - 1));
        return true;
    }

    public boolean tryIncreaseByOneIfBelowZero() {
        int available;
        do {
            if ((available = this.getCurrentLevel()) < 0) continue;
            return false;
        } while (!this.currentLevel.compareAndSet(available, available + 1));
        return true;
    }

    public void decreaseLevel(int val) {
        if (val == 0) {
            return;
        }
        this.changeCurrentLevel(-val);
    }

    public void increaseLevel(int val) {
        if (val == 0) {
            return;
        }
        this.changeCurrentLevel(val);
    }

    private void changeCurrentLevel(int val) {
        this.currentLevel.getAndAdd(val);
    }
}

