/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.compiler;

import java.io.IOException;
import java.io.Writer;

public class IndentingWriter
extends Writer {
    protected Writer out;
    protected int indentLevel;
    private boolean needIndent = false;
    protected int depth = 0;

    public IndentingWriter(Writer delegate) {
        this(delegate, Integer.getInteger("weblogic.codegen.indentLevel", 4));
    }

    public IndentingWriter(Writer delegate, int indentLevel) {
        this.out = delegate;
        this.indentLevel = indentLevel;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        int i;
        if (off < 0 || off + len > cbuf.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int lim = off + len;
        for (i = off; i < lim && cbuf[off] == ' '; ++i) {
            ++off;
            --len;
        }
        for (i = off; i < off + len; ++i) {
            char c = cbuf[i];
            if (c == '}') {
                this.decrDepth();
            }
            if ((c == ' ' || c == '\t') && this.needIndent) continue;
            if (this.needIndent) {
                this.indent();
            }
            this.out.write(c);
            if (c == '\n') {
                this.needIndent = true;
            }
            if (c != '{') continue;
            this.incrDepth();
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    private void indent() throws IOException {
        for (int i = 0; i < this.depth; ++i) {
            this.out.write(32);
        }
        this.needIndent = false;
    }

    private void incrDepth() {
        this.depth += this.indentLevel;
    }

    private void decrDepth() {
        this.depth -= this.indentLevel;
        if (this.depth < 0) {
            this.depth = 0;
        }
    }
}

