/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.compiler;

import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import weblogic.utils.ArrayUtils;
import weblogic.utils.Classpath;
import weblogic.utils.Executable;
import weblogic.utils.FileUtils;
import weblogic.utils.Getopt2;
import weblogic.utils.PlatformConstants;
import weblogic.utils.StackTraceUtilsClient;
import weblogic.utils.compiler.ICompilerInvoker;
import weblogic.utils.io.ExtensionFilter;

public final class CompilerInvoker
implements ICompilerInvoker {
    private static final String[] STRING_ARRAY = new String[0];
    private static final Object[] NULL_ARGS = new Object[0];
    private static final Class[] NULL_ARG_TYPES = new Class[0];
    private static final Class[] COMPILE_ARG_TYPES = new Class[]{STRING_ARRAY.getClass(), PrintWriter.class};
    private static final String DEFAULT_COMPILER = "javac";
    private static final String DEFAULT_COMPILER_CLASS = "com.sun.tools.javac.Main";
    private static final String COMPILER_OPTS = "g,O,nowarn,nowrite,deprecation,J,classpath,source,d,normi,target";
    private String[] extraCompileFlags = STRING_ARRAY;
    private String compiler;
    private String classpath;
    private String compilerclass;
    private String targetDirectory;
    private boolean verbose;
    private boolean verboseJavac;
    private boolean noexit;
    private String rootDirectory;
    private String sourcepath;
    private int maxFiles;
    private final Getopt2 opts;
    private CharArrayWriter outwriter;
    private CharArrayWriter errwriter;
    private final Executable executable = new Executable();

    public CompilerInvoker() {
        this(new Getopt2());
    }

    public CompilerInvoker(Getopt2 opts) {
        this.opts = opts;
        this.initOpts();
    }

    private boolean verbose() {
        return this.verbose;
    }

    @Override
    public void setExtraCompileFlags(String[] x) {
        this.extraCompileFlags = x;
    }

    @Override
    public void setNoExit(boolean b) {
        this.noexit = b;
    }

    @Override
    public void overrideTargetDirectory(String targetDir) {
        this.targetDirectory = targetDir;
    }

    @Override
    public void setSourcepath(String path) {
        this.sourcepath = path;
    }

    @Override
    public void setWantCompilerErrors(boolean arg) {
        if (arg) {
            this.outwriter = new CharArrayWriter();
            this.errwriter = new CharArrayWriter();
            this.executable.setUseCharWriter(this.outwriter, this.errwriter);
        }
    }

    @Override
    public String getCompilerErrors() {
        StringBuffer sb = new StringBuffer();
        if (this.outwriter != null) {
            sb.append(this.outwriter.toString());
        }
        if (this.errwriter != null) {
            sb.append("\n");
            sb.append(this.errwriter.toString());
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    private static boolean quoted(String s) {
        if (s == null) {
            return false;
        }
        char[] quotes = new char[]{'\"', '\''};
        for (int i = 0; i < quotes.length; ++i) {
            if (s.charAt(0) != quotes[i] || s.charAt(s.length() - 1) != quotes[i]) continue;
            return true;
        }
        return false;
    }

    private void parseArguments() {
        this.compiler = this.opts.getOption("compiler");
        this.classpath = this.opts.getOption("classpath", Classpath.get());
        this.compilerclass = this.opts.getOption("compilerclass");
        this.noexit = this.opts.getBooleanOption("noexit", this.noexit);
        this.verbose = this.opts.getBooleanOption("commentary");
        this.verboseJavac = this.opts.getBooleanOption("verboseJavac");
        this.maxFiles = this.opts.getIntegerOption("maxfiles");
        if (CompilerInvoker.quoted(this.compiler)) {
            this.compiler = this.compiler.substring(1, this.compiler.length() - 1);
        }
        if (this.opts.hasOption("d")) {
            this.rootDirectory = this.opts.getOption("d");
            this.rootDirectory = this.rootDirectory.replace('/', File.separatorChar);
        }
    }

    private boolean execCompiler(List args, List files) throws IOException {
        args.add(0, this.compiler);
        if (!args.contains("-classpath")) {
            String classPathToSet = this.classpath;
            args.add("-classpath");
            args.add(classPathToSet);
        }
        boolean result = true;
        if (files.size() == 1) {
            args.addAll(files);
            String[] argv = args.toArray(new String[args.size()]);
            result = this.executable.exec(argv);
        } else {
            int batch;
            File tempDir = new File(System.getProperty("java.io.tmpdir"));
            if (!tempDir.exists()) {
                tempDir.mkdirs();
            }
            int n = batch = this.maxFiles > 0 ? this.maxFiles : files.size();
            if (this.verbose) {
                System.err.println("Running with batch size " + batch);
            }
            int start = 0;
            int size = files.size();
            while (start < size && result) {
                int end = Math.min(start + batch, size);
                if (this.verbose) {
                    System.err.println("Compiling files between " + start + ", " + end);
                }
                result = this.execCompilerBatch(args, files, start, end);
                start = end;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean execCompilerBatch(List args, List files, int start, int end) throws IOException {
        File compileList = null;
        try {
            compileList = File.createTempFile("compileList", null);
            FileWriter writer = new FileWriter(compileList);
            for (int i = start; i < end; ++i) {
                String s = (String)files.get(i);
                if (s.indexOf(32) != -1) {
                    s = new File(s).toURL().toString().substring(6);
                    s = "\"" + s + "\"";
                    files.set(i, s);
                }
                writer.write(s);
                writer.write(PlatformConstants.EOL);
            }
            writer.close();
            String[] argv = args.toArray(new String[1 + args.size()]);
            argv[args.size()] = "@" + compileList;
            boolean bl = this.executable.exec(argv);
            return bl;
        }
        finally {
            if (compileList != null) {
                compileList.delete();
            }
        }
    }

    private boolean invokeCompile(Class c, List stdArgs, List files) throws Throwable {
        int batch;
        Object compiler;
        Method m;
        Constructor javacInit;
        int classMods = c.getModifiers();
        if (!Modifier.isPublic(classMods) || Modifier.isInterface(classMods)) {
            throw new IllegalAccessException(c.getName() + " is not a public class");
        }
        try {
            javacInit = c.getConstructor(NULL_ARG_TYPES);
        }
        catch (NoSuchMethodException e1) {
            throw new NoSuchMethodException(c.getName() + " does not define a default constructor");
        }
        try {
            m = c.getMethod("compile", COMPILE_ARG_TYPES);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodException(c.getName() + " does not define 'public static int compile(String[], java.io.PrintWriter)'");
        }
        int mods = m.getModifiers();
        if (!Modifier.isPublic(mods)) {
            throw new IllegalAccessException(c.getName() + ".compile(String[]java.io.PrintWriter) must must be a public method");
        }
        PrintWriter pw = this.errwriter == null ? new PrintWriter(System.err, true) : new PrintWriter((Writer)this.errwriter, true);
        try {
            compiler = javacInit.newInstance(NULL_ARGS);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        int n = batch = this.maxFiles > 0 ? this.maxFiles : files.size();
        if (this.verbose) {
            System.err.println("Running with batch size " + batch);
        }
        boolean result = true;
        int start = 0;
        int size = files.size();
        while (start < size && result) {
            int end = Math.min(start + batch, size);
            if (this.verbose) {
                System.err.println("Compiling files between " + start + ", " + end);
            }
            ArrayList args = new ArrayList(stdArgs.size() + (end - start));
            args.addAll(stdArgs);
            args.addAll(files.subList(start, end));
            Object[] compileArgs = new Object[]{args.toArray(new String[args.size()]), pw};
            try {
                Number returnValue = (Number)m.invoke(compiler, compileArgs);
                result = returnValue.intValue() == 0;
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
            start = end;
        }
        return result;
    }

    @Override
    public void compile() throws IOException {
        this.parseArguments();
        this.compile(this.opts.args());
    }

    @Override
    public void compile(List sources) throws IOException {
        this.parseArguments();
        this.compileMaybeExit(sources);
    }

    @Override
    public void compile(String[] sources) throws IOException {
        ArrayList l = new ArrayList();
        ArrayUtils.addAll(l, sources);
        this.compile(l);
    }

    private List getArgs(boolean inlineCompile) {
        int i;
        String[] copts = this.opts.asCommandArray(COMPILER_OPTS);
        ArrayList<String> l = new ArrayList<String>();
        if (this.verboseJavac) {
            l.add("-verbose");
        }
        if (this.sourcepath != null) {
            l.add("-sourcepath");
            l.add(this.sourcepath);
        }
        for (i = 0; i < copts.length; ++i) {
            if (copts[i].equals("-J")) {
                String newOpt = copts[i] + copts[++i];
                if (!inlineCompile) {
                    l.add(newOpt);
                    continue;
                }
                System.out.println("[CompilerInvoker] Ignoring " + newOpt + " as this is an inline compilation");
                continue;
            }
            if (copts[i].startsWith("-J")) {
                if (!inlineCompile) {
                    l.add(copts[i]);
                    continue;
                }
                System.out.println("[CompilerInvoker] Ignoring the option '" + copts[i] + "' as this is an inline compilation");
                continue;
            }
            l.add(copts[i]);
        }
        ArrayUtils.addAll(l, this.extraCompileFlags);
        if (this.targetDirectory != null) {
            i = l.indexOf("-d");
            if (i >= 0) {
                l.set(i + 1, this.targetDirectory);
            } else {
                l.add("-d");
                l.add(this.targetDirectory);
            }
        }
        return l;
    }

    private void compileMaybeExit(List files) throws IOException {
        boolean result;
        Iterator i;
        List args;
        if (this.compiler == null && this.compilerclass == null) {
            this.compilerclass = DEFAULT_COMPILER_CLASS;
        }
        if (this.compilerclass != null) {
            Class<?> compilerClass;
            args = this.getArgs(true);
            if (this.verbose) {
                System.err.println("About to compile with arguments:");
                i = args.iterator();
                while (i.hasNext()) {
                    System.err.print(i.next() + " ");
                }
                System.err.println();
            }
            try {
                compilerClass = Class.forName(this.compilerclass);
            }
            catch (ClassNotFoundException cnfe) {
                System.err.println("Compiler class: '" + this.compilerclass + "', not found");
                throw new IOException("Compiler class: '" + this.compilerclass + "', not found " + cnfe);
            }
            try {
                if (this.verbose) {
                    System.err.println("Compiling inline");
                }
                result = this.invokeCompile(compilerClass, args, files);
            }
            catch (Throwable t) {
                throw new IOException("Compilation error " + StackTraceUtilsClient.throwable2StackTrace(t));
            }
        }
        args = this.getArgs(false);
        if (this.verbose) {
            System.err.println("About to compile with arguments:");
            i = args.iterator();
            while (i.hasNext()) {
                System.err.print(i.next() + " ");
            }
            System.err.println();
        }
        if (this.verbose) {
            System.err.println("Exec'ing compiler");
        }
        result = this.execCompiler(args, files);
        if (result) {
            if (!this.opts.hasOption("keepgenerated")) {
                for (String s : files) {
                    File dir;
                    if (s.endsWith("*.java")) {
                        dir = new File(s.substring(0, s.indexOf("*.java")));
                        FileUtils.remove(dir, new ExtensionFilter("java"));
                        continue;
                    }
                    if (s.endsWith("*Stub.java")) {
                        dir = new File(s.substring(0, s.indexOf("*Stub.java")));
                        FileUtils.remove(dir, new FileFilter(){

                            @Override
                            public boolean accept(File f) {
                                return f.getName().endsWith("Stub.java");
                            }
                        });
                        continue;
                    }
                    if (s.endsWith("*Skel.java")) {
                        dir = new File(s.substring(0, s.indexOf("*Skel.java")));
                        FileUtils.remove(dir, new FileFilter(){

                            @Override
                            public boolean accept(File f) {
                                return f.getName().endsWith("Skel.java");
                            }
                        });
                        continue;
                    }
                    File f = new File(s);
                    if (!f.exists()) continue;
                    if (this.verbose()) {
                        System.out.println("Deleting: '" + f.getAbsolutePath() + "'");
                    }
                    f.delete();
                }
            }
        } else {
            if (this.noexit) {
                throw new IOException("Compiler failed executable.exec: " + this.getCompilerErrors());
            }
            System.out.println("Exec failed .. exiting");
            System.exit(1);
        }
    }

    private void initOpts() {
        Getopt2 jOpt = CompilerInvoker.getJopts();
        this.opts.addFlag("keepgenerated", "Keep the generated .java files.");
        this.opts.addFlag("noexit", "Throw an exception on failure rather than calling System.exit()");
        this.opts.addFlag("commentary", "Emit commentary.");
        this.opts.addOption("compiler", DEFAULT_COMPILER, "Java compiler to exec.  If not specified, the -compilerclass option will be used.");
        this.opts.addOption("compilerclass", DEFAULT_COMPILER_CLASS, "Compiler class to invoke.");
        this.opts.addFlag("g", "Compile debugging info into class file.");
        this.opts.addFlag("O", "Compile with optimization on.");
        this.opts.addFlag("nowarn", "Compile without warnings.");
        this.opts.addFlag("verbose", "Compile with verbose output.");
        this.opts.addFlag("verboseJavac", "Enable Java compiler verbose output.");
        this.opts.addFlag("nowrite", "Don't generate .class files.");
        this.opts.addFlag("deprecation", "Warn about deprecated calls.");
        this.opts.addFlag("normi", "Passed through to Symantec's sj.");
        this.opts.addOption("classpath", "path", "Classpath to use.");
        this.opts.addOption("source", "source", "Source version.");
        this.opts.addOption("target", "target", "Target version.");
        this.opts.addOption("d", "dir", "Target (top-level) directory.");
        this.opts.addSubOpt("J", jOpt, "Flags passed through to java runtime.");
    }

    private static Getopt2 getJopts() {
        Getopt2 jOpt = new Getopt2();
        jOpt.addFlag("help", "print out this message");
        jOpt.addFlag("version", "print out the build version");
        jOpt.addFlag("verbose", "turn on verbose mode");
        jOpt.addAlias("v", "verbose");
        jOpt.addFlag("debug", "enable remote JAVA debugging");
        jOpt.addFlag("noasyncgc", "don't allow asynchronous garbage collection");
        jOpt.addFlag("verbosegc", "print a message when garbage collection occurs");
        jOpt.addFlag("noclassgc", "disable class garbage collection");
        jOpt.addArgFlag("ss", "number", "set the maximum native stack size for any thread");
        jOpt.addArgFlag("oss", "number", "set the maximum Java stack size for any thread");
        jOpt.addArgFlag("ms", "number", "set the initial Java heap size");
        jOpt.addArgFlag("mx", "number", "set the maximum Java heap size");
        jOpt.addArgFlag("Xss", "number", "set the maximum native stack size for any thread");
        jOpt.addArgFlag("Xoss", "number", "set the maximum Java stack size for any thread");
        jOpt.addArgFlag("Xms", "number", "set the initial Java heap size");
        jOpt.addArgFlag("Xmx", "number", "set the maximum Java heap size");
        jOpt.addOption("classpath", "directories separated by semicolons", "list directories in which to look for classes");
        jOpt.addOption("source", "source version", "source version");
        jOpt.addOption("target", "target version", "target version");
        jOpt.addArgFlag("prof", "file", "output profiling data to .\\java.prof or .\\<file>");
        jOpt.addFlag("verify", "verify all classes when read in");
        jOpt.addFlag("verifyremote", "verify classes read in over the network [default]");
        jOpt.addFlag("noverify", "do not verify any class");
        jOpt.addFlag("nojit", "disable JIT compiler");
        return jOpt;
    }

    public static void main(String[] args) throws IOException {
        CompilerInvoker theCompiler = new CompilerInvoker();
        theCompiler.compile(args);
    }
}

