/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.compiler;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import weblogic.utils.AssertionError;
import weblogic.utils.BadOptionException;
import weblogic.utils.CharUtils;
import weblogic.utils.Getopt2;
import weblogic.utils.PlatformConstants;
import weblogic.utils.compiler.BadOutputException;
import weblogic.utils.compiler.CodeGenerationException;
import weblogic.utils.compiler.DefaultCompilerFactory;
import weblogic.utils.compiler.ICompilerFactory;
import weblogic.utils.compiler.IndentingWriter;

public abstract class CodeGenerator
implements PlatformConstants {
    private static final boolean debug = false;
    private static final boolean verbose = false;
    private Getopt2 opts = null;
    protected boolean verboseCodegen;
    private Output currentOutput;
    private String encoding = null;
    protected String targetDirectory = null;
    protected boolean CheckValidChar = true;
    protected ICompilerFactory compilerFactory = null;
    public static final String NON_WORD_CHARS = "@.,();:[]=+-*/\" \r\n\t'";
    private Hashtable productionRules;

    public CodeGenerator() {
        this(new Getopt2());
    }

    public CodeGenerator(Getopt2 opts) {
        this.opts = opts;
        opts.addOption("d", "dir", "Target (top-level) directory for compilation.");
        opts.addFlag("verboseCodegen", "Emit debugging output during codegen.");
        opts.markPrivate("verboseCodegen");
    }

    protected void extractOptionValues(Getopt2 opts) {
    }

    protected Enumeration outputs(List inputs) throws Exception {
        return null;
    }

    protected Enumeration outputs(Object[] inputs) throws Exception {
        return null;
    }

    protected void prepare(Output output) throws Exception {
        this.currentOutput = output;
    }

    protected void cleanup() throws Exception {
    }

    public final String[] generate() throws Exception {
        return this.generate(this.opts.args());
    }

    public final List generate(Object o) throws Exception {
        ArrayList<Object> l = new ArrayList<Object>();
        l.add(o);
        return this.generate(l);
    }

    public final List generate(List args) throws Exception {
        this.verboseCodegen = this.opts.hasOption("verboseCodegen");
        this.extractOptionValues(this.opts);
        ArrayList<String> generated = new ArrayList<String>();
        Enumeration outputs = this.outputs(args);
        while (outputs.hasMoreElements()) {
            Output output = null;
            Object o = null;
            try {
                o = outputs.nextElement();
                output = (Output)o;
            }
            catch (ClassCastException cce) {
                throw new BadOutputException("outputs() returned a " + o.getClass().getName() + " instead of an Output.");
            }
            this.currentOutput = output;
            this.prepare(output);
            generated.add(this.generateCode(output));
            generated.addAll(output.getExtraOutputFiles());
            this.cleanup();
        }
        return generated;
    }

    public final String[] generate(Object[] args) throws Exception {
        this.verboseCodegen = this.opts.hasOption("verboseCodegen");
        this.extractOptionValues(this.opts);
        ArrayList<String> generated = new ArrayList<String>();
        Enumeration outputs = this.outputs(args);
        if (outputs == null) {
            return null;
        }
        while (outputs.hasMoreElements()) {
            Output output = null;
            Object o = null;
            try {
                o = outputs.nextElement();
                output = (Output)o;
            }
            catch (ClassCastException cce) {
                throw new BadOutputException("outputs() returned a " + o.getClass().getName() + " instead of an Output.");
            }
            this.currentOutput = output;
            this.prepare(output);
            generated.add(this.generateCode(output));
            generated.addAll(output.getExtraOutputFiles());
            this.cleanup();
        }
        String[] res = new String[generated.size()];
        res = generated.toArray(res);
        return res;
    }

    public final String generateCode(Output output) throws IOException, CodeGenerationException {
        if (this.verboseCodegen) {
            System.out.println("Generating code for " + output.getOutputFile());
        }
        this.productionRules = new Hashtable();
        this.processTemplate(this.productionRules, output, output.getTemplate());
        String[] extraTemplates = output.getExtraTemplates();
        for (int i = 0; i < extraTemplates.length; ++i) {
            this.processTemplate(this.productionRules, output, extraTemplates[i]);
        }
        String outputFileName = output.getOutputFile().replace('/', File.separatorChar);
        File outputFile = this.targetFile(outputFileName, output.getPackage());
        String result = this.parse((String)this.productionRules.get("main"));
        this.writeToFile(result, outputFile);
        return outputFile.getAbsolutePath();
    }

    protected void writeToFile(String result, File outputFile) throws IOException {
        if (this.verboseCodegen) {
            System.out.println("Output file:  " + outputFile.getAbsolutePath());
        }
        CodeGenerator.ensureDir(outputFile);
        PrintWriter pw = this.makeOutputStream(outputFile);
        if (this.CheckValidChar) {
            pw.print(CharUtils.unicodeEscapeInvalidChars(result, this.encoding));
        } else {
            pw.print(result);
        }
        pw.close();
    }

    protected Writer makeWriter(File f) throws IOException {
        if (null == this.compilerFactory) {
            this.compilerFactory = new DefaultCompilerFactory();
        }
        return this.compilerFactory.makeWriter(f);
    }

    protected PrintWriter makeOutputStream(File f) throws IOException {
        return new PrintWriter(this.makeWriter(f));
    }

    protected PrintWriter makeIndentingOutputStream(File f) throws IOException {
        IndentingWriter w = new IndentingWriter(this.makeWriter(f), 2);
        return new PrintWriter(w);
    }

    public File installResource(File orig, String pkg) throws IOException {
        String filename = orig.getAbsolutePath();
        File target = this.targetFile(filename, pkg);
        if (target.getCanonicalPath().equals(orig.getCanonicalPath())) {
            return orig;
        }
        CodeGenerator.ensureDir(target);
        BufferedWriter out = new BufferedWriter(new FileWriter(target));
        out.write(CodeGenerator.getFileChars(orig));
        ((Writer)out).flush();
        ((Writer)out).close();
        return target;
    }

    public static char[] getFileChars(File file) throws IOException {
        FileInputStream f = new FileInputStream(file);
        char[] value = null;
        int size = ((InputStream)f).available();
        InputStreamReader fr = new InputStreamReader(f);
        if (size > 0) {
            value = new char[size];
            fr.read(value);
        }
        ((InputStream)f).close();
        return value;
    }

    public void setRootDirectoryName(String s) {
        try {
            this.opts.setOption("d", s);
        }
        catch (BadOptionException boe) {
            throw new AssertionError(boe);
        }
    }

    public String getRootDirectoryName() {
        return this.opts.getOption("d");
    }

    public File targetFile(String filename, String pkg) {
        File fn = new File(filename);
        String absolutePath = fn.getAbsolutePath();
        if (absolutePath.equals(filename)) {
            return fn;
        }
        if (this.getRootDirectoryName() == null) {
            return new File(filename);
        }
        String rootDirectory = this.rootDirectory();
        File rootdir = new File(rootDirectory);
        File pkgdir = pkg == null ? rootdir : new File(rootdir, pkg.replace('.', File.separatorChar));
        return new File(pkgdir, filename);
    }

    public String rootDirectory() {
        if (this.targetDirectory != null) {
            return this.targetDirectory;
        }
        String rootDirectory = this.getRootDirectoryName();
        return rootDirectory == null ? "." : rootDirectory;
    }

    public void setTargetDirectory(String target) {
        this.targetDirectory = target;
    }

    public void setEncoding(String e) {
        this.encoding = e;
    }

    public static void ensureDir(File f) {
        File dir;
        String path = f.getParent();
        if (path != null && !(dir = new File(path)).exists()) {
            dir.mkdirs();
        }
    }

    public String parse(String token_stream) throws CodeGenerationException {
        return this.parse(token_stream, NON_WORD_CHARS);
    }

    public String parse(String token_stream, String nonWordChars) throws CodeGenerationException {
        StringBuffer sb;
        block17: {
            int line = 1;
            sb = new StringBuffer(256);
            StringTokenizer template = new StringTokenizer(token_stream, nonWordChars, true);
            String s = null;
            if (!template.hasMoreTokens()) {
                throw new Error("Template has no tokens.");
            }
            s = template.nextToken();
            try {
                block13: while (true) {
                    char c = s.charAt(0);
                    switch (c) {
                        case '@': {
                            s = template.nextToken();
                            this.processAt(s, sb, line);
                            break;
                        }
                        case '\n': 
                        case '\r': {
                            try {
                                s = template.nextToken();
                                char c2 = s.charAt(0);
                                switch (c2) {
                                    case '\n': 
                                    case '\r': {
                                        if (c2 != c) {
                                            s = template.nextToken();
                                        }
                                        sb.append(EOL);
                                        ++line;
                                        continue block13;
                                    }
                                    case '@': {
                                        sb.append(EOL);
                                        s = template.nextToken();
                                        this.processAt(s, sb, ++line);
                                        s = template.nextToken();
                                        continue block13;
                                    }
                                }
                                sb.append(EOL);
                                ++line;
                            }
                            catch (NoSuchElementException nsee) {
                                sb.append(EOL);
                                break block17;
                            }
                        }
                        default: {
                            sb.append(s);
                        }
                    }
                    if (template.hasMoreTokens()) {
                        s = template.nextToken();
                        continue;
                    }
                    break;
                }
            }
            catch (CodeGenerationException cge) {
                throw cge;
            }
            catch (Exception e) {
                throw new CodeGenerationException(e);
            }
        }
        return sb.toString();
    }

    private void processAt(String name, StringBuffer sb, int line) throws CodeGenerationException {
        Method m = null;
        if (name.equals("@")) {
            sb.append("@");
            return;
        }
        try {
            if (this.verboseCodegen) {
                System.out.println("Invoking " + name);
            }
            m = this.getClass().getMethod(name, null);
        }
        catch (NoSuchMethodException nsme) {
            String rule = (String)this.productionRules.get(name);
            if (rule != null) {
                String out = this.parse(rule);
                if (this.verboseCodegen) {
                    System.out.println("Adding '" + out + "'");
                }
                sb.append(out);
                return;
            }
            throw new CodeGenerationException("Neither method nor production rule found for '" + name + "' in " + this.currentOutput.getTemplate() + " at line " + line);
        }
        try {
            Object res = m.invoke((Object)this, (Object[])null);
            if (res == null) {
                throw new CodeGenerationException("res == null with m = " + m.getName());
            }
            String str = res.toString();
            if (this.verboseCodegen) {
                System.out.println("Adding '" + str + "'");
            }
            sb.append(str);
        }
        catch (InvocationTargetException ite) {
            Throwable th = ite.getTargetException();
            String msg = "Exception: '" + th + "' while trying to invoke: " + m.getName() + " at line " + line;
            if (th.getClass().equals(CodeGenerationException.class)) {
                throw (CodeGenerationException)th;
            }
            throw new CodeGenerationException(msg, th);
        }
        catch (IllegalAccessException iae) {
            throw new CodeGenerationException(iae);
        }
    }

    protected void processTemplate(Hashtable h, String templateName) throws IOException, CodeGenerationException {
        InputStream is = this.getClass().getResourceAsStream(templateName);
        if (is == null) {
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(templateName);
        }
        this.processTemplate(h, is, templateName);
    }

    protected void processTemplate(Hashtable h, Output output, String templateName) throws IOException, CodeGenerationException {
        this.processTemplate(h, output.getTemplateStream(templateName), templateName);
    }

    private void processTemplate(Hashtable h, InputStream is, String templateName) throws IOException, CodeGenerationException {
        if (is == null) {
            throw new FileNotFoundException("Production rule file '" + templateName + "' not found.");
        }
        if (this.verboseCodegen) {
            System.out.println("Processing template " + templateName);
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        this.processProductionRules(br, h);
        br.close();
    }

    protected void processProductionRules(BufferedReader br, Hashtable rules) throws IOException, CodeGenerationException {
        String line = null;
        String rule = null;
        StringBuilder sb = null;
        while ((line = br.readLine()) != null) {
            if (line.startsWith("@end rule: ")) {
                rule = this.getRuleName(line);
                if (rules.put(rule, sb.toString()) != null) {
                    throw new CodeGenerationException("Rule '" + rule + "' already defined.");
                }
                sb = null;
                rule = null;
            }
            if (rule != null) {
                sb.append(line + "\n");
            }
            if (!line.startsWith("@start rule: ")) continue;
            rule = this.getRuleName(line);
            sb = new StringBuilder(512);
        }
        if (this.verboseCodegen) {
            System.out.println();
            Enumeration e = rules.keys();
            while (e.hasMoreElements()) {
                rule = (String)e.nextElement();
                System.out.println("Found rule " + rule);
            }
        }
    }

    protected String getRuleName(String line) {
        StringTokenizer st = new StringTokenizer(line, " ");
        String name = null;
        try {
            name = st.nextToken();
            name = st.nextToken();
            name = st.nextToken();
        }
        catch (Exception e) {
            throw new Error("Invalid configuration file: " + line);
        }
        return name;
    }

    protected String getProductionRule(String name) {
        String res = (String)this.productionRules.get(name);
        if (res == null) {
            throw new Error("No production '" + name + "' in template.");
        }
        return res;
    }

    public String generator() {
        return this.getClass().getName();
    }

    public String time() {
        return MessageFormat.format("{0,time}", new Date());
    }

    public String date() {
        return MessageFormat.format("{0,date}", new Date());
    }

    public String year() {
        return "" + new GregorianCalendar().get(1);
    }

    public String timeAndDate() {
        return new Date().toString();
    }

    public String buildString() {
        return "Unknown";
    }

    public String javaCodeForType(Class c) {
        if (c.isPrimitive()) {
            return this.primitive_type(c);
        }
        if (c.isArray() && this.is_primitive_array(c)) {
            return this.primitive_type_array(c);
        }
        if (c.isArray()) {
            return this.type_array(c);
        }
        return c.getName().replace('$', '.');
    }

    public String primitive_type(Class c) {
        if (c.equals(Boolean.TYPE)) {
            return "boolean";
        }
        if (c.equals(Character.TYPE)) {
            return "char";
        }
        if (c.equals(Byte.TYPE)) {
            return "byte";
        }
        if (c.equals(Short.TYPE)) {
            return "short";
        }
        if (c.equals(Integer.TYPE)) {
            return "int";
        }
        if (c.equals(Long.TYPE)) {
            return "long";
        }
        if (c.equals(Float.TYPE)) {
            return "float";
        }
        if (c.equals(Double.TYPE)) {
            return "double";
        }
        if (c.equals(Void.TYPE)) {
            return "void";
        }
        throw new AssertionError("Primitive type not found for: [" + c + "]");
    }

    public String type_array(Class c) {
        StringBuffer brs = new StringBuffer("[]");
        int multiDim = c.getName().lastIndexOf(91);
        for (int i = 0; i < multiDim; ++i) {
            brs = brs.append("[]");
        }
        Class<?> tmp = c;
        while (tmp.isArray()) {
            tmp = tmp.getComponentType();
        }
        return tmp.getName().replace('$', '.') + brs;
    }

    public Class get_component_type(Class c) {
        while (c.isArray()) {
            c = c.getComponentType();
        }
        return c;
    }

    public String primitive_type_array(Class c) {
        StringBuffer brs = new StringBuffer(" ");
        int multiDim = c.getName().length() - 1;
        if (multiDim > 0) {
            for (int i = 0; i < multiDim; ++i) {
                brs = brs.append("[]");
            }
        }
        if (c.getName().endsWith("[Z")) {
            return "boolean" + brs;
        }
        if (c.getName().endsWith("[C")) {
            return "char" + brs;
        }
        if (c.getName().endsWith("[B")) {
            return "byte" + brs;
        }
        if (c.getName().endsWith("[S")) {
            return "short" + brs;
        }
        if (c.getName().endsWith("[I")) {
            return "int" + brs;
        }
        if (c.getName().endsWith("[J")) {
            return "long" + brs;
        }
        if (c.getName().endsWith("[F")) {
            return "float" + brs;
        }
        if (c.getName().endsWith("[D")) {
            return "double" + brs;
        }
        throw new AssertionError("Primitive type not found");
    }

    public boolean is_primitive_array(Class c) {
        if (c.getName().endsWith("[Z")) {
            return true;
        }
        if (c.getName().endsWith("[C")) {
            return true;
        }
        if (c.getName().endsWith("[B")) {
            return true;
        }
        if (c.getName().endsWith("[S")) {
            return true;
        }
        if (c.getName().endsWith("[I")) {
            return true;
        }
        if (c.getName().endsWith("[J")) {
            return true;
        }
        if (c.getName().endsWith("[F")) {
            return true;
        }
        return c.getName().endsWith("[D");
    }

    public String exceptions(Class[] exceptions) {
        StringBuffer sb = new StringBuffer();
        if (exceptions.length == 0) {
            return "";
        }
        sb.append("throws");
        for (int index = 0; index < exceptions.length; ++index) {
            sb.append(" " + exceptions[index].getName());
            if (index == exceptions.length - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public String exceptions(Method m) {
        return this.exceptions(m.getExceptionTypes());
    }

    public String readLookup(String clazz) {
        StringBuffer sb = new StringBuffer();
        sb.append("sis.read" + this.writeLookup(clazz) + "();\n");
        return sb.toString();
    }

    public String argumentLookup(String clazz, String name) {
        String converted = this.baseConversion(clazz);
        if (converted != null) {
            return "new " + converted + " ( " + name + " )";
        }
        return name;
    }

    public String lookupConvert(String clazz) {
        if (clazz.equals("Boolean")) {
            return ".booleanValue()";
        }
        if (clazz.equals("Integer")) {
            return ".intValue()";
        }
        if (clazz.equals("Float")) {
            return ".floatValue()";
        }
        if (clazz.equals("Double")) {
            return ".doubleValue()";
        }
        if (clazz.equals("Long")) {
            return ".longValue()";
        }
        if (clazz.equals("Short")) {
            return ".shortValue()";
        }
        if (clazz.equals("Character")) {
            return ".charValue()";
        }
        if (clazz.equals("Byte")) {
            return ".byteValue()";
        }
        return "";
    }

    public String classLookup(String clazz) {
        if (clazz.equals("java.lang.String")) {
            return "String";
        }
        if (clazz.equals("boolean")) {
            return "Boolean";
        }
        if (clazz.equals("int")) {
            return "Integer";
        }
        if (clazz.equals("short")) {
            return "Short";
        }
        if (clazz.equals("long")) {
            return "Long";
        }
        if (clazz.equals("double")) {
            return "Double";
        }
        if (clazz.equals("float")) {
            return "Float";
        }
        if (clazz.equals("char")) {
            return "Character";
        }
        if (clazz.equals("byte")) {
            return "Byte";
        }
        return clazz;
    }

    public String writeLookup(String clazz) {
        if (clazz.equals("java.lang.String")) {
            return "String";
        }
        if (clazz.equals("boolean")) {
            return "Boolean";
        }
        if (clazz.equals("int")) {
            return "Int";
        }
        if (clazz.equals("short")) {
            return "Short";
        }
        if (clazz.equals("long")) {
            return "Long";
        }
        if (clazz.equals("double")) {
            return "Double";
        }
        if (clazz.equals("float")) {
            return "Float";
        }
        if (clazz.equals("char")) {
            return "Char";
        }
        if (clazz.equals("byte")) {
            return "Byte";
        }
        return "ObjectWL";
    }

    public String parameters(Method m) {
        StringBuffer sb = new StringBuffer();
        Class<?>[] parameters = m.getParameterTypes();
        if (parameters.length == 0) {
            return "";
        }
        for (int index = 0; index < parameters.length; ++index) {
            String className = this.expandArrayClass(parameters[index].getName());
            sb.append(" " + className);
            sb.append(" arg" + index);
            if (index == parameters.length - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public String expandArrayClass(String className) {
        if (!className.startsWith("[")) {
            return className;
        }
        StringBuffer result = new StringBuffer();
        if (className.endsWith(";")) {
            result.append(className.substring(className.lastIndexOf("[") + 2, className.length() - 1));
        } else if (className.endsWith("B")) {
            result.append("byte");
        } else if (className.endsWith("I")) {
            result.append("int");
        } else if (className.endsWith("S")) {
            result.append("short");
        } else if (className.endsWith("J")) {
            result.append("long");
        } else if (className.endsWith("Z")) {
            result.append("boolean");
        } else if (className.endsWith("D")) {
            result.append("double");
        } else if (className.endsWith("C")) {
            result.append("char");
        } else if (className.endsWith("F")) {
            result.append("float");
        }
        for (int index = 0; index < className.lastIndexOf("[") + 1; ++index) {
            result.append("[]");
        }
        return result.toString();
    }

    public String baseConversion(String toconvert) {
        String converted = null;
        if (toconvert.equals("boolean")) {
            converted = "Boolean";
        }
        if (toconvert.equals("int")) {
            converted = "Integer";
        }
        if (toconvert.equals("short")) {
            converted = "Short";
        }
        if (toconvert.equals("long")) {
            converted = "Long";
        }
        if (toconvert.equals("double")) {
            converted = "Double";
        }
        if (toconvert.equals("float")) {
            converted = "Float";
        }
        if (toconvert.equals("char")) {
            converted = "Character";
        }
        if (toconvert.equals("byte")) {
            converted = "Byte";
        }
        return converted;
    }

    public void setCompilerFactory(ICompilerFactory compilerFactory) {
        this.compilerFactory = compilerFactory;
    }

    public ICompilerFactory getCompilerFactory() {
        return this.compilerFactory;
    }

    public static class Output {
        private String outputFile;
        private String template;
        private List extraTemplates = new ArrayList();
        private String pkg;
        private List extraOutputFiles = new ArrayList();

        public Output() {
        }

        public Output(String output, String template, String pkg) {
            this.setOutputFile(output);
            this.setTemplate(template);
            this.setPackage(pkg);
        }

        public int hashCode() {
            return this.pkg == null ? this.outputFile.hashCode() : this.pkg.hashCode() ^ this.outputFile.hashCode();
        }

        public boolean equals(Object o) {
            try {
                Output o2 = (Output)o;
                return this.pkg == null ? this.outputFile.equals(o2.outputFile) : this.pkg.equals(o2.pkg) && this.outputFile.equals(o2.outputFile);
            }
            catch (ClassCastException cce) {
                return false;
            }
        }

        public String getOutputFile() {
            return this.outputFile;
        }

        public void setOutputFile(String s) {
            this.outputFile = s;
        }

        public String getTemplate() {
            return this.template;
        }

        public InputStream getTemplateStream(String templateName) throws IOException {
            InputStream is = this.getClass().getResourceAsStream(templateName);
            if (is == null) {
                is = Thread.currentThread().getContextClassLoader().getResourceAsStream(templateName);
            }
            if (is == null) {
                throw new FileNotFoundException("Production rule file '" + templateName + "' not found.");
            }
            return is;
        }

        public void setTemplate(String s) {
            this.template = s;
        }

        public void addExtraTemplate(String s) {
            this.extraTemplates.add(s);
        }

        public String[] getExtraTemplates() {
            String[] res = new String[this.extraTemplates.size()];
            this.extraTemplates.toArray(res);
            return res;
        }

        public void addExtraOutputFiles(List extraFiles) {
            this.extraOutputFiles.addAll(extraFiles);
        }

        public List getExtraOutputFiles() {
            return this.extraOutputFiles;
        }

        public String getPackage() {
            return this.pkg;
        }

        public void setPackage(String s) {
            this.pkg = s;
        }
    }
}

