/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.compiler;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import weblogic.utils.compiler.ToolFailureException;

public class ArgfileParser {
    private String argfileName;
    private boolean inQuotation = false;

    public ArgfileParser(String argfile) {
        this.argfileName = argfile;
    }

    public List<String> parse() throws ToolFailureException {
        ArrayList<String> args = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(this.argfileName));
            while (true) {
                int i;
                if ((i = reader.read()) < 0) {
                    if (sb.length() > 0) {
                        args.add(sb.toString());
                        sb.setLength(0);
                    }
                    break;
                }
                char c = (char)i;
                if (c == '\"') {
                    this.inQuotation = !this.inQuotation;
                    continue;
                }
                if (c == ' ' || c == '\t') {
                    if (this.inQuotation) {
                        sb.append(c);
                        continue;
                    }
                    if (sb.length() <= 0) continue;
                    args.add(sb.toString());
                    sb.setLength(0);
                    continue;
                }
                if (c == '\r' || c == '\n') {
                    if (sb.length() <= 0) continue;
                    args.add(sb.toString());
                    sb.setLength(0);
                    continue;
                }
                sb.append(c);
            }
        }
        catch (FileNotFoundException e) {
            throw new ToolFailureException("Failed to parse argfile!", e);
        }
        catch (IOException e) {
            throw new ToolFailureException("Failed to parse argfile!", e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return args;
    }
}

